/*
 * $Id: EditElementWizard.java,v 1.5 2004/06/07 06:46:20 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * EditElementWizard.
 * TODO: privides extension point element editor. pluggable element edit page.
 */
public class EditElementWizard extends Wizard {

	static Object[] elementEditPages = new Object[]{
		"a", AElementWizardPage.class,
		"img", ImgElementWizardPage.class,
		"dl", ListElementWizardPage.class,
		"ul", ListElementWizardPage.class,
		"ol", ListElementWizardPage.class,
		"table", TableElementWizardPage.class
	};

	String targetElemName;
	ITextEditor htEditor;
	EditElementWizardPage rootPage;

	/**
	 * Second argument specify element name,
	 * If specify null, call new element edit wizard page.
	 */
	public EditElementWizard(ITextEditor editor, String targetElemName) {
		htEditor = editor;
		this.targetElemName = targetElemName;
		
		setWindowTitle("Edit HTML Element");
		setDefaultPageImageDescriptor(
			WebpubUIPlugin.getImageDescriptor("wizban/editelem_wiz.gif"));
		
		setForcePreviousAndNextButtons(true);
	}

	public void addPages() {
		if( targetElemName == null){
			rootPage = new NewElementWizardPage();
		}else{
			IDocument doc = getDocument();
			rootPage = createElementEditPage(targetElemName);
			rootPage.setEditType(EditElementWizardPage.MODIFY);
		}
		addPage( rootPage );
	}

	public boolean performFinish() {
		IWizardPage page = rootPage;
		for(IWizardPage p; (p = page.getNextPage()) != null;){
			page = p;
		}
		if(page instanceof EditElementWizardPage){
			((EditElementWizardPage)page).performFinish();
		}
		return true;
	}
	
	public IDocument getDocument() {
		return htEditor.getDocumentProvider().getDocument( htEditor.getEditorInput() );
	}

	public ITextSelection getSelection() {
		return (ITextSelection)htEditor.getSelectionProvider().getSelection();
	}
	
	public void setSelection(ITextSelection sel){
		htEditor.getSelectionProvider().setSelection(sel);
	}
	
	public IFile getCurrentEditFile() {
		IEditorInput input = htEditor.getEditorInput();
		return (input instanceof IFileEditorInput) ? ((IFileEditorInput)input).getFile() : null;
	}
	
	/**
	 * If not edit target returns UnknownElementWizardPage.
	 */
	public EditElementWizardPage createElementEditPage(String elementName){
		EditElementWizardPage page = null;
		try{
			for (int i = 0; i < elementEditPages.length; i+=2) {
				if( ((String)elementEditPages[i]).equalsIgnoreCase(elementName) ){
					Class klass = (Class)elementEditPages[i+1];
					page = (EditElementWizardPage)klass.newInstance();
				}
			}
		} catch(InstantiationException e) {
			WebpubUIPlugin.handleException(e);
		} catch (IllegalAccessException e) {
			WebpubUIPlugin.handleException(e);
		}
		if( page == null){
			page = new UnknownElementWizardPage();
		}
		page.setElementName(elementName);
		page.setWizard(this);
		
		return page;
	}


}