/*
 * $Id: TemplateNameInputWizardPage.java,v 1.3 2004/06/07 06:46:19 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

import com.narucy.webpub.core.template.*;

/**
 * 
 */
class TemplateNameInputWizardPage extends WizardPage implements IPreviewer {

	static IInputValidator validator = new IInputValidator() {
		public String isValid(String str) {
			if( !Pattern.matches("^\\w+$", str) ){
				return "Template name must be english characters.";
			}
			return null;
		}
	};

	Combo tmplsCombo;
	Text preview;
	String tmplName;
	boolean flipToNext = false;

	public TemplateNameInputWizardPage() {
		super("InsertTemplateWizardPage");
		setTitle("Insert Template");
		setDescription("Insert Template, already created template or new template.");
	}
	
	public void createControl(Composite parent) {
		Composite base = new Composite( parent, SWT.NONE);
		setControl(base);
		base.setLayout(new GridLayout(2, false));
		
		new Label(base, SWT.NONE).setText("T&emplate name:");
		tmplsCombo = new Combo(base, SWT.BORDER);
		tmplsCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		tmplsCombo.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				templateSelection();
			}
		});
		preview = InsertTemplateWizard.createPreview(base);
		
		// init values
		Template[] globalTmpls = ((InsertTemplateWizard)getWizard()).getTemplateManager().getGlobalTemplates();
		for(int i=0; i<globalTmpls.length; i++){
			tmplsCombo.add(globalTmpls[i].getName());
		}
		
		tmplsCombo.forceFocus();
	}
	
	void templateSelection(){
		tmplName = tmplsCombo.getText();
		
		String errResult = validator.isValid(tmplName);
		setErrorMessage(errResult);

		TemplateManager tmplMgr = ((InsertTemplateWizard)getWizard()).getTemplateManager();
		
		flipToNext = false;
		if(tmplMgr.isContainGlobalTemplate(tmplName)){
			Template t = tmplMgr.getGlobalTemplate(tmplName);
			preview.setText( t.getJoinedLines() );
			((TemplateContentSelectionWizardPage)getNextPage()).setTemplateName(tmplName);
			if( isContentsIncluded(t) ){
				flipToNext = true;
			}
		}else{
			updateTemplateName();
		}
		getWizard().getContainer().updateButtons();
	}
	
	static boolean isContentsIncluded(Template tmpl){
		if( tmpl.getName().equals(Template.NAME_CONTENTS) ){
			return true;
		}
		Template[] ts = tmpl.getChildrenTemplates();
		for(int i=0; i<ts.length; i++){
			if( isContentsIncluded(ts[i]) ){
				return true;
			}
		}
		return false;
	}

	public boolean canFlipToNextPage() {
		return super.canFlipToNextPage() && flipToNext;
	}
	
	void updateTemplateName(){
		if( getErrorMessage() == null){
			StringBuffer buff = new StringBuffer();
			String content = ((InsertTemplateWizard)getWizard()).getTextSelection().getText();

			buff.append("<!-- $begin:" + tmplName + "$ -->");
			if( content.length() > 0 && content.charAt(0) != '\n'){
				buff.append('\n');
			}
			buff.append(content);
			if( content.length() <= 0 || content.charAt(content.length() - 1) != '\n'){
				buff.append('\n');
			}
			buff.append("<!-- $end:" + tmplName + "$ -->\n");
			
			preview.setText(buff.toString());
		}else{
			preview.setText("");
		}
	}
	
	public String getPreviewText(){
		return (preview != null) ? preview.getText().replaceAll("\r", "") : null;
	}

}
