/*
 * $Id: TocPropertySource.java,v 1.3 2004/06/07 06:46:20 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.ui.views.properties.*;

import com.narucy.webpub.core.toc.Topic;

/**
 * TocPropertySource
 */
class TocPropertySource implements IPropertySource {

	final static Integer
		HREF = new Integer(0),
		LABEL = new Integer(1);

	Topic topic;

	public void setTopic(Topic t) {
		this.topic = t;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[]{
			new TextPropertyDescriptor(HREF, "Href"),
			new TextPropertyDescriptor(LABEL, "Label")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(HREF)){
			String href = topic.getHref();
			return href != null ? href : "";
		}
		if(id.equals(LABEL)){
			String label = topic.getLabel();
			return label != null ? label : "";
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return getPropertyValue(id) != null;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object val) {
		String v = (String)val;
		if(id.equals(HREF)){
			topic.setHref(v.length() > 0 ? v : null);
		}
		if(id.equals(LABEL)){
			topic.setLabel(v.length() > 0 ? v : null);
		}
		topic.getToc().fireChanged();
	}

}
