/*
 * $Id: TocTreeEditor.java,v 1.7 2004/06/07 06:46:20 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.part.EditorPart;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
class TocTreeEditor extends EditorPart {

	final TocMultiPageEditor parentEditor;

	IContainer publishFolder;

	TocEditBlock block;
	Composite base;
	CLabel titleLabel;
	
	Font titleFont;
	Image bgImage;
	
	boolean dirty;
	
	public TocTreeEditor(TocMultiPageEditor parentEditor) {
		this.parentEditor = parentEditor;
	}

	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public void gotoMarker(IMarker marker) {
		// not implements
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		setSite(site);
		setInput(input);
		try {
			IProject proj = ((IFileEditorInput) input).getFile().getProject();
			WebProject wp = (WebProject) proj.getNature(WebProject.ID_NATURE);
			publishFolder = wp.getFolder(WebProject.PUBLISH_FOLDER);
		} catch (CoreException e) {
			throw new PartInitException(e.getStatus());
		}
	}

	public boolean isDirty() {
		return false;
	}

	public boolean isSaveAsAllowed() {
		return true;
	}

	public void createPartControl(Composite parent) {
		parent.setLayout(new FillLayout());
		
		// create widget foundation
		Display disp = parent.getDisplay();
		Color bgColor = disp.getSystemColor(SWT.COLOR_WHITE);
		
		FontData[] fontData = parent.getFont().getFontData();
		for (int i = 0; i < fontData.length; i++) {
			FontData d = fontData[i];
			fontData[i] = new FontData(d.getName(), d.getHeight()*3/2, SWT.BOLD);
		}
		titleFont = new Font(disp, fontData);
		bgImage = WebpubUIPlugin.createImage("form_banner.gif");
		
		// create controls
		base = new Composite(parent, SWT.NONE);
		GridLayout gl = new GridLayout(1, true);
		gl.marginWidth = 0;
		gl.marginHeight = 0;
		base.setLayout(gl);
		base.setBackground(bgColor);
		
		titleLabel = new CLabel(base, SWT.NONE);
		titleLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		titleLabel.setText("Sitemap");
		titleLabel.setFont(titleFont);
		titleLabel.setBackground(bgImage);
		
		block = new TocEditBlock(base);
		block.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		block.setBackground(bgColor);
		
		block.getTocTree().addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				Object topic = ((IStructuredSelection)event.getSelection()).getFirstElement();
				if(topic instanceof Topic){
					IWorkbenchPage page = parentEditor.getSite().getPage();
					try {
						page.showView(IPageLayout.ID_PROP_SHEET, null, IWorkbenchPage.VIEW_ACTIVATE);
					} catch (PartInitException e) {
						WebpubUIPlugin.handleException(e);
					}
				}
			}
		});
		
		// set input and selection provider
		block.setInput(publishFolder, parentEditor.getToc());
		getSite().setSelectionProvider(block.getTocTree());
	}

	public void setFocus() {
	}

	public TocEditBlock getBlock() {
		return block;
	}

	public void dispose() {
		titleFont.dispose();
		bgImage.dispose();
		super.dispose();
	}

}
