/*
 * $Id: WebProjectTocPage.java,v 1.5 2004/06/07 06:46:16 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.List;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.*;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.TocFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * WebProjectTocPage.
 */
public class WebProjectTocPage extends PropertyPage {

	Button addButton, editButton, removeButton;

	TableViewer viewer;
	WebProject webProject;
	
	protected Control createContents(Composite parent) {
		IProject proj = (IProject)getElement().getAdapter(IProject.class);
		try {
			webProject = (WebProject) proj.getNature(WebProject.ID_NATURE);
		} catch (CoreException e) {
			throw new RuntimeException(e);
		}
		
		Composite base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(2, false));
		
		Label labe = new Label(base, SWT.NONE);
		labe.setText("Toc files:");
		new Label(base, SWT.NONE);
		
		viewer = new TableViewer(base);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(new LabelProvider(){

			WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();
			
			public String getText(Object file){
				if( file instanceof IFile){
					return ((IFile)file).getProjectRelativePath().toString();
				}
				return workbenchProvider.getText(file);
			}
			
			public Image getImage(Object file){
				return workbenchProvider.getImage(file);
			}
			
			public void dispose(){
				workbenchProvider.dispose();
			}
			
		});
		
		viewer.setInput( toFileList(webProject.getArray(WebProject.TOC_PATHES)) );
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.verticalSpan = 3;
		viewer.getControl().setLayoutData(gd);
		
		addButton = createButton(base, "&Add");
		editButton = createButton(base, "&Edit");
		removeButton = createButton(base, "&Remove");
		
		return base;
	}
	
	Object[] resourceInput(){
		ResourceSelectionDialog dialog = new ResourceSelectionDialog(getShell(), webProject.getProject(), "Toc files"){
			protected boolean select(IResource resource){
				return TocFactory.isTocResources(resource);
			}
		};
		dialog.setInitialElementSelections( (List)viewer.getInput() );
		return (dialog.open() == Window.OK) ? dialog.getResult() : null;
	}
	
	void addTocResources(boolean clearList){
		final Object[] inputItems = resourceInput();
		if(inputItems != null){
			final List tocFiles = (List)viewer.getInput();
			if(clearList){
				tocFiles.clear();
			}
			IRunnableWithProgress progress = new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					try{
						monitor.beginTask("Checking toc resources", inputItems.length+1);
						for(int i=0; i<inputItems.length; i++){
							IResource f = (IResource)inputItems[i];
							if(!tocFiles.contains(f)){
								if( TocFactory.isTocResources(f)){
									tocFiles.add(f);
								}
								monitor.worked(1);
							}
						}
						viewer.refresh();
					}finally{
						monitor.done();
					}
				}
			};
			
			try {
				new ProgressMonitorDialog(getShell()).run(false, true, progress);
			} catch (InvocationTargetException e) {
				WebpubUIPlugin.handleException(e);
			} catch (InterruptedException e) {
			}
		}
	}
	
	void removeTocResources(){
		List tocFiles = (List)viewer.getInput();
		Object[] items = ((IStructuredSelection)viewer.getSelection()).toArray();
		for (int i = 0; i < items.length; i++) {
			tocFiles.remove(items[i]);
		}
		viewer.refresh();
	}
	
	SelectionListener buttonHandler = new SelectionListener() {
		public void widgetSelected(SelectionEvent e) {
			if(e.widget.equals(addButton)){
				addTocResources(false);
			}else if(e.widget.equals(editButton)){
				addTocResources(true);
			}else if(e.widget.equals(removeButton)){
				removeTocResources();
			}
		}

		public void widgetDefaultSelected(SelectionEvent e) {}
	};

	Button createButton(Composite parent, String text){
		Button button = new Button(parent, SWT.PUSH);
		button.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.HORIZONTAL_ALIGN_FILL));
		button.setText(text);
		button.addSelectionListener(buttonHandler);
		return button;
	}

	List toFileList(String[] vals){
		ArrayList list = new ArrayList();
		for(int i=0; i<vals.length; i++){
			list.add( webProject.getProject().getFile(vals[i]) );
		}
		return list;
	}

	protected void performDefaults() {
		List tocFiles = (List)viewer.getInput();
		tocFiles.clear();
		tocFiles.addAll( Arrays.asList(webProject.getDefaultArray(WebProject.TOC_PATHES)) );
		viewer.refresh();
	}

	public boolean performOk() {
		List files = (List)viewer.getInput();
		String[] filesString = new String[files.size()];
		for(int i=0; i<files.size(); i++){
			filesString[i] = ((IFile)files.get(i)).getProjectRelativePath().toString();	
		}
		webProject.setValue(WebProject.TOC_PATHES, filesString);
		try {
			webProject.storePreferences();
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
			return false;
		}
		return super.performOk();
	}

}
