/*
 * $Id: NewWebProjectWizard.java,v 1.10 2004/06/07 15:08:33 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.preset.Preset;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;

/**
 * NewWebProjectWizard 
 */
public class NewWebProjectWizard extends BasicNewProjectResourceWizard {

	WizardNewProjectCreationPage mainPage = createNewProjectPage();
	WebProjectStructureWizardPage structurePage = new WebProjectStructureWizardPage();
	PresetSelectionWizardPage presetPage = new PresetSelectionWizardPage();
	
	IProject newProject = null;
	
	public IProject getNewProject() {
		return newProject;
	}
	
	public NewWebProjectWizard() {
		setWindowTitle("New Web Project");
		setNeedsProgressMonitor(true);
	}

	WizardNewProjectCreationPage createNewProjectPage(){
		WizardNewProjectCreationPage page = new WizardNewProjectCreationPage("WizardNewProjectCreationPage");
		page.setDescription("Enter the required data to generate website source files");
		page.setTitle("Web Project");
		page.setImageDescriptor(WebpubUIPlugin.getImageDescriptor("wizban/newwebproj_wiz.gif"));
		return page;
	}

	public void addPages() {
		addPage(mainPage);
		addPage(structurePage);
		addPage(presetPage);
	}

	public boolean canFinish() {
		if(super.canFinish()){
			return getContainer().getCurrentPage().equals( getPages()[ getPageCount()-1 ] );
		}
		return false;
	}

	public boolean performFinish() {
		createProject();
		if(newProject == null){
			return false;
		}
		updatePerspective();
		selectAndReveal(newProject);
		return true;
	}
	
	void createProject(){
		try {
			final IProject project = mainPage.getProjectHandle();
			getContainer().run(false, true, new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					monitor.beginTask("Create project resources", 2);
					
					try {
						// create and store project file
						WebProjectStructureBlock block = structurePage.getBlock();
						try{
							Preset preset = presetPage.getSelectedPreset();
							preset.distribute(
									project,
									block.getPath(WebProject.HTSOURCES_FOLDER),
									block.getPath(WebProject.SCRIPTS_FOLDER),
									block.getPath(WebProject.PUBLISH_FOLDER),
									new SubProgressMonitor(monitor, 1));
						}catch(CoreException e){
							throw new InvocationTargetException(e);
						}
					} finally{
						monitor.done();
					}
				}
			});
			newProject = project;
		} catch (InvocationTargetException e) {
			WebpubUIPlugin.handleException(e);
		} catch  (InterruptedException e) {
			WebpubUIPlugin.handleException(e);
		}
	}

}
