/*
 * $Id: WebProjectStructureWizardPage.java,v 1.4 2004/06/07 06:46:22 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;


import org.eclipse.core.runtime.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

import com.narucy.webpub.core.IStatusChangeListener;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;


/**
 * 
 */
public class WebProjectStructureWizardPage extends WizardPage implements IStatusChangeListener {

	WebProjectStructureBlock block = new WebProjectStructureBlock(this);

	public WebProjectStructureWizardPage() {
		super("NewWebProjectWizardPage", "Web Project Folders", WebpubUIPlugin.getImageDescriptor("wizban/newwebproj_wiz.gif"));
		setDescription("Enter the web project auther infomation");
	}

	public void statusChanged(IStatus status) {
		switch (status.getSeverity()) {
			case IStatus.ERROR:
				setErrorMessage(status.getMessage());
				setMessage(null);
				break;
			case IStatus.WARNING:
				setMessage(status.getMessage(), WARNING);
				setErrorMessage(null);
				break;
			case IStatus.OK:
				setErrorMessage(null);
				setMessage(null);
				setPageComplete(true);
				break;
		}
	}

	public void createControl(Composite parent) {
		try {
			setControl( block.createControl(parent, null) );
			block.setFolderData("ht_sources", "scripts", "public_html");
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
		}
	}

	public WebProjectStructureBlock getBlock(){
		return block;
	}

}
