require 'amritatmpl/navipage'
require 'lib/rdf'
require 'webpub/publisher'

class SelfLinkFilter < Webpub::HTFilter

	def initialize
		@after = '<span class="selfpage">\1</span>'
	end

	def filter(desc, lines)
		basename = File.basename(desc.publish_to)
		lines.
			gsub(%r!<a\s+href="#{basename}".*?>(.+?)</a>!, @after).
			gsub(%r!^<\?.*\?>$!, '')
	end

end

class MenuDecorationFilter < Webpub::HTFilter

	def filter(desc, lines)
		if %r!.*/(.+?)/.+.html$! === desc.publish_to
			cate = $1
			if File.basename(desc.web_project[:publish_dir]) == cate
				
				cate = 'home'
				unless /index\.html$/ === desc.publish_to
					return lines
				end
			end
			
			lines.gsub!(%r!<img src="(.+?)" alt="(.+?)" width="(\d+?)".*?>!) { |line|
				menu_item_code, alt, width = $1, $2, $3
				if menu_item_code.gsub!(/b_#{cate}_l\.png$/, File.basename(desc.publish_to) == 'index.html' ? "b_#{cate}_s.png" : "b_#{cate}_sl.png")
					%Q!<img src="#{menu_item_code}" alt="#{alt}" width="#{width}" height="32">!
				else
					line
				end
			}
		end
		
		lines
	end

end

class Base < NaviPage

	def initialize(desc)
		super(desc)
		@begining = Time.gm(2003, 8, 30)
		desc.ht_filters << SelfLinkFilter.new << MenuDecorationFilter.new
	end

	def handle_error(k)
		puts "#{@description.publish_to} - #{k}"
	end

	def last_update
		strftime(Time.now)
	end

	def strftime(time)
		time = Time.parse(time) unless time.is_a?(Time)
		time.strftime('%Y.%m.%d')
	end

	def years
		now = Time.now
		@begining.year == now.year ?  now.year.to_s : "#{@begining.year}-#{now.year}"
	end

	def para( msg)
		Amrita::SanitizedString[ '<p>' + msg.split(%r!\n\n+!).join('</p><p>') + '</p>']
	end

end
