require 'base'
require 'lib/itemstore'

class ItemIndex < Base

	def initialize(desc)
		if %r!(\w)/index(\d?)\.html$! === desc.publish_to
			@category, idx = $1, $2
			if idx.empty?
				@page_index = 1
			else
				@page_index = $2.to_i
			end
		else
			raise "illegal publish location: #{desc.publish_to}"
		end
		desc.publish_to.sub!('index?.html', 'index.html')
		
		super(desc)
		@store = ItemStore.instance(desc.web_project[:items_csv])
		
		self[:enable_prev_page] = if @page_index >= 2
			prev_idx = @page_index-1
			prev_href = prev_idx == 1 ? "index.html" : "index#{prev_idx}.html"
			{ :href => prev_href }
		else
			nil
		end
		
		self[:enable_next_page] = @store.page_count(@category) > @page_index ?
			{ :href => "index#{@page_index+1}.html" } : nil
		
		self[:disable_prev_page] = !self[:enable_prev_page]
		self[:disable_next_page] = !self[:enable_next_page]
	end
	
	def disp_range
		bgn, ed = @store.item_index_as_page(@category, @page_index)
		all = @store.itemcodes_by_category(@category).size
		{:begin_index => bgn + 1, :end_index => ed + 1, :all_count => all }
	end
	
	def indexies
		page_count = @store.page_count(@category)
		(1 .. page_count).map { |idx|
			{:index_num => idx, :href => idx == 1 ? "index.html" : "index#{idx}.html"}
		}
	end

	def items
		items = @store.itemcodes_by_category(@category, @page_index)
		unless items
			raise "Illegal state: #{@category}, #{@page_index}"
		end
		items.map { |code|
			@store.item_with_linkdata(code)
		}
	end

end
