class ItemStore

	@@instances = {}

	def ItemStore.instance(csvfile)
		csvfile = File.expand_path(csvfile)
		unless @@instances.key?(csvfile)
			@@instances[csvfile] = ItemStore.new(csvfile)
		else
			@@instances[csvfile]
		end
	end

	def initialize(cvsfile)
		@cvsfile = cvsfile
		@items = {}
		@categories = []
		@unitcounts = Hash.new(5)
		
		refresh(cvsfile)
	end
	
	attr_reader :items, :categories, :unitcounts
	
	def refresh(cvsfile = @cvsfile)
		@items.clear
		@categories.clear
		
		IO.foreach(cvsfile) do |line|
			line.gsub!('"', '')
			code, price, name, description = *line.split(',').map { |v| v.strip }
			@items[code] = {
				:price => price,
				:name => name,
				:description => description
			}
			cate = code[0, 1]
			@categories << cate unless @categories.include?(cate)
		end
	end

	def item_index_as_page(cate, page_num)
		uc = unitcounts[cate]
		
		last = itemcodes_by_category(cate).size - 1
		bgn = (page_num - 1) * uc
		if bgn > last
			raise ArgumentError, "out of page index: #{page_num} by #{cate}, #{last}"
		end
		ed = bgn + uc - 1
		ed = last if ed > last
		
		return bgn, ed
	end

	def items_as_page(cate, page_num)
		bgn, ed = item_index_as_page(cate, page_num)
		itemcodes_by_category(cate)[bgn .. ed]
	end

	def item_with_linkdata(code, image_size = 'normal')
		entry = @items[code]
		unless entry
			raise ArgumentError, "specify code is invalid: #{code}"
		end
		
		dir = "/items/#{code[0, 1]}"
		entry[:img_src] = "#{dir}/#{code}-#{image_size}.png"
		entry[:href] = "#{dir}/#{code}.html"
		
		entry
	end
	
	def itemcodes_by_category(cate, page_index = nil)
		items = @items.map { |code, item| code[0, 1] == cate ? code : nil }.compact.sort
		if page_index
			uc = @unitcounts[cate]
			begin_index = (page_index - 1) * uc
			items = items[begin_index, begin_index + uc]
		end
		items
	end
	
	def page_count(cate)
		(itemcodes_by_category(cate).size - 1) / @unitcounts[cate] + 1
	end

end
