require 'singleton'
require 'time'
require 'rexml/document'

class RDF
	
	include Enumerable
	
	@@doc_instances = Hash.new { |hash, file|
		hash[file] = RDF.new(file)
	}
	
	def RDF::instance(file)
		@@doc_instances[File.expand_path(file)]
	end
	
	def initialize(file)
		@doc = REXML::Document.new(IO.read(file))
		@title = @doc.root.get_text('channel/title').to_s
		@url = @doc.root.get_text('channel/link').to_s
		@description = @doc.root.get_text('channel/description').to_s
	end
	
	attr_reader :title, :url, :description

	def each
		@doc.root.each_element('item') { |e|
			item = {}
			e.elements.each { |e|
				key = e.name.intern
				v = e.text.to_s
				
				key = :url if key == :link
				v = Time.parse(v) if key == :date
				
				item[key] = v
			}
			yield item
		}
	end

end
