require 'test/unit'
require 'tempfile'
require 'fileutils'

class TocUpdaterTest < Test::Unit::TestCase
	
	def setup
		$: << File.dirname(__FILE__) + '/../../'
		require 'lib/toc_updater'
		foundation_path = File.join(File.dirname(__FILE__), 'test_foundation.toc')
		@updater = TocUpdater.new(foundation_path)
		
		@tmpfile = Dir::tmpdir + '/tmp.toc'
	end
	
	def test_item_index_nodes
		doc, nodes = @updater.item_index_nodes
		assert_equal %w!a b c d e f!, nodes.keys.sort
		assert_not_equal doc.hash, @updater.document.hash
	end
	
	def test_dist
		csv_path = File.join(File.dirname(__FILE__), 'test_items.csv')
		@updater.dist(csv_path, @tmpfile)
		
		doc = REXML::Document.new(IO.read(@tmpfile))
		
		values = Hash.new { |hash, k| hash[k] = [] }
		doc.root.get_elements('topic/topic').select { |e|
			if %r!/(\w)/index\d?\.html$! === e.attributes['href']
				values[$1] << e
			end
		}
		
		assert_equal(1, values['a'].size)
		assert_equal(1, values['b'].size)
		assert_equal(1, values['c'].size)
		assert_equal(2, values['d'].size)
		assert_equal(2, values['e'].size)
		assert_equal(3, values['f'].size)
		
		assert_equal(1, values['a'][0].size)
		assert_equal(2, values['b'][0].size)
		assert_equal(5, values['c'][0].size)
		assert_equal(5, values['d'][0].size)
		assert_equal(1, values['d'][1].size)
		assert_equal(5, values['e'][1].size)
		assert_equal(1, values['f'][2].size)
	end
	
	def teardown
		FileUtils.rm_f(@tmpfile)
	end
	
end
