/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class BVDecomposeSegCVSub
implements OptionHandler {
    protected boolean m_Debug;
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_ClassifierOptions;
    protected int m_ClassifyIterations;
    protected String m_DataFileName;
    protected int m_ClassIndex = -1;
    protected int m_Seed = 1;
    protected double m_KWBias;
    protected double m_KWVariance;
    protected double m_KWSigma;
    protected double m_WBias;
    protected double m_WVariance;
    protected double m_Error;
    protected int m_TrainSize;
    protected double m_P;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(8);
        vector.addElement(new Option(LocalString.get("\tThe index of the class attribute.\n") + LocalString.get("\t(default last)"), "c", 1, LocalString.get("-c <class index>")));
        vector.addElement(new Option(LocalString.get("\tTurn on debugging output."), "D", 0, "-D"));
        vector.addElement(new Option(LocalString.get("\tThe number of times each instance is classified.\n") + LocalString.get("\t(default 10)"), "l", 1, LocalString.get("-l <num>")));
        vector.addElement(new Option(LocalString.get("\tThe average proportion of instances common between any two training sets\n"), "p", 1, LocalString.get("-p <proportion of objects in common>")));
        vector.addElement(new Option(LocalString.get("\tThe random number seed used."), "s", 1, LocalString.get("-s <seed>")));
        vector.addElement(new Option(LocalString.get("\tThe name of the arff file used for the decomposition."), "t", 1, LocalString.get("-t <name of arff file>")));
        vector.addElement(new Option(LocalString.get("\tThe number of instances in the training set."), "T", 1, LocalString.get("-T <number of instances in training set>")));
        vector.addElement(new Option(LocalString.get("\tFull class name of the learner used in the decomposition.\n") + LocalString.get("\teg: weka.classifiers.bayes.NaiveBayes"), "W", 1, LocalString.get("-W <classifier class name>")));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to learner ") + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setClassIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(string));
            }
        } else {
            this.setClassIndex(0);
        }
        String string2 = Utils.getOption('l', stringArray);
        if (string2.length() != 0) {
            this.setClassifyIterations(Integer.parseInt(string2));
        } else {
            this.setClassifyIterations(10);
        }
        String string3 = Utils.getOption('p', stringArray);
        if (string3.length() != 0) {
            this.setP(Double.parseDouble(string3));
        } else {
            this.setP(-1.0);
        }
        String string4 = Utils.getOption('s', stringArray);
        if (string4.length() != 0) {
            this.setSeed(Integer.parseInt(string4));
        } else {
            this.setSeed(1);
        }
        String string5 = Utils.getOption('t', stringArray);
        if (string5.length() == 0) {
            throw new Exception(LocalString.get("An arff file must be specified") + LocalString.get(" with the -t option."));
        }
        this.setDataFileName(string5);
        String string6 = Utils.getOption('T', stringArray);
        if (string6.length() != 0) {
            this.setTrainSize(Integer.parseInt(string6));
        } else {
            this.setTrainSize(-1);
        }
        String string7 = Utils.getOption('W', stringArray);
        if (string7.length() == 0) {
            throw new Exception(LocalString.get("A learner must be specified with the -W option."));
        }
        this.setClassifier(Classifier.forName(string7, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 14];
        int n = 0;
        if (this.getDebug()) {
            stringArray2[n++] = "-D";
        }
        stringArray2[n++] = "-c";
        stringArray2[n++] = "" + this.getClassIndex();
        stringArray2[n++] = "-l";
        stringArray2[n++] = "" + this.getClassifyIterations();
        stringArray2[n++] = "-p";
        stringArray2[n++] = "" + this.getP();
        stringArray2[n++] = "-s";
        stringArray2[n++] = "" + this.getSeed();
        if (this.getDataFileName() != null) {
            stringArray2[n++] = "-t";
            stringArray2[n++] = "" + this.getDataFileName();
        }
        stringArray2[n++] = "-T";
        stringArray2[n++] = "" + this.getTrainSize();
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setClassifyIterations(int n) {
        this.m_ClassifyIterations = n;
    }

    public int getClassifyIterations() {
        return this.m_ClassifyIterations;
    }

    public void setDataFileName(String string) {
        this.m_DataFileName = string;
    }

    public String getDataFileName() {
        return this.m_DataFileName;
    }

    public int getClassIndex() {
        return this.m_ClassIndex + 1;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n - 1;
    }

    public double getKWBias() {
        return this.m_KWBias;
    }

    public double getWBias() {
        return this.m_WBias;
    }

    public double getKWVariance() {
        return this.m_KWVariance;
    }

    public double getWVariance() {
        return this.m_WVariance;
    }

    public double getKWSigma() {
        return this.m_KWSigma;
    }

    public void setTrainSize(int n) {
        this.m_TrainSize = n;
    }

    public int getTrainSize() {
        return this.m_TrainSize;
    }

    public void setP(double d) {
        this.m_P = d;
    }

    public double getP() {
        return this.m_P;
    }

    public double getError() {
        return this.m_Error;
    }

    public void decompose() throws Exception {
        Object[] objectArray;
        int n;
        int n2;
        int n3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_DataFileName));
        Instances instances = new Instances(bufferedReader);
        if (this.m_ClassIndex < 0) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(this.m_ClassIndex);
        }
        if (instances.classAttribute().type() != 1) {
            throw new Exception(LocalString.get("Class attribute must be nominal"));
        }
        int n4 = instances.numClasses();
        instances.deleteWithMissingClass();
        if (instances.checkForStringAttributes()) {
            throw new Exception(LocalString.get("Can't handle string attributes!"));
        }
        if (instances.numInstances() <= 2) {
            throw new Exception(LocalString.get("Dataset size must be greater than 2."));
        }
        if (this.m_TrainSize == -1) {
            this.m_TrainSize = (int)Math.floor((double)instances.numInstances() / 2.0);
        } else if (this.m_TrainSize < 0 || this.m_TrainSize >= instances.numInstances() - 1) {
            throw new Exception(LocalString.get("Training set size of ") + this.m_TrainSize + LocalString.get(" is invalid."));
        }
        if (this.m_P == -1.0) {
            this.m_P = (double)this.m_TrainSize / ((double)instances.numInstances() - 1.0);
        } else if (this.m_P < (double)this.m_TrainSize / ((double)instances.numInstances() - 1.0) || this.m_P >= 1.0) {
            throw new Exception(LocalString.get("Proportion is not in range: ") + (double)this.m_TrainSize / ((double)instances.numInstances() - 1.0) + LocalString.get(" <= p < 1.0 "));
        }
        int n5 = (int)Math.ceil((double)this.m_TrainSize / this.m_P + 1.0);
        int n6 = (int)Math.ceil((double)n5 / ((double)n5 - (double)this.m_TrainSize));
        if (n6 > n5) {
            throw new Exception(LocalString.get("The required number of folds is too many.") + LocalString.get("Change p or the size of the training set."));
        }
        int n7 = (int)Math.floor((double)instances.numInstances() / (double)n5);
        double[][] dArray = new double[instances.numInstances()][n4];
        int[][] nArray = new int[n6][2];
        Vector<int[]> vector = new Vector<int[]>(n7 + 1);
        Random random = new Random(this.m_Seed);
        instances.randomize(random);
        int n8 = 0;
        for (n3 = 1; n3 <= n7 + 1; ++n3) {
            int[] nArray2;
            if (n3 > n7) {
                nArray2 = new int[instances.numInstances() - n7 * n5];
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    nArray2[n2] = n8++;
                }
                vector.add(nArray2);
                continue;
            }
            nArray2 = new int[n5];
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                nArray2[n2] = n8++;
            }
            vector.add(nArray2);
        }
        n3 = n5 % n6;
        int n9 = (int)Math.ceil((double)n5 / (double)n6);
        n2 = 0;
        for (n = 0; n < n6; ++n) {
            if (n3 == 0 || n == n3) {
                // empty if block
            }
            nArray[n][0] = n2;
            nArray[n][1] = --n9;
            n2 += n9;
        }
        for (n = 0; n < this.m_ClassifyIterations; ++n) {
            for (int i = 1; i <= n7; ++i) {
                objectArray = (int[])vector.get(i - 1);
                this.randomize((int[])objectArray, random);
                for (int j = 1; j <= n6; ++j) {
                    Object object;
                    int n10;
                    int n11;
                    Instances instances2 = null;
                    for (int k = 1; k <= n6; ++k) {
                        if (k == j) continue;
                        int n12 = nArray[k - 1][0];
                        n9 = nArray[k - 1][1];
                        n11 = n12 + n9 - 1;
                        for (n10 = n12; n10 <= n11; ++n10) {
                            if (instances2 == null) {
                                instances2 = new Instances(instances, objectArray[n10], 1);
                                continue;
                            }
                            instances2.add(instances.instance(objectArray[n10]));
                        }
                    }
                    instances2.randomize(random);
                    if (this.getTrainSize() > instances2.numInstances()) {
                        throw new Exception(LocalString.get("The training set size of ") + this.getTrainSize() + LocalString.get(", is greater than the training pool ") + instances2.numInstances());
                    }
                    Instances instances3 = new Instances(instances2, 0, this.m_TrainSize);
                    Classifier classifier = Classifier.makeCopy(this.m_Classifier);
                    classifier.buildClassifier(instances3);
                    n10 = nArray[j - 1][1];
                    int n13 = n11 + n10 - 1;
                    for (n11 = nArray[j - 1][0]; n11 <= n13; ++n11) {
                        object = instances.instance(objectArray[n11]);
                        int n14 = (int)classifier.classifyInstance((Instance)object);
                        if ((double)n14 != ((Instance)object).classValue()) {
                            this.m_Error += 1.0;
                        }
                        double[] dArray2 = dArray[objectArray[n11]];
                        int n15 = n14;
                        dArray2[n15] = dArray2[n15] + 1.0;
                    }
                    if (i != 1 || j != 1) continue;
                    object = (int[])vector.lastElement();
                    for (int k = 0; k < ((Object)object).length; ++k) {
                        Instance instance = instances.instance((int)object[k]);
                        int n16 = (int)classifier.classifyInstance(instance);
                        if ((double)n16 != instance.classValue()) {
                            this.m_Error += 1.0;
                        }
                        double[] dArray3 = dArray[object[k]];
                        int n17 = n16;
                        dArray3[n17] = dArray3[n17] + 1.0;
                    }
                }
            }
        }
        this.m_Error /= (double)(this.m_ClassifyIterations * instances.numInstances());
        this.m_KWBias = 0.0;
        this.m_KWVariance = 0.0;
        this.m_KWSigma = 0.0;
        this.m_WBias = 0.0;
        this.m_WVariance = 0.0;
        for (n = 0; n < instances.numInstances(); ++n) {
            int n18;
            Instance instance = instances.instance(n);
            objectArray = dArray[n];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            Vector vector2 = this.findCentralTendencies((double[])objectArray);
            if (vector2 == null) {
                throw new Exception(LocalString.get("Central tendency was null."));
            }
            for (n18 = 0; n18 < n4; ++n18) {
                double d6 = instance.classValue() == (double)n18 ? 1.0 : 0.0;
                int n19 = objectArray[n18] / (double)this.m_ClassifyIterations;
                d += (d6 - n19) * (d6 - n19) - n19 * (1.0 - n19) / (double)(this.m_ClassifyIterations - 1);
                d2 += n19 * n19;
                d3 += d6 * d6;
            }
            this.m_KWBias += d;
            this.m_KWVariance += 1.0 - d2;
            this.m_KWSigma += 1.0 - d3;
            for (n18 = 0; n18 < vector2.size(); ++n18) {
                int n20 = 0;
                int n21 = 0;
                int n22 = (Integer)vector2.get(n18);
                for (int i = 0; i < n4; ++i) {
                    if (i != (int)instance.classValue() && i == n22) {
                        n20 = (int)((double)n20 + objectArray[i]);
                    }
                    if (i == (int)instance.classValue() || i == n22) continue;
                    n21 = (int)((double)n21 + objectArray[i]);
                }
                d4 += (double)n20;
                d5 += (double)n21;
            }
            this.m_WBias += d4 / (double)(vector2.size() * this.m_ClassifyIterations);
            this.m_WVariance += d5 / (double)(vector2.size() * this.m_ClassifyIterations);
        }
        this.m_KWBias /= 2.0 * (double)instances.numInstances();
        this.m_KWVariance /= 2.0 * (double)instances.numInstances();
        this.m_KWSigma /= 2.0 * (double)instances.numInstances();
        this.m_WBias /= (double)instances.numInstances();
        this.m_WVariance /= (double)instances.numInstances();
        if (this.m_Debug) {
            System.err.println(LocalString.get("Decomposition finished"));
        }
    }

    public Vector findCentralTendencies(double[] dArray) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < dArray.length; ++i) {
            n2 = (int)dArray[i];
            if (n2 > n) {
                vector.clear();
                vector.addElement(new Integer(i));
                n = n2;
                continue;
            }
            if (n2 == 0 || n2 != n) continue;
            vector.addElement(new Integer(i));
        }
        if (n != 0) {
            return vector;
        }
        return null;
    }

    public String toString() {
        String string = LocalString.get("\nBias-Variance Decomposition Segmentation, Cross Validation\n") + LocalString.get("with subsampling.\n");
        if (this.getClassifier() == null) {
            return LocalString.get("Invalid setup");
        }
        string = string + LocalString.get("\nClassifier    : ") + this.getClassifier().getClass().getName();
        if (this.getClassifier() instanceof OptionHandler) {
            string = string + Utils.joinOptions(this.m_Classifier.getOptions());
        }
        string = string + LocalString.get("\nData File     : ") + this.getDataFileName();
        string = string + LocalString.get("\nClass Index   : ");
        string = this.getClassIndex() == 0 ? string + "last" : string + this.getClassIndex();
        string = string + LocalString.get("\nIterations    : ") + this.getClassifyIterations();
        string = string + "\np             : " + this.getP();
        string = string + LocalString.get("\nTraining Size : ") + this.getTrainSize();
        string = string + LocalString.get("\nSeed          : ") + this.getSeed();
        string = string + LocalString.get("\n\nDefinition   : ") + LocalString.get("Kohavi and Wolpert");
        string = string + LocalString.get("\nError         :") + Utils.doubleToString(this.getError(), 4);
        string = string + LocalString.get("\nBias^2        :") + Utils.doubleToString(this.getKWBias(), 4);
        string = string + LocalString.get("\nVariance      :") + Utils.doubleToString(this.getKWVariance(), 4);
        string = string + LocalString.get("\nSigma^2       :") + Utils.doubleToString(this.getKWSigma(), 4);
        string = string + LocalString.get("\n\nDefinition   : ") + "Webb";
        string = string + LocalString.get("\nError         :") + Utils.doubleToString(this.getError(), 4);
        string = string + LocalString.get("\nBias          :") + Utils.doubleToString(this.getWBias(), 4);
        string = string + LocalString.get("\nVariance      :") + Utils.doubleToString(this.getWVariance(), 4);
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            BVDecomposeSegCVSub bVDecomposeSegCVSub = new BVDecomposeSegCVSub();
            try {
                bVDecomposeSegCVSub.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + LocalString.get("\nBVDecompose Options:\n\n");
                Enumeration enumeration = bVDecomposeSegCVSub.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            bVDecomposeSegCVSub.decompose();
            System.out.println(bVDecomposeSegCVSub.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public final void randomize(int[] nArray, Random random) {
        for (int i = nArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }
}

