/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.InputStreamReader;
import weka.LocalString;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.functions.Logistic;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class CostCurve {
    public static final String RELATION_NAME = "CostCurve";
    public static final String PROB_COST_FUNC_NAME = LocalString.get("Probability Cost Function");
    public static final String NORM_EXPECTED_COST_NAME = LocalString.get("Normalized Expected Cost");
    public static final String THRESHOLD_NAME = "Threshold";

    public Instances getCurve(FastVector fastVector) {
        if (fastVector.size() == 0) {
            return null;
        }
        return this.getCurve(fastVector, ((NominalPrediction)fastVector.elementAt(0)).distribution().length - 1);
    }

    public Instances getCurve(FastVector fastVector, int n) {
        if (fastVector.size() == 0 || ((NominalPrediction)fastVector.elementAt(0)).distribution().length <= n) {
            return null;
        }
        ThresholdCurve thresholdCurve = new ThresholdCurve();
        Instances instances = thresholdCurve.getCurve(fastVector, n);
        Instances instances2 = this.makeHeader();
        int n2 = instances.attribute(ThresholdCurve.FP_RATE_NAME).index();
        int n3 = instances.attribute(ThresholdCurve.TP_RATE_NAME).index();
        int n4 = instances.attribute(THRESHOLD_NAME).index();
        for (int i = 0; i < instances.numInstances(); ++i) {
            double d = instances.instance(i).value(n2);
            double d2 = instances.instance(i).value(n3);
            double d3 = instances.instance(i).value(n4);
            double[] dArray = new double[]{0.0, d, d3};
            instances2.add(new Instance(1.0, dArray));
            dArray = new double[]{1.0, 1.0 - d2, d3};
            instances2.add(new Instance(1.0, dArray));
        }
        return instances2;
    }

    private Instances makeHeader() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute(PROB_COST_FUNC_NAME));
        fastVector.addElement(new Attribute(NORM_EXPECTED_COST_NAME));
        fastVector.addElement(new Attribute(THRESHOLD_NAME));
        return new Instances(RELATION_NAME, fastVector, 100);
    }

    public static void main(String[] stringArray) {
        try {
            Instances instances = new Instances(new InputStreamReader(System.in));
            instances.setClassIndex(instances.numAttributes() - 1);
            CostCurve costCurve = new CostCurve();
            EvaluationUtils evaluationUtils = new EvaluationUtils();
            Logistic logistic = new Logistic();
            FastVector fastVector = new FastVector();
            for (int i = 0; i < 2; ++i) {
                evaluationUtils.setSeed(i);
                fastVector.appendElements(evaluationUtils.getCVPredictions(logistic, instances, 10));
            }
            Instances instances2 = costCurve.getCurve(fastVector);
            System.out.println(instances2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

