/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class Winnow
extends Classifier
implements UpdateableClassifier {
    protected boolean m_Balanced;
    protected int m_numIterations = 1;
    protected double m_Alpha = 2.0;
    protected double m_Beta = 0.5;
    protected double m_Threshold = -1.0;
    protected int m_Seed = 1;
    protected int m_Mistakes;
    protected double m_defaultWeight = 2.0;
    private double[] m_predPosVector = null;
    private double[] m_predNegVector = null;
    private double m_actualThreshold;
    private Instances m_Train = null;
    private NominalToBinary m_NominalToBinary;
    private ReplaceMissingValues m_ReplaceMissingValues;

    public String globalInfo() {
        return LocalString.get("Implements Winnow and Balanced Winnow algorithms by ") + LocalString.get("Littlestone. For more information, see\n\n") + LocalString.get("N. Littlestone (1988). \"Learning quickly when irrelevant ") + LocalString.get("attributes are abound: A new linear threshold algorithm\". ") + LocalString.get("Machine Learning 2, pp. 285-318.\n\n") + "and\n\n" + LocalString.get("N. Littlestone (1989). \"Mistake bounds and logarithmic  ") + LocalString.get("linear-threshold learning algorithms\". Technical report ") + LocalString.get("UCSC-CRL-89-11, University of California, Santa Cruz.\n\n") + LocalString.get("Does classification for problems with nominal attributes ") + LocalString.get("(which it converts into binary attributes).");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option(LocalString.get("\tUse the baLanced version\n") + LocalString.get("\t(default false)"), "L", 0, "-L"));
        vector.addElement(new Option(LocalString.get("\tThe number of iterations to be performed.\n") + LocalString.get("\t(default 1)"), "I", 1, LocalString.get("-I <int>")));
        vector.addElement(new Option(LocalString.get("\tPromotion coefficient alpha.\n") + LocalString.get("\t(default 2.0)"), "A", 1, LocalString.get("-A <double>")));
        vector.addElement(new Option(LocalString.get("\tDemotion coefficient beta.\n") + LocalString.get("\t(default 0.5)"), "B", 1, LocalString.get("-B <double>")));
        vector.addElement(new Option(LocalString.get("\tPrediction threshold.\n") + LocalString.get("\t(default -1.0 == number of attributes)"), "H", 1, LocalString.get("-H <double>")));
        vector.addElement(new Option(LocalString.get("\tStarting weights.\n") + LocalString.get("\t(default 2.0)"), "W", 1, LocalString.get("-W <double>")));
        vector.addElement(new Option(LocalString.get("\tDefault random seed.\n") + LocalString.get("\t(default 1)"), "S", 1, LocalString.get("-S <int>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        this.m_Balanced = Utils.getFlag('L', stringArray);
        String string6 = Utils.getOption('I', stringArray);
        if (string6.length() != 0) {
            this.m_numIterations = Integer.parseInt(string6);
        }
        if ((string5 = Utils.getOption('A', stringArray)).length() != 0) {
            this.m_Alpha = new Double(string5);
        }
        if ((string4 = Utils.getOption('B', stringArray)).length() != 0) {
            this.m_Beta = new Double(string4);
        }
        if ((string3 = Utils.getOption('H', stringArray)).length() != 0) {
            this.m_Threshold = new Double(string3);
        }
        if ((string2 = Utils.getOption('W', stringArray)).length() != 0) {
            this.m_defaultWeight = new Double(string2);
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.m_Seed = Integer.parseInt(string);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[20];
        int n = 0;
        if (this.m_Balanced) {
            stringArray[n++] = "-L";
        }
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.m_numIterations;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_Alpha;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.m_Beta;
        stringArray[n++] = "-H";
        stringArray[n++] = "" + this.m_Threshold;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.m_defaultWeight;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Seed;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Can't handle string attributes!"));
        }
        if (instances.numClasses() > 2) {
            throw new Exception(LocalString.get("Can only handle two-class datasets!"));
        }
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException(LocalString.get("Can't handle a numeric class!"));
        }
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.isNominal()) continue;
            throw new UnsupportedAttributeTypeException(LocalString.get("Winnow: only nominal attributes, ") + "please.");
        }
        this.m_Train = new Instances(instances);
        this.m_Train.deleteWithMissingClass();
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_ReplaceMissingValues);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_NominalToBinary);
        if (this.m_Seed != -1) {
            this.m_Train.randomize(new Random(this.m_Seed));
        }
        this.m_predPosVector = new double[this.m_Train.numAttributes()];
        if (this.m_Balanced) {
            this.m_predNegVector = new double[this.m_Train.numAttributes()];
        }
        for (n = 0; n < this.m_Train.numAttributes(); ++n) {
            this.m_predPosVector[n] = this.m_defaultWeight;
        }
        if (this.m_Balanced) {
            for (n = 0; n < this.m_Train.numAttributes(); ++n) {
                this.m_predNegVector[n] = this.m_defaultWeight;
            }
        }
        this.m_actualThreshold = this.m_Threshold < 0.0 ? (double)this.m_Train.numAttributes() - 1.0 : this.m_Threshold;
        this.m_Mistakes = 0;
        if (this.m_Balanced) {
            for (n = 0; n < this.m_numIterations; ++n) {
                for (int i = 0; i < this.m_Train.numInstances(); ++i) {
                    this.actualUpdateClassifierBalanced(this.m_Train.instance(i));
                }
            }
        } else {
            for (n = 0; n < this.m_numIterations; ++n) {
                for (int i = 0; i < this.m_Train.numInstances(); ++i) {
                    this.actualUpdateClassifier(this.m_Train.instance(i));
                }
            }
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        this.m_ReplaceMissingValues.batchFinished();
        Instance instance2 = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(instance2);
        this.m_NominalToBinary.batchFinished();
        instance2 = this.m_NominalToBinary.output();
        if (this.m_Balanced) {
            this.actualUpdateClassifierBalanced(instance2);
        } else {
            this.actualUpdateClassifier(instance2);
        }
    }

    private void actualUpdateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            double d = this.makePrediction(instance);
            if (d != instance.classValue()) {
                ++this.m_Mistakes;
                double d2 = d == 0.0 ? this.m_Alpha : this.m_Beta;
                int n = instance.numValues();
                int n2 = this.m_Train.classIndex();
                for (int i = 0; i < n; ++i) {
                    if (instance.index(i) == n2 || instance.valueSparse(i) != 1.0) continue;
                    int n3 = instance.index(i);
                    this.m_predPosVector[n3] = this.m_predPosVector[n3] * d2;
                }
            }
        } else {
            System.out.println(LocalString.get("CLASS MISSING"));
        }
    }

    private void actualUpdateClassifierBalanced(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            double d = this.makePredictionBalanced(instance);
            if (d != instance.classValue()) {
                double d2;
                double d3;
                ++this.m_Mistakes;
                if (d == 0.0) {
                    d3 = this.m_Alpha;
                    d2 = this.m_Beta;
                } else {
                    d3 = this.m_Beta;
                    d2 = this.m_Alpha;
                }
                int n = instance.numValues();
                int n2 = this.m_Train.classIndex();
                for (int i = 0; i < n; ++i) {
                    if (instance.index(i) == n2 || instance.valueSparse(i) != 1.0) continue;
                    int n3 = instance.index(i);
                    this.m_predPosVector[n3] = this.m_predPosVector[n3] * d3;
                    int n4 = instance.index(i);
                    this.m_predNegVector[n4] = this.m_predNegVector[n4] * d2;
                }
            }
        } else {
            System.out.println(LocalString.get("CLASS MISSING"));
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        this.m_ReplaceMissingValues.batchFinished();
        Instance instance2 = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(instance2);
        this.m_NominalToBinary.batchFinished();
        instance2 = this.m_NominalToBinary.output();
        if (this.m_Balanced) {
            return this.makePredictionBalanced(instance2);
        }
        return this.makePrediction(instance2);
    }

    private double makePrediction(Instance instance) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = this.m_Train.classIndex();
        for (int i = 0; i < n; ++i) {
            if (instance.index(i) == n2 || instance.valueSparse(i) != 1.0) continue;
            d += this.m_predPosVector[instance.index(i)];
        }
        if (d > this.m_actualThreshold) {
            return 1.0;
        }
        return 0.0;
    }

    private double makePredictionBalanced(Instance instance) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = this.m_Train.classIndex();
        for (int i = 0; i < n; ++i) {
            if (instance.index(i) == n2 || instance.valueSparse(i) != 1.0) continue;
            d += this.m_predPosVector[instance.index(i)] - this.m_predNegVector[instance.index(i)];
        }
        if (d > this.m_actualThreshold) {
            return 1.0;
        }
        return 0.0;
    }

    public String toString() {
        if (this.m_predPosVector == null) {
            return LocalString.get("Winnow: No model built yet.");
        }
        String string = LocalString.get("Winnow\n\nAttribute weights\n\n");
        int n = this.m_Train.classIndex();
        if (!this.m_Balanced) {
            for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
                if (i == n) continue;
                string = string + "w" + i + " " + this.m_predPosVector[i] + "\n";
            }
        } else {
            for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
                if (i == n) continue;
                string = string + "w" + i + " p " + this.m_predPosVector[i];
                string = string + " n " + this.m_predNegVector[i];
                double d = this.m_predPosVector[i] - this.m_predNegVector[i];
                string = string + " d " + d + "\n";
            }
        }
        string = string + LocalString.get("\nCumulated mistake count: ") + this.m_Mistakes + "\n\n";
        return string;
    }

    public String balancedTipText() {
        return LocalString.get("Whether to use the balanced version of the algorithm.");
    }

    public boolean getBalanced() {
        return this.m_Balanced;
    }

    public void setBalanced(boolean bl) {
        this.m_Balanced = bl;
    }

    public String alphaTipText() {
        return LocalString.get("Promotion coefficient alpha.");
    }

    public double getAlpha() {
        return this.m_Alpha;
    }

    public void setAlpha(double d) {
        this.m_Alpha = d;
    }

    public String betaTipText() {
        return LocalString.get("Demotion coefficient beta.");
    }

    public double getBeta() {
        return this.m_Beta;
    }

    public void setBeta(double d) {
        this.m_Beta = d;
    }

    public String thresholdTipText() {
        return LocalString.get("Prediction threshold (-1 means: set to number of attributes).");
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public void setThreshold(double d) {
        this.m_Threshold = d;
    }

    public String defaultWeightTipText() {
        return LocalString.get("Initial value of weights/coefficients.");
    }

    public double getDefaultWeight() {
        return this.m_defaultWeight;
    }

    public void setDefaultWeight(double d) {
        this.m_defaultWeight = d;
    }

    public String numIterationsTipText() {
        return LocalString.get("The number of iterations to be performed.");
    }

    public int getNumIterations() {
        return this.m_numIterations;
    }

    public void setNumIterations(int n) {
        this.m_numIterations = n;
    }

    public String seedTipText() {
        return LocalString.get("Random number seed used for data shuffling (-1 means no ") + "randomization).";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Winnow(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

