/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.classifiers.IteratedSingleClassifierEnhancer;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.meta.Bagging;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class MetaCost
extends RandomizableSingleClassifierEnhancer {
    public static final int MATRIX_ON_DEMAND = 1;
    public static final int MATRIX_SUPPLIED = 2;
    public static final Tag[] TAGS_MATRIX_SOURCE = new Tag[]{new Tag(1, LocalString.get("Load cost matrix on demand")), new Tag(2, LocalString.get("Use explicit cost matrix"))};
    protected int m_MatrixSource = 1;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    protected String m_CostFile;
    protected CostMatrix m_CostMatrix = new CostMatrix(1);
    protected int m_NumIterations = 10;
    protected int m_BagSizePercent = 100;

    public String globalInfo() {
        return LocalString.get("This metaclassifier makes its base classifier cost-sensitive using the ") + LocalString.get("method specified in\n\n") + LocalString.get("Pedro Domingos (1999) \"MetaCost: A general method for making classifiers ") + LocalString.get("cost-sensitive\", Proceedings of the Fifth International Conference on ") + LocalString.get("Knowledge Discovery and Data Mining, pp 155-164.\n\n") + LocalString.get("This classifier should produce similar results to one created by ") + LocalString.get("passing the base learner to Bagging, which is in turn passed to a ") + LocalString.get("CostSensitiveClassifier operating on minimum expected cost. The difference ") + LocalString.get("is that MetaCost produces a single cost-sensitive classifier of the ") + LocalString.get("base learner, giving the benefits of fast classification and interpretable ") + LocalString.get("output (if the base learner itself is interpretable). This implementation  ") + LocalString.get("uses all bagging iterations when reclassifying training data (the MetaCost ") + LocalString.get("paper reports a marginal improvement when only those iterations containing ") + LocalString.get("each training instance are used in reclassifying that instance).");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option(LocalString.get("\tNumber of bagging iterations.\n") + LocalString.get("\t(default 10)"), "I", 1, LocalString.get("-I <num>")));
        vector.addElement(new Option(LocalString.get("\tFile name of a cost matrix to use. If this is not supplied,\n") + LocalString.get("\ta cost matrix will be loaded on demand. The name of the\n") + LocalString.get("\ton-demand file is the relation name of the training data\n") + LocalString.get("\tplus \".cost\", and the path to the on-demand file is\n") + LocalString.get("\tspecified with the -N option."), "C", 1, LocalString.get("-C <cost file name>")));
        vector.addElement(new Option(LocalString.get("\tName of a directory to search for cost files when loading\n") + LocalString.get("\tcosts on demand (default current directory)."), "N", 1, LocalString.get("-N <directory>")));
        vector.addElement(new Option(LocalString.get("\tThe cost matrix in Matlab single line format."), "cost-matrix", 1, LocalString.get("-cost-matrix <matrix>")));
        vector.addElement(new Option(LocalString.get("\tSize of each bag, as a percentage of the\n") + LocalString.get("\ttraining set size. (default 100)"), "P", 1, "-P"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('I', stringArray);
        if (string2.length() != 0) {
            this.setNumIterations(Integer.parseInt(string2));
        } else {
            this.setNumIterations(10);
        }
        String string3 = Utils.getOption('P', stringArray);
        if (string3.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(string3));
        } else {
            this.setBagSizePercent(100);
        }
        String string4 = Utils.getOption('C', stringArray);
        if (string4.length() != 0) {
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(string4))));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
            this.m_CostFile = string4;
        } else {
            this.setCostMatrixSource(new SelectedTag(1, TAGS_MATRIX_SOURCE));
        }
        String string5 = Utils.getOption('N', stringArray);
        if (string5.length() != 0) {
            this.setOnDemandDirectory(new File(string5));
        }
        if ((string = Utils.getOption("cost-matrix", stringArray)).length() != 0) {
            StringWriter stringWriter = new StringWriter();
            CostMatrix.parseMatlab(string).write(stringWriter);
            this.setCostMatrix(new CostMatrix(new StringReader(stringWriter.toString())));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 6];
        int n = 0;
        if (this.m_MatrixSource == 2) {
            if (this.m_CostFile != null) {
                stringArray2[n++] = "-C";
                stringArray2[n++] = "" + this.m_CostFile;
            } else {
                stringArray2[n++] = "-cost-matrix";
                stringArray2[n++] = this.getCostMatrix().toMatlab();
            }
        } else {
            stringArray2[n++] = "-N";
            stringArray2[n++] = "" + this.getOnDemandDirectory();
        }
        stringArray2[n++] = "-I";
        stringArray2[n++] = "" + this.getNumIterations();
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.getBagSizePercent();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String costMatrixSourceTipText() {
        return LocalString.get("Gets the source location method of the cost matrix. Will ") + LocalString.get("be one of MATRIX_ON_DEMAND or MATRIX_SUPPLIED.");
    }

    public SelectedTag getCostMatrixSource() {
        return new SelectedTag(this.m_MatrixSource, TAGS_MATRIX_SOURCE);
    }

    public void setCostMatrixSource(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MATRIX_SOURCE) {
            this.m_MatrixSource = selectedTag.getSelectedTag().getID();
        }
    }

    public String onDemandDirectoryTipText() {
        return LocalString.get("Name of directory to search for cost files when loading ") + LocalString.get("costs on demand.");
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File file) {
        this.m_OnDemandDirectory = file.isDirectory() ? file : new File(file.getParent());
        this.m_MatrixSource = 1;
    }

    public String bagSizePercentTipText() {
        return LocalString.get("The size of each bag, as a percentage of the training set ") + "size.";
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int n) {
        this.m_BagSizePercent = n;
    }

    public String numIterationsTipText() {
        return LocalString.get("The number of bagging iterations.");
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String costMatrixTipText() {
        return LocalString.get("A misclassification cost matrix.");
    }

    public CostMatrix getCostMatrix() {
        return this.m_CostMatrix;
    }

    public void setCostMatrix(CostMatrix costMatrix) {
        this.m_CostMatrix = costMatrix;
        this.m_MatrixSource = 2;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Serializable serializable;
        Object object;
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException(LocalString.get("Class attribute must be nominal!"));
        }
        if (this.m_MatrixSource == 1) {
            object = instances.relationName() + CostMatrix.FILE_EXTENSION;
            serializable = new File(this.getOnDemandDirectory(), (String)object);
            if (!((File)serializable).exists()) {
                throw new Exception(LocalString.get("On-demand cost file doesn't exist: ") + serializable);
            }
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader((File)serializable))));
        }
        object = new Bagging();
        ((SingleClassifierEnhancer)object).setClassifier(this.getClassifier());
        ((RandomizableIteratedSingleClassifierEnhancer)object).setSeed(this.getSeed());
        ((IteratedSingleClassifierEnhancer)object).setNumIterations(this.getNumIterations());
        ((Bagging)object).setBagSizePercent(this.getBagSizePercent());
        ((Bagging)object).buildClassifier(instances);
        serializable = new Instances(instances);
        for (int i = 0; i < ((Instances)serializable).numInstances(); ++i) {
            Instance instance = ((Instances)serializable).instance(i);
            double[] dArray = ((Bagging)object).distributionForInstance(instance);
            int n = Utils.minIndex(this.m_CostMatrix.expectedCosts(dArray));
            instance.setClassValue(n);
        }
        this.m_Classifier.buildClassifier((Instances)serializable);
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_Classifier.classifyInstance(instance);
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
    }

    public String toString() {
        if (this.m_Classifier == null) {
            return LocalString.get("MetaCost: No model built yet.");
        }
        String string = LocalString.get("MetaCost cost sensitive classifier induction");
        string = string + LocalString.get("\nOptions: ") + Utils.joinOptions(this.getOptions());
        string = string + LocalString.get("\nBase learner: ") + this.getClassifierSpec() + LocalString.get("\n\nClassifier Model\n") + this.m_Classifier.toString() + LocalString.get("\n\nCost Matrix\n") + this.m_CostMatrix.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new MetaCost(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

