/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.LocalString;
import weka.classifiers.Evaluation;
import weka.classifiers.MultipleClassifiersCombiner;
import weka.core.Instance;
import weka.core.Instances;

public class Vote
extends MultipleClassifiersCombiner {
    public String globalInfo() {
        return LocalString.get("Class for combining classifiers using unweighted average of ") + LocalString.get("probability estimates (classification) or numeric predictions ") + "(regression).";
    }

    public void buildClassifier(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            this.getClassifier(i).buildClassifier(instances);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = this.getClassifier(0).distributionForInstance(instance);
        for (n = 1; n < this.m_Classifiers.length; ++n) {
            double[] dArray2 = this.getClassifier(n).distributionForInstance(instance);
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + dArray2[i];
            }
        }
        n = 0;
        while (n < dArray.length) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)this.m_Classifiers.length;
        }
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return LocalString.get("Vote: No model built yet.");
        }
        String string = LocalString.get("Vote combines");
        string = string + LocalString.get(" the probability distributions of these base learners:\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            string = string + '\t' + this.getClassifierSpec(i) + '\n';
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Vote(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

