/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.LocalString;

public class Statistics {
    protected static final double MACHEP = (double)1.110223E-16f;
    protected static final double MAXLOG = 709.782712893384;
    protected static final double MINLOG = -745.1332191019412;
    protected static final double MAXGAM = 171.6243769563027;
    protected static final double SQTPI = 2.5066282746310007;
    protected static final double SQRTH = 0.7071067811865476;
    protected static final double LOGPI = 1.1447298858494002;
    protected static final double big = 4.503599627370496E15;
    protected static final double biginv = 2.220446049250313E-16;
    protected static final double[] P0 = new double[]{-59.96335010141079, 98.00107541859997, -56.67628574690703, 13.931260938727968, -1.2391658386738125};
    protected static final double[] Q0 = new double[]{1.9544885833814176, 4.676279128988815, 86.36024213908905, -225.46268785411937, 200.26021238006066, -82.03722561683334, 15.90562251262117, -1.1833162112133};
    protected static final double[] P1 = new double[]{4.0554489230596245, 31.525109459989388, 57.16281922464213, 44.08050738932008, 14.684956192885803, 2.1866330685079025, -0.1402560791713545, -0.03504246268278482, -8.574567851546854E-4};
    protected static final double[] Q1 = new double[]{15.779988325646675, 45.39076351288792, 41.3172038254672, 15.04253856929075, 2.504649462083094, -0.14218292285478779, -0.03808064076915783, -9.332594808954574E-4};
    protected static final double[] P2 = new double[]{3.2377489177694603, 6.915228890689842, 3.9388102529247444, 1.3330346081580755, 0.20148538954917908, 0.012371663481782003, 3.0158155350823543E-4, 2.6580697468673755E-6, 6.239745391849833E-9};
    protected static final double[] Q2 = new double[]{6.02427039364742, 3.6798356385616087, 1.3770209948908132, 0.21623699359449663, 0.013420400608854318, 3.2801446468212774E-4, 2.8924786474538068E-6, 6.790194080099813E-9};

    public static double binomialStandardError(double d, int n) {
        if (n == 0) {
            return 0.0;
        }
        return Math.sqrt(d * (1.0 - d) / (double)n);
    }

    public static double chiSquaredProbability(double d, double d2) {
        if (d < 0.0 || d2 < 1.0) {
            return 0.0;
        }
        return Statistics.incompleteGammaComplement(d2 / 2.0, d / 2.0);
    }

    public static double FProbability(double d, int n, int n2) {
        return Statistics.incompleteBeta((double)n2 / 2.0, (double)n / 2.0, (double)n2 / ((double)n2 + (double)n * d));
    }

    public static double normalProbability(double d) {
        double d2;
        double d3 = d * 0.7071067811865476;
        double d4 = Math.abs(d3);
        if (d4 < 0.7071067811865476) {
            d2 = 0.5 + 0.5 * Statistics.errorFunction(d3);
        } else {
            d2 = 0.5 * Statistics.errorFunctionComplemented(d4);
            if (d3 > 0.0) {
                d2 = 1.0 - d2;
            }
        }
        return d2;
    }

    public static double normalInverse(double d) {
        double d2 = Math.sqrt(Math.PI * 2);
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d >= 1.0) {
            throw new IllegalArgumentException();
        }
        boolean bl = true;
        double d3 = d;
        if (d3 > 0.8646647167633873) {
            d3 = 1.0 - d3;
            bl = false;
        }
        if (d3 > 0.1353352832366127) {
            double d4 = (d3 -= 0.5) * d3;
            double d5 = d3 + d3 * (d4 * Statistics.polevl(d4, P0, 4) / Statistics.p1evl(d4, Q0, 8));
            return d5 *= d2;
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d3));
        double d7 = d6 - Math.log(d6) / d6;
        double d8 = 1.0 / d6;
        double d9 = d6 < 8.0 ? d8 * Statistics.polevl(d8, P1, 8) / Statistics.p1evl(d8, Q1, 8) : d8 * Statistics.polevl(d8, P2, 8) / Statistics.p1evl(d8, Q2, 8);
        d6 = d7 - d9;
        if (bl) {
            d6 = -d6;
        }
        return d6;
    }

    public static double lnGamma(double d) {
        double[] dArray = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] dArray2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] dArray3 = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (d < -34.0) {
            double d2 = -d;
            double d3 = Statistics.lnGamma(d2);
            double d4 = Math.floor(d2);
            if (d4 == d2) {
                throw new ArithmeticException(LocalString.get("lnGamma: Overflow"));
            }
            double d5 = d2 - d4;
            if (d5 > 0.5) {
                d5 = (d4 += 1.0) - d2;
            }
            if ((d5 = d2 * Math.sin(Math.PI * d5)) == 0.0) {
                throw new ArithmeticException(LocalString.get("lnGamma: Overflow"));
            }
            d5 = 1.1447298858494002 - Math.log(d5) - d3;
            return d5;
        }
        if (d < 13.0) {
            double d6 = 1.0;
            while (d >= 3.0) {
                d6 *= (d -= 1.0);
            }
            while (d < 2.0) {
                if (d == 0.0) {
                    throw new ArithmeticException(LocalString.get("lnGamma: Overflow"));
                }
                d6 /= d;
                d += 1.0;
            }
            if (d6 < 0.0) {
                d6 = -d6;
            }
            if (d == 2.0) {
                return Math.log(d6);
            }
            double d7 = (d -= 2.0) * Statistics.polevl(d, dArray2, 5) / Statistics.p1evl(d, dArray3, 6);
            return Math.log(d6) + d7;
        }
        if (d > 2.556348E305) {
            throw new ArithmeticException(LocalString.get("lnGamma: Overflow"));
        }
        double d8 = (d - 0.5) * Math.log(d) - d + 0.9189385332046728;
        if (d > 1.0E8) {
            return d8;
        }
        double d9 = 1.0 / (d * d);
        d8 = d >= 1000.0 ? (d8 += ((7.936507936507937E-4 * d9 - 0.002777777777777778) * d9 + 0.08333333333333333) / d) : (d8 += Statistics.polevl(d9, dArray, 4) / d);
        return d8;
    }

    static double errorFunction(double d) {
        double[] dArray = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] dArray2 = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(d) > 1.0) {
            return 1.0 - Statistics.errorFunctionComplemented(d);
        }
        double d2 = d * d;
        double d3 = d * Statistics.polevl(d2, dArray, 4) / Statistics.p1evl(d2, dArray2, 5);
        return d3;
    }

    static double errorFunctionComplemented(double d) {
        double d2;
        double d3;
        double[] dArray = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] dArray2 = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] dArray3 = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] dArray4 = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double d4 = d < 0.0 ? -d : d;
        if (d4 < 1.0) {
            return 1.0 - Statistics.errorFunction(d);
        }
        double d5 = -d * d;
        if (d5 < -709.782712893384) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        d5 = Math.exp(d5);
        if (d4 < 8.0) {
            d3 = Statistics.polevl(d4, dArray, 8);
            d2 = Statistics.p1evl(d4, dArray2, 8);
        } else {
            d3 = Statistics.polevl(d4, dArray3, 5);
            d2 = Statistics.p1evl(d4, dArray4, 6);
        }
        double d6 = d5 * d3 / d2;
        if (d < 0.0) {
            d6 = 2.0 - d6;
        }
        if (d6 == 0.0) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return d6;
    }

    static double p1evl(double d, double[] dArray, int n) {
        double d2 = d + dArray[0];
        for (int i = 1; i < n; ++i) {
            d2 = d2 * d + dArray[i];
        }
        return d2;
    }

    static double polevl(double d, double[] dArray, int n) {
        double d2 = dArray[0];
        for (int i = 1; i <= n; ++i) {
            d2 = d2 * d + dArray[i];
        }
        return d2;
    }

    static double incompleteGamma(double d, double d2) {
        if (d2 <= 0.0 || d <= 0.0) {
            return 0.0;
        }
        if (d2 > 1.0 && d2 > d) {
            return 1.0 - Statistics.incompleteGammaComplement(d, d2);
        }
        double d3 = d * Math.log(d2) - d2 - Statistics.lnGamma(d);
        if (d3 < -709.782712893384) {
            return 0.0;
        }
        d3 = Math.exp(d3);
        double d4 = d;
        double d5 = 1.0;
        double d6 = 1.0;
        while ((d5 *= d2 / (d4 += 1.0)) / (d6 += d5) > (double)1.110223E-16f) {
        }
        return d6 * d3 / d;
    }

    static double incompleteGammaComplement(double d, double d2) {
        double d3;
        if (d2 <= 0.0 || d <= 0.0) {
            return 1.0;
        }
        if (d2 < 1.0 || d2 < d) {
            return 1.0 - Statistics.incompleteGamma(d, d2);
        }
        double d4 = d * Math.log(d2) - d2 - Statistics.lnGamma(d);
        if (d4 < -709.782712893384) {
            return 0.0;
        }
        d4 = Math.exp(d4);
        double d5 = 1.0 - d;
        double d6 = d2 + d5 + 1.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = d2;
        double d10 = d2 + 1.0;
        double d11 = d6 * d2;
        double d12 = d10 / d11;
        do {
            double d13 = (d5 += 1.0) * (d7 += 1.0);
            double d14 = d10 * (d6 += 2.0) - d8 * d13;
            double d15 = d11 * d6 - d9 * d13;
            if (d15 != 0.0) {
                double d16 = d14 / d15;
                d3 = Math.abs((d12 - d16) / d16);
                d12 = d16;
            } else {
                d3 = 1.0;
            }
            d8 = d10;
            d10 = d14;
            d9 = d11;
            d11 = d15;
            if (!(Math.abs(d14) > 4.503599627370496E15)) continue;
            d8 *= 2.220446049250313E-16;
            d10 *= 2.220446049250313E-16;
            d9 *= 2.220446049250313E-16;
            d11 *= 2.220446049250313E-16;
        } while (d3 > (double)1.110223E-16f);
        return d12 * d4;
    }

    static double gamma(double d) {
        double[] dArray = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] dArray2 = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double d2 = Math.abs(d);
        if (d2 > 33.0) {
            if (d < 0.0) {
                double d3 = Math.floor(d2);
                if (d3 == d2) {
                    throw new ArithmeticException(LocalString.get("gamma: overflow"));
                }
                int n = (int)d3;
                double d4 = d2 - d3;
                if (d4 > 0.5) {
                    d4 = d2 - (d3 += 1.0);
                }
                if ((d4 = d2 * Math.sin(Math.PI * d4)) == 0.0) {
                    throw new ArithmeticException(LocalString.get("gamma: overflow"));
                }
                d4 = Math.abs(d4);
                d4 = Math.PI / (d4 * Statistics.stirlingFormula(d2));
                return -d4;
            }
            return Statistics.stirlingFormula(d);
        }
        double d5 = 1.0;
        while (d >= 3.0) {
            d5 *= (d -= 1.0);
        }
        while (d < 0.0) {
            if (d == 0.0) {
                throw new ArithmeticException(LocalString.get("gamma: singular"));
            }
            if (d > -1.0E-9) {
                return d5 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d5 /= d;
            d += 1.0;
        }
        while (d < 2.0) {
            if (d == 0.0) {
                throw new ArithmeticException(LocalString.get("gamma: singular"));
            }
            if (d < 1.0E-9) {
                return d5 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d5 /= d;
            d += 1.0;
        }
        if (d == 2.0 || d == 3.0) {
            return d5;
        }
        double d6 = Statistics.polevl(d -= 2.0, dArray, 6);
        d2 = Statistics.polevl(d, dArray2, 7);
        return d5 * d6 / d2;
    }

    static double stirlingFormula(double d) {
        double[] dArray = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double d2 = 143.01608;
        double d3 = 1.0 / d;
        double d4 = Math.exp(d);
        d3 = 1.0 + d3 * Statistics.polevl(d3, dArray, 4);
        if (d > d2) {
            double d5 = Math.pow(d, 0.5 * d - 0.25);
            d4 = d5 * (d5 / d4);
        } else {
            d4 = Math.pow(d, d - 0.5) / d4;
        }
        d4 = 2.5066282746310007 * d4 * d3;
        return d4;
    }

    public static double incompleteBeta(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7;
        if (d <= 0.0 || d2 <= 0.0) {
            throw new ArithmeticException(LocalString.get("ibeta: Domain error!"));
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            if (d3 == 0.0) {
                return 0.0;
            }
            if (d3 == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException(LocalString.get("ibeta: Domain error!"));
        }
        boolean bl = false;
        if (d2 * d3 <= 1.0 && d3 <= 0.95) {
            double d8 = Statistics.powerSeries(d, d2, d3);
            return d8;
        }
        double d9 = 1.0 - d3;
        if (d3 > d / (d + d2)) {
            bl = true;
            d7 = d2;
            d6 = d;
            d5 = d3;
            d4 = d9;
        } else {
            d7 = d;
            d6 = d2;
            d5 = d9;
            d4 = d3;
        }
        if (bl && d6 * d4 <= 1.0 && d4 <= 0.95) {
            double d10 = Statistics.powerSeries(d7, d6, d4);
            d10 = d10 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d10;
            return d10;
        }
        double d11 = d4 * (d7 + d6 - 2.0) - (d7 - 1.0);
        d9 = d11 < 0.0 ? Statistics.incompleteBetaFraction1(d7, d6, d4) : Statistics.incompleteBetaFraction2(d7, d6, d4) / d5;
        d11 = d7 * Math.log(d4);
        double d12 = d6 * Math.log(d5);
        if (d7 + d6 < 171.6243769563027 && Math.abs(d11) < 709.782712893384 && Math.abs(d12) < 709.782712893384) {
            d12 = Math.pow(d5, d6);
            d12 *= Math.pow(d4, d7);
            d12 /= d7;
            d12 *= d9;
            d12 *= Statistics.gamma(d7 + d6) / (Statistics.gamma(d7) * Statistics.gamma(d6));
            if (bl) {
                d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
            }
            return d12;
        }
        d11 += d12 + Statistics.lnGamma(d7 + d6) - Statistics.lnGamma(d7) - Statistics.lnGamma(d6);
        d12 = (d11 += Math.log(d9 / d7)) < -745.1332191019412 ? 0.0 : Math.exp(d11);
        if (bl) {
            d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
        }
        return d12;
    }

    static double incompleteBetaFraction1(double d, double d2, double d3) {
        double d4 = d;
        double d5 = d + d2;
        double d6 = d;
        double d7 = d + 1.0;
        double d8 = 1.0;
        double d9 = d2 - 1.0;
        double d10 = d7;
        double d11 = d + 2.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = 1.0;
        int n = 0;
        double d18 = 3.330669E-16f;
        do {
            double d19;
            double d20 = -(d3 * d4 * d5) / (d6 * d7);
            double d21 = d14 + d12 * d20;
            double d22 = d15 + d13 * d20;
            d12 = d14;
            d14 = d21;
            d13 = d15;
            d15 = d22;
            d20 = d3 * d8 * d9 / (d10 * d11);
            d21 = d14 + d12 * d20;
            d22 = d15 + d13 * d20;
            d12 = d14;
            d14 = d21;
            d13 = d15;
            d15 = d22;
            if (d22 != 0.0) {
                d17 = d21 / d22;
            }
            if (d17 != 0.0) {
                d19 = Math.abs((d16 - d17) / d17);
                d16 = d17;
            } else {
                d19 = 1.0;
            }
            if (d19 < d18) {
                return d16;
            }
            d4 += 1.0;
            d5 += 1.0;
            d6 += 2.0;
            d7 += 2.0;
            d8 += 1.0;
            d9 -= 1.0;
            d10 += 2.0;
            d11 += 2.0;
            if (Math.abs(d22) + Math.abs(d21) > 4.503599627370496E15) {
                d12 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d22) < 2.220446049250313E-16) && !(Math.abs(d21) < 2.220446049250313E-16)) continue;
            d12 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
        } while (++n < 300);
        return d16;
    }

    static double incompleteBetaFraction2(double d, double d2, double d3) {
        double d4 = d;
        double d5 = d2 - 1.0;
        double d6 = d;
        double d7 = d + 1.0;
        double d8 = 1.0;
        double d9 = d + d2;
        double d10 = d + 1.0;
        double d11 = d + 2.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = d3 / (1.0 - d3);
        double d17 = 1.0;
        double d18 = 1.0;
        int n = 0;
        double d19 = 3.330669E-16f;
        do {
            double d20;
            double d21 = -(d16 * d4 * d5) / (d6 * d7);
            double d22 = d14 + d12 * d21;
            double d23 = d15 + d13 * d21;
            d12 = d14;
            d14 = d22;
            d13 = d15;
            d15 = d23;
            d21 = d16 * d8 * d9 / (d10 * d11);
            d22 = d14 + d12 * d21;
            d23 = d15 + d13 * d21;
            d12 = d14;
            d14 = d22;
            d13 = d15;
            d15 = d23;
            if (d23 != 0.0) {
                d18 = d22 / d23;
            }
            if (d18 != 0.0) {
                d20 = Math.abs((d17 - d18) / d18);
                d17 = d18;
            } else {
                d20 = 1.0;
            }
            if (d20 < d19) {
                return d17;
            }
            d4 += 1.0;
            d5 -= 1.0;
            d6 += 2.0;
            d7 += 2.0;
            d8 += 1.0;
            d9 += 1.0;
            d10 += 2.0;
            d11 += 2.0;
            if (Math.abs(d23) + Math.abs(d22) > 4.503599627370496E15) {
                d12 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d23) < 2.220446049250313E-16) && !(Math.abs(d22) < 2.220446049250313E-16)) continue;
            d12 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
        } while (++n < 300);
        return d17;
    }

    static double powerSeries(double d, double d2, double d3) {
        double d4;
        double d5 = 1.0 / d;
        double d6 = (1.0 - d2) * d3;
        double d7 = d4 = d6 / (d + 1.0);
        double d8 = d6;
        double d9 = 2.0;
        double d10 = 0.0;
        double d11 = (double)1.110223E-16f * d5;
        while (Math.abs(d4) > d11) {
            d6 = (d9 - d2) * d3 / d9;
            d4 = (d8 *= d6) / (d + d9);
            d10 += d4;
            d9 += 1.0;
        }
        d10 += d7;
        d10 += d5;
        d6 = d * Math.log(d3);
        if (d + d2 < 171.6243769563027 && Math.abs(d6) < 709.782712893384) {
            d8 = Statistics.gamma(d + d2) / (Statistics.gamma(d) * Statistics.gamma(d2));
            d10 = d10 * d8 * Math.pow(d3, d);
        } else {
            d8 = Statistics.lnGamma(d + d2) - Statistics.lnGamma(d) - Statistics.lnGamma(d2) + d6 + Math.log(d10);
            d10 = d8 < -745.1332191019412 ? 0.0 : Math.exp(d8);
        }
        return d10;
    }

    public static void main(String[] stringArray) {
        System.out.println(LocalString.get("Binomial standard error (0.5, 100): ") + Statistics.binomialStandardError(0.5, 100));
        System.out.println(LocalString.get("Chi-squared probability (2.558, 10): ") + Statistics.chiSquaredProbability(2.558, 10.0));
        System.out.println(LocalString.get("Normal probability (0.2): ") + Statistics.normalProbability(0.2));
        System.out.println(LocalString.get("F probability (5.1922, 4, 5): ") + Statistics.FProbability(5.1922, 4, 5));
        System.out.println(LocalString.get("lnGamma(6): ") + Statistics.lnGamma(6.0));
    }
}

