/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.Random;
import weka.LocalString;
import weka.core.FastVector;
import weka.core.OptionHandler;

public final class Utils {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static Properties readProperties(String string) throws Exception {
        Properties properties = new Properties();
        try {
            properties.load(ClassLoader.getSystemResourceAsStream(string));
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("Warning, unable to load properties file from ") + LocalString.get("system resource (Utils.java)"));
        }
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        Properties properties2 = new Properties(properties);
        File file = new File(System.getProperties().getProperty("user.home") + File.separatorChar + string);
        if (file.exists()) {
            try {
                properties2.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                throw new Exception(LocalString.get("Problem reading user properties: ") + file);
            }
        }
        Properties properties3 = new Properties(properties2);
        file = new File(string);
        if (file.exists()) {
            try {
                properties3.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                throw new Exception(LocalString.get("Problem reading local properties: ") + file);
            }
        }
        return properties3;
    }

    public static final double correlation(double[] dArray, double[] dArray2, int n) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d += dArray[n2];
            d2 += dArray2[n2];
        }
        d /= (double)n;
        d2 /= (double)n;
        for (n2 = 0; n2 < n; ++n2) {
            d3 += (dArray[n2] - d) * (dArray[n2] - d);
            d4 += (dArray2[n2] - d2) * (dArray2[n2] - d2);
            d5 += (dArray[n2] - d) * (dArray2[n2] - d2);
        }
        double d6 = d3 * d4 == 0.0 ? 1.0 : d5 / Math.sqrt(Math.abs(d3 * d4));
        return d6;
    }

    public static String removeSubstring(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String replaceSubstring(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n) {
        return Utils.fixStringLength(string, n, false);
    }

    public static String padRight(String string, int n) {
        return Utils.fixStringLength(string, n, true);
    }

    private static String fixStringLength(String string, int n, boolean bl) {
        if (string.length() < n) {
            while (string.length() < n) {
                string = bl ? string.concat(" ") : " ".concat(string);
            }
        } else if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String doubleToString(double d, int n) {
        double d2 = d * Math.pow(10.0, n);
        if (Math.abs(d2) < 9.223372036854776E18) {
            int n2;
            long l = d2 > 0.0 ? (long)(d2 + 0.5) : -((long)(Math.abs(d2) + 0.5));
            StringBuffer stringBuffer = l == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(l));
            if (n == 0) {
                return stringBuffer.toString();
            }
            for (n2 = stringBuffer.length() - n; l < 0L && n2 < 1 || n2 < 0; ++n2) {
                if (l < 0L) {
                    stringBuffer.insert(1, '0');
                    continue;
                }
                stringBuffer.insert(0, '0');
            }
            stringBuffer.insert(n2, '.');
            if (l < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, '0');
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, '0');
            }
            int n3 = stringBuffer.length() - 1;
            while (n3 > n2 && stringBuffer.charAt(n3) == '0') {
                stringBuffer.setCharAt(n3--, ' ');
            }
            if (stringBuffer.charAt(n3) == '.') {
                stringBuffer.setCharAt(n3, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + d);
    }

    public static String doubleToString(double d, int n, int n2) {
        int n3;
        int n4;
        int n5;
        String string = Utils.doubleToString(d, n2);
        if (n2 >= n || string.indexOf(69) != -1) {
            return string;
        }
        char[] cArray = new char[n];
        for (n5 = 0; n5 < cArray.length; ++n5) {
            cArray[n5] = 32;
        }
        if (n2 > 0) {
            n4 = string.indexOf(46);
            if (n4 == -1) {
                n4 = string.length();
            } else {
                cArray[n - n2 - 1] = 46;
            }
        } else {
            n4 = string.length();
        }
        n5 = n - n2 - n4;
        if (n2 > 0) {
            --n5;
        }
        if (n5 < 0) {
            return string;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            cArray[n5 + n3] = string.charAt(n3);
        }
        for (n3 = n4 + 1; n3 < string.length(); ++n3) {
            cArray[n5 + n3] = string.charAt(n3);
        }
        return new String(cArray);
    }

    public static Class getArrayClass(Class clazz) {
        if (clazz.getComponentType().isArray()) {
            return Utils.getArrayClass(clazz.getComponentType());
        }
        return clazz.getComponentType();
    }

    public static int getArrayDimensions(Class clazz) {
        if (clazz.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(clazz.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object object) {
        return Utils.getArrayDimensions(object.getClass());
    }

    public static String arrayToString(Object object) {
        String string = "";
        int n = Utils.getArrayDimensions(object);
        if (n == 0) {
            string = "null";
        } else if (n == 1) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = Array.get(object, i) == null ? string + "null" : string + Array.get(object, i).toString();
            }
        } else {
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + "[" + Utils.arrayToString(Array.get(object, i)) + "]";
            }
        }
        return string;
    }

    public static boolean eq(double d, double d2) {
        return d - d2 < SMALL && d2 - d < SMALL;
    }

    public static void checkForRemainingOptions(String[] stringArray) throws Exception {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            ++n;
            stringBuffer.append(stringArray[i] + ' ');
        }
        if (n > 0) {
            throw new Exception(LocalString.get("Illegal options: ") + stringBuffer);
        }
    }

    public static boolean getFlag(char c, String[] stringArray) throws Exception {
        return Utils.getFlag("" + c, stringArray);
    }

    public static boolean getFlag(String string, String[] stringArray) throws Exception {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 1 || stringArray[i].charAt(0) != '-') continue;
            try {
                Double d = Double.valueOf(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (stringArray[i].equals("-" + string)) {
                    stringArray[i] = "";
                    return true;
                }
                if (stringArray[i].charAt(1) != '-') continue;
                return false;
            }
        }
        return false;
    }

    public static String getOption(char c, String[] stringArray) throws Exception {
        return Utils.getOption("" + c, stringArray);
    }

    public static String getOption(String string, String[] stringArray) throws Exception {
        if (stringArray == null) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0 || stringArray[i].charAt(0) != '-') continue;
            try {
                Double d = Double.valueOf(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (stringArray[i].equals("-" + string)) {
                    if (i + 1 == stringArray.length) {
                        throw new Exception(LocalString.get("No value given for -") + string + LocalString.get(" option."));
                    }
                    stringArray[i] = "";
                    String string2 = new String(stringArray[i + 1]);
                    stringArray[i + 1] = "";
                    return string2;
                }
                if (stringArray[i].charAt(1) != '-') continue;
                return "";
            }
        }
        return "";
    }

    public static String quote(String string) {
        boolean bl = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1) {
            string = Utils.backQuoteChars(string);
            bl = true;
        }
        if (bl || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] cArray = new char[]{'\\', '\'', '\t', '\"', '%'};
        String[] stringArray = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            if (string.indexOf(cArray[i]) == -1) continue;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = string.indexOf(cArray[i])) != -1) {
                if (n > 0) {
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(stringArray[i]);
                if (n + 1 < string.length()) {
                    string = string.substring(n + 1);
                    continue;
                }
                string = "";
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return Utils.convertNewLines(string);
    }

    public static String convertNewLines(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(10)) != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append('\\');
            stringBuffer.append('n');
            if (n + 1 < string.length()) {
                string = string.substring(n + 1);
                continue;
            }
            string = "";
        }
        stringBuffer.append(string);
        string = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        while ((n = string.indexOf(13)) != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append('\\');
            stringBuffer.append('r');
            if (n + 1 < string.length()) {
                string = string.substring(n + 1);
                continue;
            }
            string = "";
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String[] partitionOptions(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--")) continue;
            stringArray[i++] = "";
            String[] stringArray2 = new String[stringArray.length - i];
            for (int j = i; j < stringArray.length; ++j) {
                stringArray2[j - i] = stringArray[j];
                stringArray[j] = "";
            }
            return stringArray2;
        }
        return new String[0];
    }

    public static String unbackQuoteChars(String string) {
        String[] stringArray = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        char[] cArray = new char[]{'\\', '\'', '\t', '\"', '%'};
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (string.indexOf(stringArray[i]) == -1) continue;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = string.indexOf(stringArray[i])) != -1) {
                if (n > 0) {
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(cArray[i]);
                if (n + stringArray[i].length() < string.length()) {
                    string = string.substring(n + stringArray[i].length());
                    continue;
                }
                string = "";
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return Utils.convertNewLines(string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String[] splitOptions(String var0) throws Exception {
        var1_1 = new FastVector();
        var2_2 = new String(var0);
        while (true) lbl-1000:
        // 4 sources

        {
            for (var3_3 = 0; var3_3 < var2_2.length() && Character.isWhitespace(var2_2.charAt(var3_3)); ++var3_3) {
            }
            if ((var2_2 = var2_2.substring(var3_3)).length() == 0) break;
            if (var2_2.charAt(0) == '\"') {
                for (var3_3 = 1; var3_3 < var2_2.length() && var2_2.charAt(var3_3) != var2_2.charAt(0); ++var3_3) {
                    if (var2_2.charAt(var3_3) != '\\') continue;
                    if (++var3_3 >= var2_2.length()) {
                        throw new Exception(LocalString.get("String should not finish with \\"));
                    }
                    if (var2_2.charAt(var3_3) == '\\' || var2_2.charAt(var3_3) == '\"') continue;
                    throw new Exception(LocalString.get("Unknow character \\") + var2_2.charAt(var3_3));
                }
                if (var3_3 >= var2_2.length()) {
                    throw new Exception(LocalString.get("Quote parse error."));
                }
                var4_4 /* !! */  = var2_2.substring(1, var3_3);
                var4_4 /* !! */  = Utils.unbackQuoteChars((String)var4_4 /* !! */ );
                var1_1.addElement(var4_4 /* !! */ );
                var2_2 = var2_2.substring(var3_3 + 1);
                ** continue;
            }
            for (var3_3 = 0; var3_3 < var2_2.length() && !Character.isWhitespace(var2_2.charAt(var3_3)); ++var3_3) {
            }
            var4_4 /* !! */  = var2_2.substring(0, var3_3);
            var1_1.addElement(var4_4 /* !! */ );
            var2_2 = var2_2.substring(var3_3);
        }
        var4_4 /* !! */  = new String[var1_1.size()];
        for (var3_3 = 0; var3_3 < var1_1.size(); ++var3_3) {
            var4_4 /* !! */ [var3_3] = (String)var1_1.elementAt(var3_3);
        }
        return var4_4 /* !! */ ;
    }

    public static String joinOptions(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            string = stringArray[i].indexOf(32) != -1 ? string + '\"' + stringArray[i] + '\"' : string + stringArray[i];
            string = string + " ";
        }
        return string.trim();
    }

    public static Object forName(Class clazz, String string, String[] stringArray) throws Exception {
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(string);
        }
        catch (Exception exception) {
            throw new Exception(LocalString.get("Can't find class called: ") + string);
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new Exception(clazz.getName() + LocalString.get(" is not assignable from ") + string);
        }
        Object obj = clazz2.newInstance();
        if (obj instanceof OptionHandler && stringArray != null) {
            ((OptionHandler)obj).setOptions(stringArray);
            Utils.checkForRemainingOptions(stringArray);
        }
        return obj;
    }

    public static double info(int[] nArray) {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d -= Utils.xlogx(nArray[i]);
            n += nArray[i];
        }
        return d + Utils.xlogx(n);
    }

    public static boolean smOrEq(double d, double d2) {
        return d - d2 < SMALL;
    }

    public static boolean grOrEq(double d, double d2) {
        return d2 - d < SMALL;
    }

    public static boolean sm(double d, double d2) {
        return d2 - d > SMALL;
    }

    public static boolean gr(double d, double d2) {
        return d - d2 > SMALL;
    }

    public static double kthSmallestValue(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        return nArray[nArray2[Utils.select(nArray, nArray2, 0, nArray.length - 1, n)]];
    }

    public static double kthSmallestValue(double[] dArray, int n) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return dArray[nArray[Utils.select(dArray, nArray, 0, dArray.length - 1, n)]];
    }

    public static double log2(double d) {
        return Math.log(d) / log2;
    }

    public static int maxIndex(double[] dArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0 && !(dArray[i] > d)) continue;
            n = i;
            d = dArray[i];
        }
        return n;
    }

    public static int maxIndex(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0 && nArray[i] <= n) continue;
            n2 = i;
            n = nArray[i];
        }
        return n2;
    }

    public static double mean(double[] dArray) {
        double d = 0.0;
        if (dArray.length == 0) {
            return 0.0;
        }
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static int minIndex(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0 && nArray[i] >= n) continue;
            n2 = i;
            n = nArray[i];
        }
        return n2;
    }

    public static int minIndex(double[] dArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0 && !(dArray[i] < d)) continue;
            n = i;
            d = dArray[i];
        }
        return n;
    }

    public static void normalize(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        Utils.normalize(dArray, d);
    }

    public static void normalize(double[] dArray, double d) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(LocalString.get("Can't normalize array. Sum is NaN."));
        }
        if (d == 0.0) {
            throw new IllegalArgumentException(LocalString.get("Can't normalize array. Sum is zero."));
        }
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
    }

    public static double[] logs2probs(double[] dArray) {
        double d = dArray[Utils.maxIndex(dArray)];
        double d2 = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.exp(dArray[i] - d);
            d2 += dArray2[i];
        }
        Utils.normalize(dArray2, d2);
        return dArray2;
    }

    public static int round(double d) {
        int n = d > 0.0 ? (int)(d + 0.5) : -((int)(Math.abs(d) + 0.5));
        return n;
    }

    public static int probRound(double d, Random random) {
        if (d >= 0.0) {
            double d2 = Math.floor(d);
            double d3 = d - d2;
            if (random.nextDouble() < d3) {
                return (int)d2 + 1;
            }
            return (int)d2;
        }
        double d4 = Math.floor(Math.abs(d));
        double d5 = Math.abs(d) - d4;
        if (random.nextDouble() < d5) {
            return -((int)d4 + 1);
        }
        return -((int)d4);
    }

    public static double roundDouble(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static int[] sort(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = n;
        }
        Utils.quickSort(nArray, nArray2, 0, nArray.length - 1);
        n = 0;
        while (n < nArray2.length) {
            int n2;
            int n3 = 1;
            for (n2 = n + 1; n2 < nArray2.length && nArray[nArray2[n]] == nArray[nArray2[n2]]; ++n2) {
                ++n3;
            }
            if (n3 > 1) {
                int[] nArray4 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray4[n2] = n + n2;
                }
                Utils.quickSort(nArray2, nArray4, 0, n3 - 1);
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray3[n + n2] = nArray2[nArray4[n2]];
                }
                n += n3;
                continue;
            }
            nArray3[n] = nArray2[n];
            ++n;
        }
        return nArray3;
    }

    public static int[] sort(double[] dArray) {
        int[] nArray = new int[dArray.length];
        dArray = (double[])dArray.clone();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
            if (!Double.isNaN(dArray[i])) continue;
            dArray[i] = Double.MAX_VALUE;
        }
        Utils.quickSort(dArray, nArray, 0, dArray.length - 1);
        return nArray;
    }

    public static int[] stableSort(double[] dArray) {
        int n;
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray.length];
        dArray = (double[])dArray.clone();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
            if (!Double.isNaN(dArray[n])) continue;
            dArray[n] = Double.MAX_VALUE;
        }
        Utils.quickSort(dArray, nArray, 0, dArray.length - 1);
        n = 0;
        while (n < nArray.length) {
            int n2;
            int n3 = 1;
            for (n2 = n + 1; n2 < nArray.length && Utils.eq(dArray[nArray[n]], dArray[nArray[n2]]); ++n2) {
                ++n3;
            }
            if (n3 > 1) {
                int[] nArray3 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray3[n2] = n + n2;
                }
                Utils.quickSort(nArray, nArray3, 0, n3 - 1);
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray2[n + n2] = nArray[nArray3[n2]];
                }
                n += n3;
                continue;
            }
            nArray2[n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    public static double variance(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        if (dArray.length <= 1) {
            return 0.0;
        }
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray[i] * dArray[i];
        }
        double d3 = (d2 - d * d / (double)dArray.length) / (double)(dArray.length - 1);
        if (d3 < 0.0) {
            return 0.0;
        }
        return d3;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static double xlogx(int n) {
        if (n == 0) {
            return 0.0;
        }
        return (double)n * Utils.log2(n);
    }

    private static int partition(double[] dArray, int[] nArray, int n, int n2) {
        double d = dArray[nArray[(n + n2) / 2]];
        while (n < n2) {
            while (dArray[nArray[n]] < d && n < n2) {
                ++n;
            }
            while (dArray[nArray[n2]] > d && n < n2) {
                --n2;
            }
            if (n >= n2) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            ++n;
            --n2;
        }
        if (n == n2 && dArray[nArray[n2]] > d) {
            --n2;
        }
        return n2;
    }

    private static int partition(int[] nArray, int[] nArray2, int n, int n2) {
        double d = nArray[nArray2[(n + n2) / 2]];
        while (n < n2) {
            while ((double)nArray[nArray2[n]] < d && n < n2) {
                ++n;
            }
            while ((double)nArray[nArray2[n2]] > d && n < n2) {
                --n2;
            }
            if (n >= n2) continue;
            int n3 = nArray2[n];
            nArray2[n] = nArray2[n2];
            nArray2[n2] = n3;
            ++n;
            --n2;
        }
        if (n == n2 && (double)nArray[nArray2[n2]] > d) {
            --n2;
        }
        return n2;
    }

    private static void quickSort(double[] dArray, int[] nArray, int n, int n2) {
        if (n < n2) {
            int n3 = Utils.partition(dArray, nArray, n, n2);
            Utils.quickSort(dArray, nArray, n, n3);
            Utils.quickSort(dArray, nArray, n3 + 1, n2);
        }
    }

    private static void quickSort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n < n2) {
            int n3 = Utils.partition(nArray, nArray2, n, n2);
            Utils.quickSort(nArray, nArray2, n, n3);
            Utils.quickSort(nArray, nArray2, n3 + 1, n2);
        }
    }

    private static int select(double[] dArray, int[] nArray, int n, int n2, int n3) {
        if (n == n2) {
            return n;
        }
        int n4 = Utils.partition(dArray, nArray, n, n2);
        if (n4 - n + 1 >= n3) {
            return Utils.select(dArray, nArray, n, n4, n3);
        }
        return Utils.select(dArray, nArray, n4 + 1, n2, n3 - (n4 - n + 1));
    }

    private static int select(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n == n2) {
            return n;
        }
        int n4 = Utils.partition(nArray, nArray2, n, n2);
        if (n4 - n + 1 >= n3) {
            return Utils.select(nArray, nArray2, n, n4, n3);
        }
        return Utils.select(nArray, nArray2, n4 + 1, n2, n3 - (n4 - n + 1));
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{4.5, 6.7, Double.NaN, 3.4, 4.8, 1.2, 3.4};
        double[] dArray2 = new double[]{4.5, 6.7, 6.7, 3.4, 4.8, 1.2, 3.4, 6.7, 6.7, 3.4};
        int[] nArray = new int[]{12, 6, 2, 18, 16, 6, 7, 5, 18, 18, 17};
        try {
            int n;
            int n2;
            String[] stringArray2;
            System.out.println(LocalString.get("First option split up:"));
            if (stringArray.length > 0) {
                stringArray2 = Utils.splitOptions(stringArray[0]);
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    System.out.println(stringArray2[n2]);
                }
            }
            System.out.println(LocalString.get("Partitioned options: "));
            stringArray2 = Utils.partitionOptions(stringArray);
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                System.out.println(stringArray2[n2]);
            }
            System.out.println(LocalString.get("Get flag -f: ") + Utils.getFlag('f', stringArray));
            System.out.println(LocalString.get("Get option -o: ") + Utils.getOption('o', stringArray));
            System.out.println(LocalString.get("Checking for remaining options... "));
            Utils.checkForRemainingOptions(stringArray);
            System.out.println(LocalString.get("Original array with NaN (doubles): "));
            for (n2 = 0; n2 < dArray.length; ++n2) {
                System.out.print(dArray[n2] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Original array (doubles): "));
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                System.out.print(dArray2[n2] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Original array (ints): "));
            for (n2 = 0; n2 < nArray.length; ++n2) {
                System.out.print(nArray[n2] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Correlation: ") + Utils.correlation(dArray2, dArray2, dArray2.length));
            System.out.println(LocalString.get("Mean: ") + Utils.mean(dArray2));
            System.out.println(LocalString.get("Variance: ") + Utils.variance(dArray2));
            System.out.println(LocalString.get("Sum (doubles): ") + Utils.sum(dArray2));
            System.out.println(LocalString.get("Sum (ints): ") + Utils.sum(nArray));
            System.out.println(LocalString.get("Max index (doubles): ") + Utils.maxIndex(dArray2));
            System.out.println(LocalString.get("Max index (ints): ") + Utils.maxIndex(nArray));
            System.out.println(LocalString.get("Min index (doubles): ") + Utils.minIndex(dArray2));
            System.out.println(LocalString.get("Min index (ints): ") + Utils.minIndex(nArray));
            System.out.println(LocalString.get("Median (doubles): ") + Utils.kthSmallestValue(dArray2, dArray2.length / 2));
            System.out.println(LocalString.get("Median (ints): ") + Utils.kthSmallestValue(nArray, nArray.length / 2));
            System.out.println(LocalString.get("Sorted array with NaN (doubles): "));
            int[] nArray2 = Utils.sort(dArray);
            for (n = 0; n < dArray.length; ++n) {
                System.out.print(dArray[nArray2[n]] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Sorted array (doubles): "));
            nArray2 = Utils.sort(dArray2);
            for (n = 0; n < dArray2.length; ++n) {
                System.out.print(dArray2[nArray2[n]] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Sorted array (ints): "));
            nArray2 = Utils.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                System.out.print(nArray[nArray2[n]] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Indices from stable sort (doubles): "));
            nArray2 = Utils.stableSort(dArray2);
            for (n = 0; n < dArray2.length; ++n) {
                System.out.print(nArray2[n] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Indices from sort (ints): "));
            nArray2 = Utils.sort(nArray);
            for (n = 0; n < nArray.length; ++n) {
                System.out.print(nArray2[n] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Normalized array (doubles): "));
            Utils.normalize(dArray2);
            for (n = 0; n < dArray2.length; ++n) {
                System.out.print(dArray2[n] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("Normalized again (doubles): "));
            Utils.normalize(dArray2, Utils.sum(dArray2));
            for (n = 0; n < dArray2.length; ++n) {
                System.out.print(dArray2[n] + " ");
            }
            System.out.println();
            System.out.println(LocalString.get("-4.58: ") + Utils.doubleToString(-4.57826535, 2));
            System.out.println(LocalString.get("-6.78: ") + Utils.doubleToString(-6.78214234, 6, 2));
            System.out.println(LocalString.get("5.70001 == 5.7 ? ") + Utils.eq(5.70001, 5.7));
            System.out.println(LocalString.get("5.70001 > 5.7 ? ") + Utils.gr(5.70001, 5.7));
            System.out.println(LocalString.get("5.70001 >= 5.7 ? ") + Utils.grOrEq(5.70001, 5.7));
            System.out.println(LocalString.get("5.7 < 5.70001 ? ") + Utils.sm(5.7, 5.70001));
            System.out.println(LocalString.get("5.7 <= 5.70001 ? ") + Utils.smOrEq(5.7, 5.70001));
            System.out.println(LocalString.get("Info (ints): ") + Utils.info(nArray));
            System.out.println(LocalString.get("log2(4.6): ") + Utils.log2(4.6));
            System.out.println(LocalString.get("5 * log(5): ") + Utils.xlogx(5));
            System.out.println(LocalString.get("5.5 rounded: ") + Utils.round(5.5));
            System.out.println(LocalString.get("5.55555 rounded to 2 decimal places: ") + Utils.roundDouble(5.55555, 2));
            System.out.println(LocalString.get("Array-Dimensions of 'new int[][]': ") + Utils.getArrayDimensions(new int[0][]));
            System.out.println(LocalString.get("Array-Dimensions of 'new int[][]{{1,2,3},{4,5,6}}': ") + Utils.getArrayDimensions(new int[][]{{1, 2, 3}, {4, 5, 6}}));
            String[][][] stringArray3 = new String[3][4][];
            System.out.println(LocalString.get("Array-Dimensions of 'new String[3][4][]': ") + Utils.getArrayDimensions(stringArray3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

