/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class CSVResultListener
implements ResultListener,
OptionHandler {
    protected ResultProducer m_RP;
    protected File m_OutputFile = null;
    protected String m_OutputFileName = "";
    protected transient PrintWriter m_Out = new PrintWriter(System.out, true);

    public CSVResultListener() {
        File file;
        try {
            file = File.createTempFile("weka_experiment", ".csv");
            file.deleteOnExit();
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("Cannot create temp file, writing to standard out."));
            file = new File("-");
        }
        this.setOutputFile(file);
        this.setOutputFileName("");
    }

    public String globalInfo() {
        return LocalString.get("Takes results from a result producer and assembles them into ") + LocalString.get("comma separated value form.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option(LocalString.get("\tThe filename where output will be stored. Use - for stdout.\n") + LocalString.get("\t(default temp file)"), "O", 1, LocalString.get("-O <file name>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('O', stringArray);
        if (string.length() != 0) {
            this.setOutputFile(new File(string));
        } else {
            File file;
            try {
                file = File.createTempFile("weka_experiment", null);
                file.deleteOnExit();
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("Cannot create temp file, writing to standard out."));
                file = new File("-");
            }
            this.setOutputFile(file);
            this.setOutputFileName("");
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "-O";
        stringArray[n++] = this.getOutputFile().getName();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String outputFileTipText() {
        return LocalString.get("File to save to. Use '-' to write to standard out.");
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File file) {
        this.m_OutputFile = file;
        this.setOutputFileName(file.getName());
    }

    public String outputFileName() {
        return this.m_OutputFileName;
    }

    public void setOutputFileName(String string) {
        this.m_OutputFileName = string;
    }

    public void preProcess(ResultProducer resultProducer) throws Exception {
        this.m_RP = resultProducer;
        this.m_Out = this.m_OutputFile == null || this.m_OutputFile.getName().equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.m_OutputFile)), true);
        this.printResultNames(this.m_RP);
    }

    public void postProcess(ResultProducer resultProducer) throws Exception {
        if (this.m_OutputFile != null && !this.m_OutputFile.getName().equals("-")) {
            this.m_Out.close();
        }
    }

    public String[] determineColumnConstraints(ResultProducer resultProducer) throws Exception {
        return null;
    }

    public void acceptResult(ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        int n;
        if (this.m_RP != resultProducer) {
            throw new Error(LocalString.get("Unrecognized ResultProducer sending results!!"));
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (n != 0) {
                this.m_Out.print(',');
            }
            if (objectArray[n] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(Utils.quote(objectArray[n].toString()));
        }
        for (n = 0; n < objectArray2.length; ++n) {
            this.m_Out.print(',');
            if (objectArray2[n] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(Utils.quote(objectArray2[n].toString()));
        }
        this.m_Out.println("");
    }

    public boolean isResultRequired(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        return true;
    }

    private void printResultNames(ResultProducer resultProducer) throws Exception {
        String[] stringArray = resultProducer.getKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                this.m_Out.print(',');
            }
            if (stringArray[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print("Key_" + stringArray[i].toString());
        }
        String[] stringArray2 = resultProducer.getResultNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.m_Out.print(',');
            if (stringArray2[i] == null) {
                this.m_Out.print("?");
                continue;
            }
            this.m_Out.print(stringArray2[i].toString());
        }
        this.m_Out.println("");
    }
}

