/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import weka.LocalString;
import weka.core.AdditionalMeasureProducer;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.core.xml.XMLSerialization;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.xml.XMLExperiment;

public class Experiment
implements Serializable,
OptionHandler {
    public static String FILE_EXTENSION = ".exp";
    protected ResultListener m_ResultListener = new InstancesResultListener();
    protected ResultProducer m_ResultProducer = new RandomSplitResultProducer();
    protected int m_RunLower = 1;
    protected int m_RunUpper = 10;
    protected DefaultListModel m_Datasets = new DefaultListModel();
    protected boolean m_UsePropertyIterator = false;
    protected PropertyNode[] m_PropertyPath;
    protected Object m_PropertyArray;
    protected String m_Notes = "";
    protected String[] m_AdditionalMeasures = null;
    protected boolean m_ClassFirst = false;
    protected boolean m_AdvanceDataSetFirst = true;
    boolean m_m_AdvanceRunFirst;
    protected transient int m_RunNumber;
    protected transient int m_DatasetNumber;
    protected transient int m_PropertyNumber;
    protected transient boolean m_Finished = true;
    protected transient Instances m_CurrentInstances;
    protected transient int m_CurrentProperty;
    static /* synthetic */ Class class$weka$experiment$ResultListener;
    static /* synthetic */ Class class$weka$experiment$ResultProducer;

    public void classFirst(boolean bl) {
        this.m_ClassFirst = bl;
    }

    public boolean getAdvanceDataSetFirst() {
        return this.m_AdvanceDataSetFirst;
    }

    public void setAdvanceDataSetFirst(boolean bl) {
        this.m_AdvanceDataSetFirst = bl;
    }

    public boolean getUsePropertyIterator() {
        return this.m_UsePropertyIterator;
    }

    public void setUsePropertyIterator(boolean bl) {
        this.m_UsePropertyIterator = bl;
    }

    public PropertyNode[] getPropertyPath() {
        return this.m_PropertyPath;
    }

    public void setPropertyPath(PropertyNode[] propertyNodeArray) {
        this.m_PropertyPath = propertyNodeArray;
    }

    public void setPropertyArray(Object object) {
        this.m_PropertyArray = object;
    }

    public Object getPropertyArray() {
        return this.m_PropertyArray;
    }

    public int getPropertyArrayLength() {
        return Array.getLength(this.m_PropertyArray);
    }

    public Object getPropertyArrayValue(int n) {
        return Array.get(this.m_PropertyArray, n);
    }

    public int getCurrentRunNumber() {
        return this.m_RunNumber;
    }

    public int getCurrentDatasetNumber() {
        return this.m_DatasetNumber;
    }

    public int getCurrentPropertyNumber() {
        return this.m_PropertyNumber;
    }

    public void initialize() throws Exception {
        this.m_RunNumber = this.getRunLower();
        this.m_DatasetNumber = 0;
        this.m_PropertyNumber = 0;
        this.m_CurrentProperty = -1;
        this.m_CurrentInstances = null;
        this.m_Finished = false;
        if (this.m_UsePropertyIterator && this.m_PropertyArray == null) {
            throw new Exception(LocalString.get("Null array for property iterator"));
        }
        if (this.getRunLower() > this.getRunUpper()) {
            throw new Exception(LocalString.get("Lower run number is greater than upper run number"));
        }
        if (this.getDatasets().size() == 0) {
            throw new Exception(LocalString.get("No datasets have been specified"));
        }
        if (this.m_ResultProducer == null) {
            throw new Exception(LocalString.get("No ResultProducer set"));
        }
        if (this.m_ResultListener == null) {
            throw new Exception(LocalString.get("No ResultListener set"));
        }
        this.determineAdditionalResultMeasures();
        this.m_ResultProducer.setResultListener(this.m_ResultListener);
        this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        this.m_ResultProducer.preProcess();
        String[] stringArray = this.m_ResultListener.determineColumnConstraints(this.m_ResultProducer);
        if (stringArray != null) {
            this.m_ResultProducer.setAdditionalMeasures(stringArray);
        }
    }

    private void determineAdditionalResultMeasures() throws Exception {
        Object object;
        this.m_AdditionalMeasures = null;
        FastVector fastVector = new FastVector();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).startsWith("measure")) {
                    if (fastVector.indexOf(object) != -1) continue;
                    fastVector.addElement(object);
                    continue;
                }
                throw new Exception(LocalString.get("Additional measures in ") + this.m_ResultProducer.getClass().getName() + LocalString.get(" must obey the naming convention") + LocalString.get(" of starting with \"measure\""));
            }
        }
        if (this.m_UsePropertyIterator && this.m_PropertyArray != null) {
            for (int i = 0; i < Array.getLength(this.m_PropertyArray); ++i) {
                object = Array.get(this.m_PropertyArray, i);
                if (!(object instanceof AdditionalMeasureProducer)) continue;
                Enumeration enumeration = ((AdditionalMeasureProducer)object).enumerateMeasures();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.startsWith("measure")) {
                        if (fastVector.indexOf(string) != -1) continue;
                        fastVector.addElement(string);
                        continue;
                    }
                    throw new Exception(LocalString.get("Additional measures in ") + object.getClass().getName() + LocalString.get(" must obey the naming convention") + LocalString.get(" of starting with \"measure\""));
                }
            }
        }
        if (fastVector.size() > 0) {
            this.m_AdditionalMeasures = new String[fastVector.size()];
            for (int i = 0; i < fastVector.size(); ++i) {
                this.m_AdditionalMeasures[i] = (String)fastVector.elementAt(i);
            }
        }
    }

    protected void setProperty(int n, Object object) throws Exception {
        Object[] objectArray;
        Method method;
        PropertyDescriptor propertyDescriptor = this.m_PropertyPath[n].property;
        Object object2 = null;
        if (n < this.m_PropertyPath.length - 1) {
            method = propertyDescriptor.getReadMethod();
            objectArray = new Object[]{};
            object2 = method.invoke(object, objectArray);
            this.setProperty(n + 1, object2);
        } else {
            object2 = Array.get(this.m_PropertyArray, this.m_PropertyNumber);
        }
        method = propertyDescriptor.getWriteMethod();
        objectArray = new Object[]{object2};
        method.invoke(object, objectArray);
    }

    public boolean hasMoreIterations() {
        return !this.m_Finished;
    }

    public void nextIteration() throws Exception {
        if (this.m_UsePropertyIterator && this.m_CurrentProperty != this.m_PropertyNumber) {
            this.setProperty(0, this.m_ResultProducer);
            this.m_CurrentProperty = this.m_PropertyNumber;
        }
        if (this.m_CurrentInstances == null) {
            File file = (File)this.getDatasets().elementAt(this.m_DatasetNumber);
            FileReader fileReader = new FileReader(file);
            Instances instances = new Instances(new BufferedReader(fileReader));
            if (this.m_ClassFirst) {
                instances.setClassIndex(0);
            } else {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            this.m_CurrentInstances = instances;
            this.m_ResultProducer.setInstances(this.m_CurrentInstances);
        }
        this.m_ResultProducer.doRun(this.m_RunNumber);
        this.advanceCounters();
    }

    public void advanceCounters() {
        if (this.m_AdvanceDataSetFirst) {
            ++this.m_RunNumber;
            if (this.m_RunNumber > this.getRunUpper()) {
                this.m_RunNumber = this.getRunLower();
                ++this.m_DatasetNumber;
                this.m_CurrentInstances = null;
                if (this.m_DatasetNumber >= this.getDatasets().size()) {
                    this.m_DatasetNumber = 0;
                    if (this.m_UsePropertyIterator) {
                        ++this.m_PropertyNumber;
                        if (this.m_PropertyNumber >= Array.getLength(this.m_PropertyArray)) {
                            this.m_Finished = true;
                        }
                    } else {
                        this.m_Finished = true;
                    }
                }
            }
        } else {
            ++this.m_RunNumber;
            if (this.m_RunNumber > this.getRunUpper()) {
                this.m_RunNumber = this.getRunLower();
                if (this.m_UsePropertyIterator) {
                    ++this.m_PropertyNumber;
                    if (this.m_PropertyNumber >= Array.getLength(this.m_PropertyArray)) {
                        this.m_PropertyNumber = 0;
                        ++this.m_DatasetNumber;
                        this.m_CurrentInstances = null;
                        if (this.m_DatasetNumber >= this.getDatasets().size()) {
                            this.m_Finished = true;
                        }
                    }
                } else {
                    ++this.m_DatasetNumber;
                    this.m_CurrentInstances = null;
                    if (this.m_DatasetNumber >= this.getDatasets().size()) {
                        this.m_Finished = true;
                    }
                }
            }
        }
    }

    public void runExperiment() {
        while (this.hasMoreIterations()) {
            try {
                this.nextIteration();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
                this.advanceCounters();
            }
        }
    }

    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    public DefaultListModel getDatasets() {
        return this.m_Datasets;
    }

    public void setDatasets(DefaultListModel defaultListModel) {
        this.m_Datasets = defaultListModel;
    }

    public ResultListener getResultListener() {
        return this.m_ResultListener;
    }

    public void setResultListener(ResultListener resultListener) {
        this.m_ResultListener = resultListener;
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer resultProducer) {
        this.m_ResultProducer = resultProducer;
    }

    public int getRunUpper() {
        return this.m_RunUpper;
    }

    public void setRunUpper(int n) {
        this.m_RunUpper = n;
    }

    public int getRunLower() {
        return this.m_RunLower;
    }

    public void setRunLower(int n) {
        this.m_RunLower = n;
    }

    public String getNotes() {
        return this.m_Notes;
    }

    public void setNotes(String string) {
        this.m_Notes = string;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option(LocalString.get("\tThe lower run number to start the experiment from.\n") + LocalString.get("\t(default 1)"), "L", 1, LocalString.get("-L <num>")));
        vector.addElement(new Option(LocalString.get("\tThe upper run number to end the experiment at (inclusive).\n") + LocalString.get("\t(default 10)"), "U", 1, LocalString.get("-U <num>")));
        vector.addElement(new Option(LocalString.get("\tThe dataset to run the experiment on.\n") + LocalString.get("\t(required, may be specified multiple times)"), "T", 1, LocalString.get("-T <arff file>")));
        vector.addElement(new Option(LocalString.get("\tThe full class name of a ResultProducer (required).\n") + LocalString.get("\teg: weka.experiment.RandomSplitResultProducer"), "P", 1, LocalString.get("-P <class name>")));
        vector.addElement(new Option(LocalString.get("\tThe full class name of a ResultListener (required).\n") + LocalString.get("\teg: weka.experiment.CSVResultListener"), "D", 1, LocalString.get("-D <class name>")));
        vector.addElement(new Option(LocalString.get("\tA string containing any notes about the experiment.\n") + LocalString.get("\t(default none)"), "N", 1, LocalString.get("-N <string>")));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to result producer ") + this.m_ResultProducer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_ResultProducer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2 = Utils.getOption('L', stringArray);
        if (string2.length() != 0) {
            this.setRunLower(Integer.parseInt(string2));
        } else {
            this.setRunLower(1);
        }
        String string3 = Utils.getOption('U', stringArray);
        if (string3.length() != 0) {
            this.setRunUpper(Integer.parseInt(string3));
        } else {
            this.setRunUpper(10);
        }
        if (this.getRunLower() > this.getRunUpper()) {
            throw new Exception(LocalString.get("Lower (") + this.getRunLower() + LocalString.get(") is greater than upper (") + this.getRunUpper() + ")");
        }
        this.setNotes(Utils.getOption('N', stringArray));
        this.getDatasets().removeAllElements();
        do {
            if ((string = Utils.getOption('T', stringArray)).length() == 0) continue;
            object = new File(string);
            this.getDatasets().addElement(object);
        } while (string.length() != 0);
        if (this.getDatasets().size() == 0) {
            throw new Exception(LocalString.get("Required: -T <arff file name>"));
        }
        object = Utils.getOption('D', stringArray);
        if (((String)object).length() == 0) {
            throw new Exception(LocalString.get("Required: -D <ResultListener class name>"));
        }
        object = ((String)object).trim();
        int n = ((String)object).indexOf(32);
        Object object2 = object;
        String string4 = "";
        String[] stringArray2 = null;
        if (n != -1) {
            object2 = ((String)object).substring(0, n);
            string4 = ((String)object).substring(n).trim();
            stringArray2 = Utils.splitOptions(string4);
        }
        this.setResultListener((ResultListener)Utils.forName(class$weka$experiment$ResultListener == null ? (class$weka$experiment$ResultListener = Experiment.class$("weka.experiment.ResultListener")) : class$weka$experiment$ResultListener, (String)object2, stringArray2));
        String string5 = Utils.getOption('P', stringArray);
        if (string5.length() == 0) {
            throw new Exception(LocalString.get("Required: -P <ResultProducer class name>"));
        }
        this.setResultProducer((ResultProducer)Utils.forName(class$weka$experiment$ResultProducer == null ? (class$weka$experiment$ResultProducer = Experiment.class$("weka.experiment.ResultProducer")) : class$weka$experiment$ResultProducer, string5, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        this.m_UsePropertyIterator = false;
        this.m_PropertyPath = null;
        this.m_PropertyArray = null;
        String[] stringArray = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + this.getDatasets().size() * 2 + 11];
        int n = 0;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getRunLower();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRunUpper();
        if (this.getDatasets().size() != 0) {
            for (int i = 0; i < this.getDatasets().size(); ++i) {
                stringArray2[n++] = "-T";
                stringArray2[n++] = this.getDatasets().elementAt(i).toString();
            }
        }
        if (this.getResultListener() != null) {
            stringArray2[n++] = "-D";
            stringArray2[n++] = this.getResultListener().getClass().getName();
        }
        if (this.getResultProducer() != null) {
            stringArray2[n++] = "-P";
            stringArray2[n++] = this.getResultProducer().getClass().getName();
        }
        if (!this.getNotes().equals("")) {
            stringArray2[n++] = "-N";
            stringArray2[n++] = this.getNotes();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String toString() {
        int n;
        String string = LocalString.get("Runs from: ") + this.m_RunLower + " to: " + this.m_RunUpper + '\n';
        string = string + "Datasets:";
        for (n = 0; n < this.m_Datasets.size(); ++n) {
            string = string + " " + this.m_Datasets.elementAt(n);
        }
        string = string + '\n';
        string = string + LocalString.get("Custom property iterator: ") + (this.m_UsePropertyIterator ? "on" : "off") + "\n";
        if (this.m_UsePropertyIterator) {
            Object object;
            if (this.m_PropertyPath == null) {
                throw new Error(LocalString.get("*** null propertyPath ***"));
            }
            if (this.m_PropertyArray == null) {
                throw new Error(LocalString.get("*** null propertyArray ***"));
            }
            if (this.m_PropertyPath.length > 1) {
                string = string + LocalString.get("Custom property path:\n");
                for (n = 0; n < this.m_PropertyPath.length - 1; ++n) {
                    object = this.m_PropertyPath[n];
                    string = string + "" + (n + 1) + "  " + ((PropertyNode)object).parentClass.getName() + "::" + ((PropertyNode)object).toString() + ' ' + ((PropertyNode)object).value.toString() + '\n';
                }
            }
            string = string + LocalString.get("Custom property name:") + this.m_PropertyPath[this.m_PropertyPath.length - 1].toString() + '\n';
            string = string + LocalString.get("Custom property values:\n");
            for (n = 0; n < Array.getLength(this.m_PropertyArray); ++n) {
                object = Array.get(this.m_PropertyArray, n);
                string = string + " " + (n + 1) + " " + object.getClass().getName() + " " + object.toString() + '\n';
            }
        }
        string = string + LocalString.get("ResultProducer: ") + this.m_ResultProducer + '\n';
        string = string + LocalString.get("ResultListener: ") + this.m_ResultListener + '\n';
        if (!this.getNotes().equals("")) {
            string = string + LocalString.get("Notes: ") + this.getNotes();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            Experiment experiment = null;
            String string = Utils.getOption("xml", stringArray);
            if (!string.equals("")) {
                stringArray = new XMLOptions(string).toArray();
            }
            String string2 = Utils.getOption('l', stringArray);
            String string3 = Utils.getOption('s', stringArray);
            boolean bl = Utils.getFlag('r', stringArray);
            if (string2.length() == 0) {
                experiment = new Experiment();
                try {
                    experiment.setOptions(stringArray);
                    Utils.checkForRemainingOptions(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String string4 = "Usage:\n\n" + LocalString.get("-l <exp|xml file>\n") + LocalString.get("\tLoad experiment from file (default use cli options).\n") + LocalString.get("\tThe type is determined, based on the extension (") + FILE_EXTENSION + LocalString.get(" or .xml)\n") + LocalString.get("-s <exp|xml file>\n") + LocalString.get("\tSave experiment to file after setting other options.\n") + LocalString.get("\tThe type is determined, based on the extension (") + FILE_EXTENSION + LocalString.get(" or .xml)\n") + LocalString.get("\t(default don't save)\n") + "-r\n" + LocalString.get("\tRun experiment (default don't run)\n") + LocalString.get("-xml <filename | xml-string>\n") + LocalString.get("\tget options from XML-Data instead from parameters\n") + "\n";
                    Enumeration enumeration = experiment.listOptions();
                    while (enumeration.hasMoreElements()) {
                        Option option = (Option)enumeration.nextElement();
                        string4 = string4 + option.synopsis() + "\n";
                        string4 = string4 + option.description() + "\n";
                    }
                    throw new Exception(string4 + "\n" + exception.getMessage());
                }
            } else {
                if (KOML.isPresent() && string2.toLowerCase().endsWith(".koml")) {
                    experiment = (Experiment)KOML.read(string2);
                } else if (string2.toLowerCase().endsWith(".xml")) {
                    object2 = new XMLExperiment();
                    experiment = (Experiment)((XMLSerialization)object2).read(string2);
                } else {
                    object2 = new FileInputStream(string2);
                    object = new ObjectInputStream(new BufferedInputStream((InputStream)object2));
                    experiment = (Experiment)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                }
                do {
                    if (((String)(object2 = Utils.getOption('T', stringArray))).length() == 0) continue;
                    object = new File((String)object2);
                    experiment.getDatasets().addElement(object);
                } while (((String)object2).length() != 0);
            }
            System.err.println("Experiment:\n" + experiment.toString());
            if (string3.length() != 0) {
                if (KOML.isPresent() && string3.toLowerCase().endsWith(".koml")) {
                    KOML.write(string3, (Object)experiment);
                } else if (string3.toLowerCase().endsWith(".xml")) {
                    object2 = new XMLExperiment();
                    ((XMLSerialization)object2).write(string3, (Object)experiment);
                } else {
                    object2 = new FileOutputStream(string3);
                    object = new ObjectOutputStream(new BufferedOutputStream((OutputStream)object2));
                    ((ObjectOutputStream)object).writeObject(experiment);
                    ((ObjectOutputStream)object).close();
                }
            }
            if (bl) {
                System.err.println("Initializing...");
                experiment.initialize();
                System.err.println("Iterating...");
                experiment.runExperiment();
                System.err.println("Postprocessing...");
                experiment.postProcess();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

