/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.experiment.DatabaseUtils;

public class InstanceQuery
extends DatabaseUtils
implements OptionHandler {
    boolean m_CreateSparseData = false;
    String m_Query = LocalString.get("SELECT * from ?");

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option(LocalString.get("\tSQL query to execute."), "Q", 1, LocalString.get("-Q <query>")));
        vector.addElement(new Option(LocalString.get("\tReturn sparse rather than normal instances."), "S", 0, "-S"));
        vector.addElement(new Option(LocalString.get("\tThe username to use for connecting."), "U", 1, LocalString.get("-U <username>")));
        vector.addElement(new Option(LocalString.get("\tThe password to use for connecting."), "P", 1, LocalString.get("-P <password>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setSparseData(Utils.getFlag('S', stringArray));
        String string = Utils.getOption('Q', stringArray);
        if (string.length() != 0) {
            this.setQuery(string);
        }
        if ((string = Utils.getOption('U', stringArray)).length() != 0) {
            this.setUsername(string);
        }
        if ((string = Utils.getOption('P', stringArray)).length() != 0) {
            this.setPassword(string);
        }
    }

    public String queryTipText() {
        return LocalString.get("The SQL query to execute against the database.");
    }

    public void setQuery(String string) {
        this.m_Query = string;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public String sparseDataTipText() {
        return LocalString.get("Encode data as sparse instances.");
    }

    public void setSparseData(boolean bl) {
        this.m_CreateSparseData = bl;
    }

    public boolean getSparseData() {
        return this.m_CreateSparseData;
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-Q");
        vector.add(this.getQuery());
        if (this.getSparseData()) {
            vector.add("-S");
        }
        if (!this.getUsername().equals("")) {
            vector.add("-U");
            vector.add(this.getUsername());
        }
        if (!this.getPassword().equals("")) {
            vector.add("-P");
            vector.add(this.getPassword());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Instances retrieveInstances() throws Exception {
        return this.retrieveInstances(this.m_Query);
    }

    public Instances retrieveInstances(String string) throws Exception {
        String string2;
        Object object;
        System.err.println(LocalString.get("Executing query: ") + string);
        this.connectToDatabase();
        if (!this.execute(string)) {
            if (this.m_PreparedStatement.getUpdateCount() == -1) {
                throw new Exception(LocalString.get("Query didn't produce results"));
            }
            System.err.println(this.m_PreparedStatement.getUpdateCount() + LocalString.get(" rows affected."));
            return null;
        }
        ResultSet resultSet = this.getResultSet();
        System.err.println(LocalString.get("Getting metadata..."));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        System.err.println(LocalString.get("Completed getting metadata..."));
        int n = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n];
        Hashtable[] hashtableArray = new Hashtable[n];
        FastVector[] fastVectorArray = new FastVector[n];
        block28: for (int i = 1; i <= n; ++i) {
            switch (this.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                case 0: {
                    nArray[i - 1] = 1;
                    hashtableArray[i - 1] = new Hashtable();
                    fastVectorArray[i - 1] = new FastVector();
                    continue block28;
                }
                case 1: {
                    nArray[i - 1] = 1;
                    hashtableArray[i - 1] = new Hashtable();
                    hashtableArray[i - 1].put("false", new Double(0.0));
                    hashtableArray[i - 1].put("true", new Double(1.0));
                    fastVectorArray[i - 1] = new FastVector();
                    fastVectorArray[i - 1].addElement("false");
                    fastVectorArray[i - 1].addElement("true");
                    continue block28;
                }
                case 2: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 3: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 4: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 5: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 6: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 7: {
                    nArray[i - 1] = 0;
                    continue block28;
                }
                case 8: {
                    nArray[i - 1] = 3;
                    continue block28;
                }
                default: {
                    nArray[i - 1] = 2;
                }
            }
        }
        System.err.println(LocalString.get("Creating instances..."));
        FastVector fastVector = new FastVector();
        int n2 = 0;
        while (resultSet.next()) {
            if (n2 % 100 == 0) {
                System.err.print(LocalString.get("read ") + n2 + LocalString.get(" instances \r"));
                System.err.flush();
            }
            object = new double[n];
            block30: for (int i = 1; i <= n; ++i) {
                switch (this.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                    case 0: {
                        string2 = resultSet.getString(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        Double d = (Double)hashtableArray[i - 1].get(string2);
                        if (d == null) {
                            d = new Double(fastVectorArray[i - 1].size());
                            hashtableArray[i - 1].put(string2, d);
                            fastVectorArray[i - 1].addElement(string2);
                        }
                        object[i - 1] = d;
                        continue block30;
                    }
                    case 1: {
                        boolean bl = resultSet.getBoolean(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = bl ? 1.0 : 0.0;
                        continue block30;
                    }
                    case 2: {
                        double d = resultSet.getDouble(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = d;
                        continue block30;
                    }
                    case 3: {
                        byte by = resultSet.getByte(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)by;
                        continue block30;
                    }
                    case 4: {
                        short s = resultSet.getByte(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)s;
                        continue block30;
                    }
                    case 5: {
                        int n3 = resultSet.getInt(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)n3;
                        continue block30;
                    }
                    case 6: {
                        long l = resultSet.getLong(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)l;
                        continue block30;
                    }
                    case 7: {
                        float f = resultSet.getFloat(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)f;
                        continue block30;
                    }
                    case 8: {
                        Date date = resultSet.getDate(i);
                        if (resultSet.wasNull()) {
                            object[i - 1] = Instance.missingValue();
                            continue block30;
                        }
                        object[i - 1] = (double)date.getTime();
                        continue block30;
                    }
                    default: {
                        object[i - 1] = Instance.missingValue();
                    }
                }
            }
            Instance instance = this.m_CreateSparseData ? new SparseInstance(1.0, (double[])object) : new Instance(1.0, (double[])object);
            fastVector.addElement(instance);
            ++n2;
        }
        System.err.println(LocalString.get("Creating header..."));
        object = new FastVector();
        block31: for (int i = 0; i < n; ++i) {
            string2 = this.attributeCaseFix(resultSetMetaData.getColumnName(i + 1));
            switch (nArray[i]) {
                case 1: {
                    ((FastVector)object).addElement(new Attribute(string2, fastVectorArray[i]));
                    continue block31;
                }
                case 0: {
                    ((FastVector)object).addElement(new Attribute(string2));
                    continue block31;
                }
                case 2: {
                    ((FastVector)object).addElement(new Attribute(string2, (FastVector)null));
                    continue block31;
                }
                case 3: {
                    ((FastVector)object).addElement(new Attribute(string2, (String)null));
                    continue block31;
                }
                default: {
                    throw new Exception(LocalString.get("Unknown attribute type"));
                }
            }
        }
        Instances instances = new Instances("QueryResult", (FastVector)object, fastVector.size());
        for (int i = 0; i < fastVector.size(); ++i) {
            instances.add((Instance)fastVector.elementAt(i));
        }
        resultSet.close();
        return instances;
    }

    public static void main(String[] stringArray) {
        try {
            InstanceQuery instanceQuery = new InstanceQuery();
            String string = Utils.getOption('Q', stringArray);
            if (string.length() == 0) {
                instanceQuery.setQuery(LocalString.get("select * from Experiment_index"));
            } else {
                instanceQuery.setQuery(string);
            }
            instanceQuery.setOptions(stringArray);
            try {
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                System.err.println(LocalString.get("Options for weka.experiment.InstanceQuery:\n"));
                Enumeration enumeration = instanceQuery.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    System.err.println(option.synopsis() + "\n" + option.description());
                }
                System.exit(1);
            }
            Instances instances = instanceQuery.retrieveInstances();
            instanceQuery.disconnectFromDatabase();
            if (instances == null) {
                return;
            }
            System.out.println(new Instances(instances, 0));
            for (int i = 0; i < instances.numInstances(); ++i) {
                System.out.println(instances.instance(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

