/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class AddExpression
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private String m_infixExpression = "a1^2";
    private Stack m_operatorStack = new Stack();
    private static final String OPERATORS = "+-*/()^lbcesfhrtn";
    private static final String UNARY_FUNCTIONS = "lbcesfhrtn";
    private Vector m_postFixExpVector;
    private boolean m_signMod = false;
    private String m_previousTok = "";
    private String m_attributeName = "expression";
    private boolean m_Debug = false;

    public String globalInfo() {
        return LocalString.get("An instance filter that creates a new attribute by applying a ") + LocalString.get("mathematical expression to existing attributes. The expression ") + LocalString.get("can contain attribute references and numeric constants. Supported ") + LocalString.get("opperators are :  +, -, *, /, ^, log, abs, cos, exp, sqrt, ") + LocalString.get("floor, ceil, rint, tan, sin, (, ). Attributes are specified ") + LocalString.get("by prefixing with 'a', eg. a7 is attribute number 7 (starting from 1).") + LocalString.get(" Example expression : a1^2*a5/log(a7*4.0).");
    }

    private void handleOperand(String string) throws Exception {
        if (string.indexOf(97) != -1) {
            this.m_postFixExpVector.addElement(new AttributeOperand(string, this.m_signMod));
        } else {
            try {
                this.m_postFixExpVector.addElement(new NumericOperand(string, this.m_signMod));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(LocalString.get("Trouble parsing numeric constant"));
            }
        }
        this.m_signMod = false;
    }

    private void handleOperator(String string) throws Exception {
        boolean bl = true;
        char c = string.charAt(0);
        if (c == ')') {
            String string2 = " ";
            do {
                if ((string2 = (String)this.m_operatorStack.pop()).charAt(0) == '(') continue;
                this.m_postFixExpVector.addElement(new Operator(string2.charAt(0)));
            } while (string2.charAt(0) != '(');
        } else {
            int n = this.infixPriority(string.charAt(0));
            while (!this.m_operatorStack.empty() && this.stackPriority(((String)this.m_operatorStack.peek()).charAt(0)) >= n) {
                if (this.m_previousTok.length() == 1 && this.isOperator(this.m_previousTok.charAt(0)) && this.m_previousTok.charAt(0) != ')') {
                    this.m_signMod = string.charAt(0) == '-';
                    bl = false;
                    break;
                }
                String string3 = (String)this.m_operatorStack.pop();
                this.m_postFixExpVector.addElement(new Operator(string3.charAt(0)));
            }
            if (this.m_postFixExpVector.size() == 0 && string.charAt(0) == '-') {
                this.m_signMod = true;
                bl = false;
            }
            if (bl) {
                this.m_operatorStack.push(string);
            }
        }
    }

    private void convertInfixToPostfix(String string) throws Exception {
        String string2;
        string = Utils.removeSubstring(string, " ");
        string = Utils.replaceSubstring(string, "log", "l");
        string = Utils.replaceSubstring(string, "abs", "b");
        string = Utils.replaceSubstring(string, "cos", "c");
        string = Utils.replaceSubstring(string, "exp", "e");
        string = Utils.replaceSubstring(string, "sqrt", "s");
        string = Utils.replaceSubstring(string, "floor", "f");
        string = Utils.replaceSubstring(string, "ceil", "h");
        string = Utils.replaceSubstring(string, "rint", "r");
        string = Utils.replaceSubstring(string, "tan", "t");
        string = Utils.replaceSubstring(string, "sin", "n");
        StringTokenizer stringTokenizer = new StringTokenizer(string, OPERATORS, true);
        this.m_postFixExpVector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() > 1) {
                this.handleOperand(string2);
            } else if (this.isOperator(string2.charAt(0))) {
                this.handleOperator(string2);
            } else {
                this.handleOperand(string2);
            }
            this.m_previousTok = string2;
        }
        while (!this.m_operatorStack.empty()) {
            string2 = (String)this.m_operatorStack.pop();
            if (string2.charAt(0) == '(' || string2.charAt(0) == ')') {
                throw new Exception(LocalString.get("Mis-matched parenthesis!"));
            }
            this.m_postFixExpVector.addElement(new Operator(string2.charAt(0)));
        }
    }

    private void evaluateExpression(double[] dArray) throws Exception {
        Stack<Double> stack = new Stack<Double>();
        for (int i = 0; i < this.m_postFixExpVector.size(); ++i) {
            Object e = this.m_postFixExpVector.elementAt(i);
            if (e instanceof NumericOperand) {
                stack.push(new Double(((NumericOperand)e).m_numericConst));
                continue;
            }
            if (e instanceof AttributeOperand) {
                double d = dArray[((AttributeOperand)e).m_attributeIndex];
                if (d == Instance.missingValue()) {
                    dArray[dArray.length - 1] = Instance.missingValue();
                    break;
                }
                if (((AttributeOperand)e).m_negative) {
                    d = -d;
                }
                stack.push(new Double(d));
                continue;
            }
            if (e instanceof Operator) {
                double d;
                double d2;
                char c = ((Operator)e).m_operator;
                if (this.isUnaryFunction(c)) {
                    d2 = (Double)stack.pop();
                    d = ((Operator)e).applyFunction(d2);
                    stack.push(new Double(d));
                    continue;
                }
                d2 = (Double)stack.pop();
                d = (Double)stack.pop();
                double d3 = ((Operator)e).applyOperator(d, d2);
                stack.push(new Double(d3));
                continue;
            }
            throw new Exception(LocalString.get("Unknown object in postfix vector!"));
        }
        if (stack.size() != 1) {
            throw new Exception(LocalString.get("Problem applying function"));
        }
        Double d = (Double)stack.pop();
        dArray[dArray.length - 1] = d.isNaN() || d.isInfinite() ? Instance.missingValue() : d;
    }

    private boolean isOperator(char c) {
        return OPERATORS.indexOf(c) != -1;
    }

    private boolean isUnaryFunction(char c) {
        return UNARY_FUNCTIONS.indexOf(c) != -1;
    }

    private int infixPriority(char c) {
        switch (c) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 4;
            }
            case ')': {
                return 0;
            }
        }
        throw new IllegalArgumentException(LocalString.get("Unrecognized operator:") + c);
    }

    private int stackPriority(char c) {
        switch (c) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 0;
            }
            case ')': {
                return -1;
            }
        }
        throw new IllegalArgumentException(LocalString.get("Unrecognized operator:") + c);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option(LocalString.get("\tSpecify the expression to apply. Eg a1^2*a5/log(a7*4.0).") + LocalString.get("\n\tSupported opperators: ,+, -, *, /, ^, log, abs, cos, ") + LocalString.get("\n\texp, sqrt, floor, ceil, rint, tan, sin, (, )"), "E", 1, LocalString.get("-E <expression>")));
        vector.addElement(new Option(LocalString.get("\tSpecify the name for the new attribute. (default is the ") + LocalString.get("expression provided with -E)"), "N", 1, LocalString.get("-N <name>")));
        vector.addElement(new Option(LocalString.get("\tDebug. Names attribute with the postfix parse of the ") + "expression.", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() == 0) {
            throw new Exception(LocalString.get("Must specify an expression with the -E option"));
        }
        this.setExpression(string);
        String string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setName(string2);
        }
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-E";
        stringArray[n++] = this.getExpression();
        stringArray[n++] = "-N";
        stringArray[n++] = this.getName();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String nameTipText() {
        return LocalString.get("Set the name of the new attribute.");
    }

    public void setName(String string) {
        this.m_attributeName = string;
    }

    public String getName() {
        return this.m_attributeName;
    }

    public String debugTipText() {
        return LocalString.get("Set debug mode. If true then the new attribute will be named with ") + LocalString.get("the postfix parse of the supplied expression.");
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String expressionTipText() {
        return LocalString.get("Set the math expression to apply. Eg. a1^2*a5/log(a7*4.0)");
    }

    public void setExpression(String string) {
        this.m_infixExpression = string;
    }

    public String getExpression() {
        return this.m_infixExpression;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.convertInfixToPostfix(new String(this.m_infixExpression));
        super.setInputFormat(instances);
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = this.m_Debug ? new Attribute(this.m_postFixExpVector.toString()) : (this.m_attributeName.compareTo("expression") != 0 ? new Attribute(this.m_attributeName) : new Attribute(this.m_infixExpression));
        instances2.insertAttributeAt(attribute, instances.numAttributes());
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            dArray[i] = instance.isMissing(i) ? Instance.missingValue() : instance.value(i);
        }
        this.evaluateExpression(dArray);
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new AddExpression(), stringArray);
            } else {
                Filter.filterFile(new AddExpression(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private class Operator
    implements Serializable {
        protected char m_operator;

        public Operator(char c) {
            if (!AddExpression.this.isOperator(c)) {
                throw new IllegalArgumentException(LocalString.get("Unrecognized operator:") + c);
            }
            this.m_operator = c;
        }

        protected double applyOperator(double d, double d2) {
            switch (this.m_operator) {
                case '+': {
                    return d + d2;
                }
                case '-': {
                    return d - d2;
                }
                case '*': {
                    return d * d2;
                }
                case '/': {
                    return d / d2;
                }
                case '^': {
                    return Math.pow(d, d2);
                }
            }
            return Double.NaN;
        }

        protected double applyFunction(double d) {
            switch (this.m_operator) {
                case 'l': {
                    return Math.log(d);
                }
                case 'b': {
                    return Math.abs(d);
                }
                case 'c': {
                    return Math.cos(d);
                }
                case 'e': {
                    return Math.exp(d);
                }
                case 's': {
                    return Math.sqrt(d);
                }
                case 'f': {
                    return Math.floor(d);
                }
                case 'h': {
                    return Math.ceil(d);
                }
                case 'r': {
                    return Math.rint(d);
                }
                case 't': {
                    return Math.tan(d);
                }
                case 'n': {
                    return Math.sin(d);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            return "" + this.m_operator;
        }
    }

    private class NumericOperand
    implements Serializable {
        protected double m_numericConst;

        public NumericOperand(String string, boolean bl) throws Exception {
            this.m_numericConst = Double.valueOf(string);
            if (bl) {
                this.m_numericConst *= -1.0;
            }
        }

        public String toString() {
            return "" + this.m_numericConst;
        }
    }

    private class AttributeOperand
    implements Serializable {
        protected int m_attributeIndex;
        protected boolean m_negative;

        public AttributeOperand(String string, boolean bl) throws Exception {
            this.m_attributeIndex = Integer.parseInt(string.substring(1)) - 1;
            this.m_negative = bl;
        }

        public String toString() {
            String string = "";
            if (this.m_negative) {
                string = string + '-';
            }
            return string + "a" + (this.m_attributeIndex + 1);
        }
    }
}

