/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class FirstOrder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected Range m_DeltaCols = new Range();

    public String globalInfo() {
        return LocalString.get("This instance filter takes a range of N numeric attributes and replaces ") + LocalString.get("them with N-1 numeric attributes, the values of which are the difference ") + LocalString.get("between consecutive attribute values from the original instance. eg: \n\n") + LocalString.get("Original attribute values\n\n") + LocalString.get("   0.1, 0.2, 0.3, 0.1, 0.3\n\n") + LocalString.get("New attribute values\n\n") + LocalString.get("   0.1, 0.1, -0.2, 0.2\n\n") + LocalString.get("The range of attributes used is taken in numeric order. That is, a range ") + LocalString.get("spec of 7-11,3-5 will use the attribute ordering 3,4,5,7,8,9,10,11 for the ") + LocalString.get("differences, NOT 7,8,9,10,11,3,4,5.");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option(LocalString.get("\tSpecify list of columns to take the differences between.\n") + LocalString.get("\tFirst and last are valid indexes.\n") + LocalString.get("\t(default none)"), "R", 1, LocalString.get("-R <index1,index2-index4,...>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_DeltaCols.setUpper(this.getInputFormat().numAttributes() - 1);
        int n = 0;
        for (int i = this.getInputFormat().numAttributes() - 1; i >= 0; --i) {
            if (!this.m_DeltaCols.isInRange(i)) continue;
            ++n;
            if (this.getInputFormat().attribute(i).isNumeric()) continue;
            throw new UnsupportedAttributeTypeException(LocalString.get("Selected attributes must be all numeric"));
        }
        if (n == 1) {
            throw new Exception(LocalString.get("Cannot select only one attribute."));
        }
        FastVector fastVector = new FastVector();
        boolean bl = false;
        String string = null;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (this.m_DeltaCols.isInRange(i)) {
                if (bl) {
                    Attribute attribute = new Attribute(string);
                    fastVector.addElement(attribute);
                }
                string = instances.attribute(i).name();
                string = "'FO " + string.replace('\'', ' ').trim() + '\'';
                bl = true;
                continue;
            }
            fastVector.addElement((Attribute)instances.attribute(i).copy());
        }
        this.setOutputFormat(new Instances(instances.relationName(), fastVector, 0));
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instances instances = this.outputFormatPeek();
        double[] dArray = new double[instances.numAttributes()];
        boolean bl = false;
        double d = Instance.missingValue();
        int n = 0;
        int n2 = 0;
        while (n2 < instances.numAttributes()) {
            if (this.m_DeltaCols.isInRange(n)) {
                if (bl) {
                    dArray[n2++] = Instance.isMissingValue(d) || instance.isMissing(n) ? Instance.missingValue() : instance.value(n) - d;
                } else {
                    bl = true;
                }
                d = instance.value(n);
            } else {
                dArray[n2++] = instance.value(n);
            }
            ++n;
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.getInputStringIndex(), this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String attributeIndicesTipText() {
        return LocalString.get("Specify range of attributes to act on.") + LocalString.get(" This is a comma separated list of attribute indices, with") + LocalString.get(" \"first\" and \"last\" valid values. Specify an inclusive") + LocalString.get(" range with \"-\". E.g: \"first-3,5,6-10,last\".");
    }

    public String getAttributeIndices() {
        return this.m_DeltaCols.getRanges();
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_DeltaCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new FirstOrder(), stringArray);
            } else {
                Filter.filterFile(new FirstOrder(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

