/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import weka.LocalString;
import weka.core.Instances;

public class AttributeSelectionPanel
extends JPanel {
    protected JButton m_IncludeAll = new JButton("All");
    protected JButton m_RemoveAll = new JButton("None");
    protected JButton m_Invert = new JButton("Invert");
    protected JTable m_Table = new JTable();
    protected AttributeTableModel m_Model;

    public AttributeSelectionPanel() {
        this.m_IncludeAll.setToolTipText(LocalString.get("Selects all attributes"));
        this.m_IncludeAll.setEnabled(false);
        this.m_IncludeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.m_Model.includeAll();
            }
        });
        this.m_RemoveAll.setToolTipText(LocalString.get("Unselects all attributes"));
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.m_Model.removeAll();
            }
        });
        this.m_Invert.setToolTipText(LocalString.get("Inverts the current attribute selection"));
        this.m_Invert.setEnabled(false);
        this.m_Invert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeSelectionPanel.this.m_Model.invert();
            }
        });
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(new GridLayout(1, 3, 5, 5));
        jPanel.add(this.m_IncludeAll);
        jPanel.add(this.m_RemoveAll);
        jPanel.add(this.m_Invert);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public void setInstances(Instances instances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(instances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tableColumnModel = this.m_Table.getColumnModel();
            tableColumnModel.getColumn(0).setMaxWidth(60);
            tableColumnModel.getColumn(1).setMaxWidth(tableColumnModel.getColumn(1).getMinWidth());
            tableColumnModel.getColumn(2).setMinWidth(100);
        } else {
            this.m_Model.setInstances(instances);
            this.m_Table.clearSelection();
        }
        this.m_IncludeAll.setEnabled(true);
        this.m_RemoveAll.setEnabled(true);
        this.m_Invert.setEnabled(true);
        this.m_Table.sizeColumnsToFit(2);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model.getSelectedAttributes();
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception(LocalString.get("supply the name of an arff file"));
            }
            Instances instances = new Instances(new BufferedReader(new FileReader(stringArray[0])));
            AttributeSelectionPanel attributeSelectionPanel = new AttributeSelectionPanel();
            final JFrame jFrame = new JFrame(LocalString.get("Attribute Selection Panel"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)attributeSelectionPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            attributeSelectionPanel.setInstances(instances);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        protected Instances m_Instances;
        protected boolean[] m_Selected;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new boolean[this.m_Instances.numAttributes()];
        }

        public int getRowCount() {
            return this.m_Selected.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return new Boolean(this.m_Selected[n]);
                }
                case 2: {
                    return this.m_Instances.attribute(n).name();
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String("");
                }
                case 2: {
                    return new String("Name");
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                this.m_Selected[n] = (Boolean)object;
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public int[] getSelectedAttributes() {
            int[] nArray = new int[this.getRowCount()];
            int n = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.m_Selected[i]) continue;
                nArray[n++] = i;
            }
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            return nArray2;
        }

        public void includeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = true;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void removeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = false;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void invert() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = !this.m_Selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }
    }
}

