/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.converters.AbstractLoader;
import weka.core.converters.ArffLoader;
import weka.core.converters.CSVLoader;
import weka.gui.ComponentHelper;

public class ArffTableModel
implements TableModel,
Undoable {
    private HashSet listeners = new HashSet();
    private Instances data = null;
    private boolean notificationEnabled = true;
    private boolean undoEnabled = true;
    private boolean ignoreChanges = false;
    private Vector undoList = new Vector();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    private ArffTableModel() {
    }

    public ArffTableModel(String string) {
        this();
        if (string != null && !string.equals("")) {
            this.loadFile(string);
        }
    }

    public ArffTableModel(Instances instances) {
        this();
        this.data = instances;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public void setNotificationEnabled(boolean bl) {
        this.notificationEnabled = bl;
    }

    public boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    public void setUndoEnabled(boolean bl) {
        this.undoEnabled = bl;
    }

    private void loadFile(String string) {
        AbstractLoader abstractLoader = string.toLowerCase().endsWith(".arff") ? new ArffLoader() : (string.toLowerCase().endsWith(".csv") ? new CSVLoader() : null);
        if (abstractLoader != null) {
            try {
                abstractLoader.setSource(new File(string));
                this.data = abstractLoader.getDataSet();
            }
            catch (Exception exception) {
                ComponentHelper.showMessageBox(null, LocalString.get("Error loading file..."), exception.toString(), 2, 0);
                System.out.println(exception);
                this.data = null;
            }
        }
    }

    public void setInstances(Instances instances) {
        this.data = instances;
    }

    public Instances getInstances() {
        return this.data;
    }

    public Attribute getAttributeAt(int n) {
        if (n > 0 && n < this.getColumnCount()) {
            return this.data.attribute(n - 1);
        }
        return null;
    }

    public int getType(int n) {
        return this.getType(0, n);
    }

    public int getType(int n, int n2) {
        int n3 = 2;
        if (n >= 0 && n < this.getRowCount() && n2 > 0 & n2 < this.getColumnCount()) {
            n3 = this.data.instance(n).attribute(n2 - 1).type();
        }
        return n3;
    }

    public void deleteAttributeAt(int n) {
        this.deleteAttributeAt(n, true);
    }

    public void deleteAttributeAt(int n, boolean bl) {
        if (n > 0 && n < this.getColumnCount()) {
            if (!this.ignoreChanges) {
                this.addUndoPoint();
            }
            this.data.deleteAttributeAt(n - 1);
            if (bl) {
                this.notifyListener(new TableModelEvent(this, -1));
            }
        }
    }

    public void deleteAttributes(int[] nArray) {
        Arrays.sort(nArray);
        this.addUndoPoint();
        this.ignoreChanges = true;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deleteAttributeAt(nArray[i], false);
        }
        this.ignoreChanges = false;
        this.notifyListener(new TableModelEvent(this, -1));
    }

    public void renameAttributeAt(int n, String string) {
        if (n > 0 && n < this.getColumnCount()) {
            this.addUndoPoint();
            this.data.renameAttribute(n - 1, string);
            this.notifyListener(new TableModelEvent(this, -1));
        }
    }

    public void deleteInstanceAt(int n) {
        this.deleteInstanceAt(n, true);
    }

    public void deleteInstanceAt(int n, boolean bl) {
        if (n >= 0 && n < this.getRowCount()) {
            if (!this.ignoreChanges) {
                this.addUndoPoint();
            }
            this.data.delete(n);
            if (bl) {
                this.notifyListener(new TableModelEvent(this, n, n, -1, -1));
            }
        }
    }

    public void deleteInstances(int[] nArray) {
        Arrays.sort(nArray);
        this.addUndoPoint();
        this.ignoreChanges = true;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deleteInstanceAt(nArray[i], false);
        }
        this.ignoreChanges = false;
        this.notifyListener(new TableModelEvent(this, nArray[0], nArray[nArray.length - 1], -1, -1));
    }

    public void sortInstances(int n) {
        if (n > 0 && n < this.getColumnCount()) {
            this.addUndoPoint();
            this.data.sort(n - 1);
            this.notifyListener(new TableModelEvent(this));
        }
    }

    public int getAttributeColumn(String string) {
        int n = -1;
        for (int i = 0; i < this.data.numAttributes(); ++i) {
            if (!this.data.attribute(i).name().equals(string)) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        if (n >= 0 && n < this.getColumnCount()) {
            clazz = n == 0 ? (class$java$lang$Integer == null ? (class$java$lang$Integer = ArffTableModel.class$("java.lang.Integer")) : class$java$lang$Integer) : (this.getType(n) == 0 ? (class$java$lang$Double == null ? (class$java$lang$Double = ArffTableModel.class$("java.lang.Double")) : class$java$lang$Double) : (class$java$lang$String == null ? (class$java$lang$String = ArffTableModel.class$("java.lang.String")) : class$java$lang$String));
        }
        return clazz;
    }

    public int getColumnCount() {
        int n = 1;
        if (this.data != null) {
            n += this.data.numAttributes();
        }
        return n;
    }

    private boolean isClassIndex(int n) {
        int n2 = this.data.classIndex();
        boolean bl = n2 == -1 && this.data.numAttributes() == n || n2 == n - 1;
        return bl;
    }

    public String getColumnName(int n) {
        String string = "";
        if (n >= 0 && n < this.getColumnCount()) {
            if (n == 0) {
                string = LocalString.get("<html><center>No.<br><font size=\"-2\">&nbsp;</font></center></html>");
            } else if (this.data != null && n - 1 < this.data.numAttributes()) {
                string = "<html><center>";
                string = this.isClassIndex(n) ? string + "<b>" + this.data.attribute(n - 1).name() + "</b>" : string + this.data.attribute(n - 1).name();
                switch (this.getType(n)) {
                    case 3: {
                        string = string + LocalString.get("<br><font size=\"-2\">Date</font>");
                        break;
                    }
                    case 1: {
                        string = string + LocalString.get("<br><font size=\"-2\">Nominal</font>");
                        break;
                    }
                    case 2: {
                        string = string + LocalString.get("<br><font size=\"-2\">String</font>");
                        break;
                    }
                    case 0: {
                        string = string + LocalString.get("<br><font size=\"-2\">Numeric</font>");
                    }
                }
                string = string + "</center></html>";
            }
        }
        return string;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.numInstances();
    }

    public boolean isMissingAt(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < this.getRowCount() && n2 > 0 & n2 < this.getColumnCount()) {
            bl = this.data.instance(n).isMissing(n2 - 1);
        }
        return bl;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        Object object = null;
        if (n >= 0 && n < this.getRowCount() && n2 >= 0 & n2 < this.getColumnCount()) {
            if (n2 == 0) {
                object = new Integer(n + 1);
            } else if (this.isMissingAt(n, n2)) {
                object = null;
            } else {
                switch (this.getType(n2)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        object = this.data.instance(n).stringValue(n2 - 1);
                        break;
                    }
                    case 0: {
                        object = new Double(this.data.instance(n).value(n2 - 1));
                    }
                }
            }
        }
        if (this.getType(n2) != 0 && object != null && ((string = object.toString()).indexOf("\n") > -1 || string.indexOf("\r") > -1)) {
            string = string.replaceAll("\\r\\n", ", ");
            string = string.replaceAll("\\r", ", ").replaceAll("\\n", ", ");
            string = string.replaceAll(", $", "");
            object = string;
        }
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 > 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, n, n2, true);
    }

    public void setValueAt(Object object, int n, int n2, boolean bl) {
        if (!this.ignoreChanges) {
            this.addUndoPoint();
        }
        Object object2 = this.getValueAt(n, n2);
        int n3 = this.getType(n, n2);
        int n4 = n2 - 1;
        Instance instance = this.data.instance(n);
        Attribute attribute = instance.attribute(n4);
        if (object == null) {
            instance.setValue(n4, Instance.missingValue());
        } else {
            String string = object.toString();
            switch (n3) {
                case 3: {
                    try {
                        attribute.parseDate(string);
                        instance.setValue(n4, attribute.parseDate(string));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    if (attribute.indexOfValue(string) <= -1) break;
                    instance.setValue(n4, (double)attribute.indexOfValue(string));
                    break;
                }
                case 2: {
                    instance.setValue(n4, string);
                    break;
                }
                case 0: {
                    try {
                        Double.parseDouble(string);
                        instance.setValue(n4, Double.parseDouble(string));
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (bl && !("" + object2).equals("" + object)) {
            this.notifyListener(new TableModelEvent(this, n, n2));
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    public void notifyListener(TableModelEvent tableModelEvent) {
        if (!this.isNotificationEnabled()) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TableModelListener tableModelListener = (TableModelListener)iterator.next();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void clearUndo() {
        this.undoList = new Vector();
    }

    public boolean canUndo() {
        return !this.undoList.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            File file = (File)this.undoList.get(this.undoList.size() - 1);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                Instances instances = (Instances)objectInputStream.readObject();
                objectInputStream.close();
                this.setInstances(instances);
                this.notifyListener(new TableModelEvent(this, -1));
                this.notifyListener(new TableModelEvent(this));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            file.delete();
            this.undoList.remove(this.undoList.size() - 1);
        }
    }

    public void addUndoPoint() {
        if (!this.isUndoEnabled()) {
            return;
        }
        if (this.getInstances() != null) {
            try {
                File file = File.createTempFile("arffviewer", null);
                file.deleteOnExit();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                objectOutputStream.writeObject(this.getInstances());
                objectOutputStream.flush();
                objectOutputStream.close();
                this.undoList.add(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

