/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import weka.LocalString;
import weka.core.Memory;
import weka.gui.ComponentHelper;
import weka.gui.LookAndFeel;
import weka.gui.arffviewer.ArffViewerMainPanel;

public class ArffViewer
extends JFrame
implements WindowListener {
    private ArffViewerMainPanel m_MainPanel;
    private static Memory m_Memory = new Memory(true);
    private static ArffViewer m_Viewer;
    private static boolean m_FilesLoaded;
    private static String[] m_Args;

    public ArffViewer() {
        super("ARFF-Viewer");
        this.createFrame();
    }

    protected void createFrame() {
        this.setIconImage(ComponentHelper.getImage("weka_icon.gif"));
        this.setSize(800, 600);
        this.setCenteredLocation();
        this.setDefaultCloseOperation(2);
        this.removeWindowListener(this);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_MainPanel = new ArffViewerMainPanel(this);
        this.m_MainPanel.setConfirmExit(false);
        this.getContentPane().add((Component)this.m_MainPanel, "Center");
        this.setJMenuBar(this.m_MainPanel.getMenu());
    }

    protected int getCenteredLeft() {
        int n = this.getBounds().width;
        int n2 = (this.getGraphicsConfiguration().getBounds().width - n) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    protected int getCenteredTop() {
        int n = this.getBounds().height;
        int n2 = (this.getGraphicsConfiguration().getBounds().height - n) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public void setCenteredLocation() {
        this.setLocation(this.getCenteredLeft(), this.getCenteredTop());
    }

    public void setConfirmExit(boolean bl) {
        this.m_MainPanel.setConfirmExit(bl);
    }

    public boolean getConfirmExit() {
        return this.m_MainPanel.getConfirmExit();
    }

    public void setExitOnClose(boolean bl) {
        this.m_MainPanel.setExitOnClose(bl);
    }

    public boolean getExitOnClose() {
        return this.m_MainPanel.getExitOnClose();
    }

    public ArffViewerMainPanel getMainPanel() {
        return this.m_MainPanel;
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        while (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            this.getMainPanel().closeFile(false);
        }
        if (this.getConfirmExit()) {
            int n = ComponentHelper.showMessageBox(this, LocalString.get("Quit - ") + this.getTitle(), LocalString.get("Do you really want to quit?"), 0, 3);
            if (n == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
        if (this.getExitOnClose()) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static void main(String[] stringArray) throws Exception {
        LookAndFeel.setLookAndFeel();
        try {
            m_Viewer = new ArffViewer();
            m_Viewer.setExitOnClose(true);
            m_Viewer.setVisible(true);
            m_FilesLoaded = false;
            m_Args = stringArray;
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                if (m_Args.length > 0 && !m_FilesLoaded) {
                                    for (int i = 0; i < m_Args.length; ++i) {
                                        System.out.println(LocalString.get("Loading ") + (i + 1) + "/" + m_Args.length + ": '" + m_Args[i] + "'...");
                                        m_Viewer.getMainPanel().loadFile(m_Args[i]);
                                    }
                                    m_Viewer.getMainPanel().getTabbedPane().setSelectedIndex(0);
                                    System.out.println("Finished!");
                                    m_FilesLoaded = true;
                                }
                                Thread.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_Viewer.dispose();
                                m_Viewer = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println(LocalString.get("\ndisplayed message:"));
                                m_Memory.showOutOfMemory();
                                System.err.println("\nrestarting...");
                                System.gc();
                                m_Viewer = new ArffViewer();
                                m_Viewer.setExitOnClose(true);
                                m_Viewer.setVisible(true);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

