/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import weka.LocalString;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Visible;

public class BeanInstance
implements Serializable {
    private static Vector COMPONENTS = new Vector();
    public static final int IDLE = 0;
    public static final int BEAN_EXECUTING = 1;
    private Object m_bean;
    private int m_x;
    private int m_y;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public static void reset(JComponent jComponent) {
        BeanInstance.removeAllBeansFromContainer(jComponent);
        COMPONENTS = new Vector();
    }

    public static void removeAllBeansFromContainer(JComponent jComponent) {
        if (jComponent != null) {
            if (COMPONENTS != null) {
                for (int i = 0; i < COMPONENTS.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
                    Object object = beanInstance.getBean();
                    if (!Beans.isInstanceOf(object, class$javax$swing$JComponent == null ? BeanInstance.class$("javax.swing.JComponent") : class$javax$swing$JComponent)) continue;
                    jComponent.remove((JComponent)object);
                }
            }
            jComponent.revalidate();
        }
    }

    public static void addAllBeansToContainer(JComponent jComponent) {
        if (jComponent != null) {
            if (COMPONENTS != null) {
                for (int i = 0; i < COMPONENTS.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
                    Object object = beanInstance.getBean();
                    if (!Beans.isInstanceOf(object, class$javax$swing$JComponent == null ? BeanInstance.class$("javax.swing.JComponent") : class$javax$swing$JComponent)) continue;
                    jComponent.add((JComponent)object);
                }
            }
            jComponent.revalidate();
        }
    }

    public static Vector getBeanInstances() {
        return COMPONENTS;
    }

    public static void setBeanInstances(Vector vector, JComponent jComponent) {
        BeanInstance.reset(jComponent);
        if (jComponent != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object object = ((BeanInstance)vector.elementAt(i)).getBean();
                if (!Beans.isInstanceOf(object, class$javax$swing$JComponent == null ? BeanInstance.class$("javax.swing.JComponent") : class$javax$swing$JComponent)) continue;
                jComponent.add((JComponent)object);
            }
            jComponent.revalidate();
            jComponent.repaint();
        }
        COMPONENTS = vector;
    }

    public static void paintLabels(Graphics graphics) {
        graphics.setFont(new Font("Monospaced", 0, 10));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            if (!(beanInstance.getBean() instanceof Visible)) continue;
            int n2 = beanInstance.getX();
            int n3 = beanInstance.getY();
            int n4 = ((JComponent)beanInstance.getBean()).getWidth();
            int n5 = ((JComponent)beanInstance.getBean()).getHeight();
            String string = ((Visible)beanInstance.getBean()).getVisual().getText();
            int n6 = fontMetrics.stringWidth(string);
            if (n6 < n4) {
                graphics.drawString(string, n2 + n4 / 2 - n6 / 2, n3 + n5 + n + 2);
                continue;
            }
            int n7 = string.length() / 2;
            int n8 = string.length();
            int n9 = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) >= 'a' || Math.abs(n7 - j) >= n8) continue;
                n8 = Math.abs(n7 - j);
                n9 = j;
            }
            if (n9 != -1) {
                String string2 = string.substring(0, n9);
                String string3 = string.substring(n9, string.length());
                if (string2.length() > 1 && string3.length() > 1) {
                    graphics.drawString(string2, n2 + n4 / 2 - fontMetrics.stringWidth(string2) / 2, n3 + n5 + n * 1 + 2);
                    graphics.drawString(string3, n2 + n4 / 2 - fontMetrics.stringWidth(string3) / 2, n3 + n5 + n * 2 + 2);
                    continue;
                }
                graphics.drawString(string, n2 + n4 / 2 - fontMetrics.stringWidth(string) / 2, n3 + n5 + n * 1 + 2);
                continue;
            }
            graphics.drawString(string, n2 + n4 / 2 - fontMetrics.stringWidth(string) / 2, n3 + n5 + n * 1 + 2);
        }
    }

    public static BeanInstance findInstance(Point point) {
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            JComponent jComponent = (JComponent)beanInstance.getBean();
            rectangle = jComponent.getBounds(rectangle);
            if (!rectangle.contains(point)) continue;
            return beanInstance;
        }
        return null;
    }

    public static Vector findInstances(Rectangle rectangle) {
        Vector<BeanInstance> vector = new Vector<BeanInstance>();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            int n;
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            int n2 = beanInstance.getX() + beanInstance.getWidth() / 2;
            if (!rectangle.contains(n2, n = beanInstance.getY() + beanInstance.getHeight() / 2)) continue;
            vector.addElement(beanInstance);
        }
        return vector;
    }

    public BeanInstance(JComponent jComponent, Object object, int n, int n2) {
        this.m_bean = object;
        this.m_x = n;
        this.m_y = n2;
        this.addBean(jComponent);
    }

    public BeanInstance(JComponent jComponent, String string, int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        try {
            this.m_bean = Beans.instantiate(null, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.addBean(jComponent);
    }

    public void removeBean(JComponent jComponent) {
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            if ((BeanInstance)COMPONENTS.elementAt(i) != this) continue;
            System.err.println(LocalString.get("Removing bean"));
            COMPONENTS.removeElementAt(i);
        }
        if (jComponent != null) {
            jComponent.remove((JComponent)this.m_bean);
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void addBean(JComponent jComponent) {
        if (COMPONENTS.contains(this)) {
            return;
        }
        if (!Beans.isInstanceOf(this.m_bean, class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BeanInstance.class$("javax.swing.JComponent")) : class$javax$swing$JComponent)) {
            System.err.println(LocalString.get("Component is invisible!"));
            return;
        }
        COMPONENTS.addElement(this);
        JComponent jComponent2 = (JComponent)this.m_bean;
        Dimension dimension = jComponent2.getPreferredSize();
        int n = (int)(dimension.getWidth() / 2.0);
        int n2 = (int)(dimension.getHeight() / 2.0);
        this.m_x -= n;
        this.m_y -= n2;
        jComponent2.setLocation(this.m_x, this.m_y);
        jComponent2.validate();
        if (jComponent != null) {
            jComponent.add(jComponent2);
            jComponent.revalidate();
        }
    }

    public Object getBean() {
        return this.m_bean;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getWidth() {
        return ((JComponent)this.m_bean).getWidth();
    }

    public int getHeight() {
        return ((JComponent)this.m_bean).getHeight();
    }

    public void setXY(int n, int n2) {
        this.setX(n);
        this.setY(n2);
        if (this.getBean() instanceof MetaBean) {
            ((MetaBean)this.getBean()).shiftBeans(this, false);
        }
    }

    public void setX(int n) {
        this.m_x = n;
        ((JComponent)this.m_bean).setLocation(this.m_x, this.m_y);
        ((JComponent)this.m_bean).validate();
    }

    public void setY(int n) {
        this.m_y = n;
        ((JComponent)this.m_bean).setLocation(this.m_x, this.m_y);
        ((JComponent)this.m_bean).validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

