/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.UserRequestAcceptor;

public class ClustererPerformanceEvaluator
extends AbstractEvaluator
implements BatchClustererListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private transient ClusterEvaluation m_eval;
    private transient Clusterer m_clusterer;
    private transient Thread m_evaluateThread = null;
    private Vector m_textListeners = new Vector();

    public ClustererPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClustererPerformanceEvaluator.gif", "weka/gui/beans/icons/ClustererPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClustererPerformanceEvaluator");
    }

    public String globalInfo() {
        return LocalString.get("Evaluate the performance of batch trained clusterers.");
    }

    public void acceptClusterer(final BatchClustererEvent batchClustererEvent) {
        if (batchClustererEvent.getTestSet().isStructureOnly()) {
            return;
        }
        try {
            if (this.m_evaluateThread == null) {
                this.m_evaluateThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        boolean bl = false;
                        String string = ClustererPerformanceEvaluator.this.m_visual.getText();
                        try {
                            block12: {
                                try {
                                    if (batchClustererEvent.getSetNumber() == 1 || batchClustererEvent.getClusterer() != ClustererPerformanceEvaluator.this.m_clusterer) {
                                        ClustererPerformanceEvaluator.this.m_eval = new ClusterEvaluation();
                                        ClustererPerformanceEvaluator.this.m_clusterer = batchClustererEvent.getClusterer();
                                        ClustererPerformanceEvaluator.this.m_eval.setClusterer(ClustererPerformanceEvaluator.this.m_clusterer);
                                    }
                                    if (batchClustererEvent.getSetNumber() <= batchClustererEvent.getMaxSetNumber()) {
                                        ClustererPerformanceEvaluator.this.m_visual.setText(LocalString.get("Evaluating (") + batchClustererEvent.getSetNumber() + ")...");
                                        if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                            ClustererPerformanceEvaluator.this.m_logger.statusMessage(LocalString.get("ClustererPerformaceEvaluator : ") + LocalString.get("evaluating (") + batchClustererEvent.getSetNumber() + ")...");
                                        }
                                        ClustererPerformanceEvaluator.this.m_visual.setAnimated();
                                        if (batchClustererEvent.getTestSet().getDataSet().classIndex() != -1 && batchClustererEvent.getTestSet().getDataSet().classAttribute().isNumeric()) {
                                            bl = true;
                                            batchClustererEvent.getTestSet().getDataSet().setClassIndex(-1);
                                        }
                                        ClustererPerformanceEvaluator.this.m_eval.evaluateClusterer(batchClustererEvent.getTestSet().getDataSet());
                                    }
                                    if (batchClustererEvent.getSetNumber() != batchClustererEvent.getMaxSetNumber()) break block12;
                                    String string2 = ClustererPerformanceEvaluator.this.m_clusterer.getClass().getName();
                                    string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                                    String string3 = batchClustererEvent.getTestOrTrain() == 0 ? "test" : "training";
                                    String string4 = LocalString.get("=== Evaluation result for ") + string3 + LocalString.get(" instances ===\n\n") + LocalString.get("Scheme: ") + string2 + "\n" + LocalString.get("Relation: ") + batchClustererEvent.getTestSet().getDataSet().relationName() + "\n\n" + ClustererPerformanceEvaluator.this.m_eval.clusterResultsToString();
                                    if (bl) {
                                        string4 = string4 + LocalString.get("\n\nNo class based evaluation possible. Class attribute has to be nominal.");
                                    }
                                    TextEvent textEvent = new TextEvent(ClustererPerformanceEvaluator.this, string4, string2);
                                    ClustererPerformanceEvaluator.this.notifyTextListeners(textEvent);
                                    if (ClustererPerformanceEvaluator.this.m_logger == null) break block12;
                                    ClustererPerformanceEvaluator.this.m_logger.statusMessage("Done.");
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Object var8_9 = null;
                                    ClustererPerformanceEvaluator.this.m_visual.setText(string);
                                    ClustererPerformanceEvaluator.this.m_visual.setStatic();
                                    ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                                    if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                        ClustererPerformanceEvaluator.this.m_logger.logMessage(LocalString.get("Evaluation interrupted!"));
                                        ClustererPerformanceEvaluator.this.m_logger.statusMessage("OK");
                                    }
                                    ClustererPerformanceEvaluator.this.block(false);
                                    return;
                                }
                            }
                            Object var8_8 = null;
                            ClustererPerformanceEvaluator.this.m_visual.setText(string);
                            ClustererPerformanceEvaluator.this.m_visual.setStatic();
                            ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                ClustererPerformanceEvaluator.this.m_logger.logMessage(LocalString.get("Evaluation interrupted!"));
                                ClustererPerformanceEvaluator.this.m_logger.statusMessage("OK");
                            }
                            ClustererPerformanceEvaluator.this.block(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            ClustererPerformanceEvaluator.this.m_visual.setText(string);
                            ClustererPerformanceEvaluator.this.m_visual.setStatic();
                            ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                ClustererPerformanceEvaluator.this.m_logger.logMessage(LocalString.get("Evaluation interrupted!"));
                                ClustererPerformanceEvaluator.this.m_logger.statusMessage("OK");
                            }
                            ClustererPerformanceEvaluator.this.block(false);
                            throw throwable;
                        }
                    }
                };
                this.m_evaluateThread.setPriority(1);
                this.m_evaluateThread.start();
                this.block(true);
                this.m_evaluateThread = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            System.err.println(LocalString.get("Listener is BeanCommon"));
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_evaluateThread != null) {
            this.m_evaluateThread.interrupt();
            this.m_evaluateThread.stop();
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_evaluateThread != null && this.m_evaluateThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_evaluateThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + LocalString.get(" not supported (ClustererPerformanceEvaluator)"));
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        ClustererPerformanceEvaluator clustererPerformanceEvaluator = this;
        synchronized (clustererPerformanceEvaluator) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
    }
}

