/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.LocalString;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class DataVisualizer
extends JPanel
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    protected BeanVisual m_visual;
    protected transient Instances m_visualizeDataSet;
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private VisualizePanel m_visPanel;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public DataVisualizer() {
        this.appearanceFinal();
    }

    public String globalInfo() {
        return LocalString.get("Visualize incoming data/training/test sets in a 2D scatter plot.");
    }

    protected void appearanceDesign() {
        this.m_visPanel = null;
        this.removeAll();
        this.m_visual = new BeanVisual("DataVisualizer", "weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Instances instances = trainingSetEvent.getTrainingSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public void acceptTestSet(TestSetEvent testSetEvent) {
        Instances instances = testSetEvent.getTestSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public synchronized void acceptDataSet(DataSetEvent dataSetEvent) {
        if (dataSetEvent.isStructureOnly()) {
            return;
        }
        this.m_visualizeDataSet = new Instances(dataSetEvent.getDataSet());
        if (this.m_visualizeDataSet.classIndex() < 0) {
            this.m_visualizeDataSet.setClassIndex(this.m_visualizeDataSet.numAttributes() - 1);
        }
        if (!this.m_design) {
            try {
                this.setInstances(this.m_visualizeDataSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            vector.addElement(LocalString.get("Show plot"));
        }
        return vector.elements();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public void setBeanContext(BeanContext beanContext) {
        this.m_beanContext = beanContext;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void setInstances(Instances instances) throws Exception {
        if (this.m_design) {
            throw new Exception(LocalString.get("This method is not to be used during design ") + LocalString.get("time. It is meant to be used if this ") + LocalString.get("bean is being used programatically as as ") + LocalString.get("stand alone component."));
        }
        this.m_visualizeDataSet = instances;
        PlotData2D plotData2D = new PlotData2D(this.m_visualizeDataSet);
        plotData2D.setPlotName(this.m_visualizeDataSet.relationName());
        try {
            this.m_visPanel.setMasterPlot(plotData2D);
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("Problem setting up ") + LocalString.get("visualization (DataVisualizer)"));
            exception.printStackTrace();
        }
    }

    public void performRequest(String string) {
        block7: {
            if (string.compareTo(LocalString.get("Show plot")) == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        VisualizePanel visualizePanel = new VisualizePanel();
                        PlotData2D plotData2D = new PlotData2D(this.m_visualizeDataSet);
                        plotData2D.setPlotName(this.m_visualizeDataSet.relationName());
                        try {
                            visualizePanel.setMasterPlot(plotData2D);
                        }
                        catch (Exception exception) {
                            System.err.println(LocalString.get("Problem setting up ") + LocalString.get("visualization (DataVisualizer)"));
                            exception.printStackTrace();
                        }
                        final JFrame jFrame = new JFrame("Visualize");
                        jFrame.setSize(800, 600);
                        jFrame.getContentPane().setLayout(new BorderLayout());
                        jFrame.getContentPane().add((Component)visualizePanel, "Center");
                        jFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent windowEvent) {
                                jFrame.dispose();
                                DataVisualizer.this.m_framePoppedUp = false;
                            }
                        });
                        jFrame.setVisible(true);
                        this.m_popupFrame = jFrame;
                        break block7;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(string + LocalString.get(" not supported (DataVisualizer)"));
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println(LocalString.get("Usage: DataVisualizer <dataset>"));
                System.exit(1);
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            Instances instances = new Instances(bufferedReader);
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            DataVisualizer dataVisualizer = new DataVisualizer();
            dataVisualizer.setInstances(instances);
            jFrame.getContentPane().add((Component)dataVisualizer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

