/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.core.Instances;
import weka.core.RTSI;
import weka.experiment.Experiment;
import weka.gui.ExtensionFileFilter;
import weka.gui.experiment.ExperimenterDefaults;

public class DatasetListPanel
extends JPanel
implements ActionListener {
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton(LocalString.get("Add new..."));
    protected JButton m_DeleteBut = new JButton(LocalString.get("Delete selected"));
    protected JCheckBox m_relativeCheck = new JCheckBox(LocalString.get("Use relative paths"));
    protected FileFilter m_ArffFilter = new ExtensionFileFilter(Instances.FILE_EXTENSION, LocalString.get("Arff data files"));
    protected File m_UserDir = new File(System.getProperty("user.dir"));
    protected JFileChooser m_FileChooser = new JFileChooser(ExperimenterDefaults.getInitialDatasetsDirectory());

    public DatasetListPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public DatasetListPanel() {
        this.m_List = new JList();
        this.m_FileChooser.setFileFilter(this.m_ArffFilter);
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.m_relativeCheck.setSelected(ExperimenterDefaults.getUseRelativePaths());
        this.m_relativeCheck.setToolTipText(LocalString.get("Store file paths relative to ") + LocalString.get("the start directory"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Datasets"));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_AddBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_DeleteBut, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_relativeCheck, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_AddBut.setEnabled(true);
        this.m_List.setModel(this.m_Exp.getDatasets());
        if (this.m_Exp.getDatasets().size() > 0) {
            this.m_DeleteBut.setEnabled(true);
        }
    }

    protected void getFilesRecursively(File file, Vector vector) {
        try {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = file.getCanonicalPath() + File.separator + stringArray[i];
                File file2 = new File(stringArray[i]);
                if (!this.m_FileChooser.getFileFilter().accept(file2)) continue;
                if (file2.isDirectory()) {
                    this.getFilesRecursively(file2, vector);
                    continue;
                }
                vector.addElement(file2);
            }
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("IOError occured when reading list of files"));
        }
    }

    protected File createRelativePath(File file) throws Exception {
        String string = this.m_UserDir.getAbsolutePath() + File.separator;
        String string2 = new File(file.getParent()).getPath() + File.separator;
        String string3 = file.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("." + File.separator);
        int n = string2.indexOf(string);
        if (n == 0) {
            if (string.length() == string2.length()) {
                stringBuffer.append(string3);
            } else {
                int n2 = string.length();
                stringBuffer.append(string2.substring(n2));
                stringBuffer.append(string3);
            }
        } else {
            int n3;
            int n4 = 0;
            String string4 = new String(string);
            while (string4.indexOf(File.separator) != -1) {
                int n5 = string4.indexOf(File.separator);
                ++n4;
                string4 = string4.substring(n5 + 1, string4.length());
            }
            String string5 = new String(string2);
            String string6 = new String(string);
            int n6 = 0;
            while (string5.indexOf(File.separator) != -1) {
                String string7;
                n3 = string5.indexOf(File.separator);
                int n7 = string6.indexOf(File.separator);
                String string8 = string5.substring(0, n3 + 1);
                if (string8.compareTo(string7 = string6.substring(0, n7 + 1)) != 0) {
                    if (n6 != 0) break;
                    n6 = -1;
                    break;
                }
                ++n6;
                string5 = string5.substring(n3 + 1, string5.length());
                string6 = string6.substring(n7 + 1, string6.length());
            }
            if (n6 == -1) {
                throw new Exception(LocalString.get("Can't construct a path to file relative to user ") + "dir.");
            }
            if (string5.indexOf(File.separator) == -1) {
                string5 = "";
            }
            for (n3 = 0; n3 < n4 - n6; ++n3) {
                stringBuffer.append(".." + File.separator);
            }
            stringBuffer.append(string5 + string3);
        }
        return new File(stringBuffer.toString());
    }

    protected File convertToRelativePath(File file) throws Exception {
        File file2 = null;
        if (File.separator.equals("\\")) {
            try {
                String string = file.getPath();
                string = string.substring(0, 1).toLowerCase() + string.substring(1);
                file2 = this.createRelativePath(new File(string));
            }
            catch (Exception exception) {
                file2 = this.createRelativePath(file);
            }
        } else {
            file2 = this.createRelativePath(file);
        }
        return file2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.m_relativeCheck.isSelected();
        if (actionEvent.getSource() == this.m_AddBut) {
            int n = this.m_FileChooser.showOpenDialog(this);
            if (n == 0) {
                if (this.m_FileChooser.isMultiSelectionEnabled()) {
                    File[] fileArray = this.m_FileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        Serializable serializable;
                        if (fileArray[i].isDirectory()) {
                            serializable = new Vector();
                            this.getFilesRecursively(fileArray[i], (Vector)serializable);
                            RTSI rTSI = new RTSI();
                            Collections.sort(serializable, rTSI.new RTSI.StringCompare());
                            for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                                File file = (File)((Vector)serializable).elementAt(j);
                                if (bl) {
                                    try {
                                        file = this.convertToRelativePath(file);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                this.m_Exp.getDatasets().addElement(file);
                            }
                            continue;
                        }
                        serializable = fileArray[i];
                        if (bl) {
                            try {
                                serializable = this.convertToRelativePath((File)serializable);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(serializable);
                    }
                    this.m_DeleteBut.setEnabled(true);
                } else {
                    if (this.m_FileChooser.getSelectedFile().isDirectory()) {
                        Vector vector = new Vector();
                        this.getFilesRecursively(this.m_FileChooser.getSelectedFile(), vector);
                        RTSI rTSI = new RTSI();
                        Collections.sort(vector, rTSI.new RTSI.StringCompare());
                        for (int i = 0; i < vector.size(); ++i) {
                            File file = (File)vector.elementAt(i);
                            if (bl) {
                                try {
                                    file = this.convertToRelativePath(file);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            this.m_Exp.getDatasets().addElement(file);
                        }
                    } else {
                        File file = this.m_FileChooser.getSelectedFile();
                        if (bl) {
                            try {
                                file = this.convertToRelativePath(file);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(file);
                    }
                    this.m_DeleteBut.setEnabled(true);
                }
            }
        } else if (actionEvent.getSource() == this.m_DeleteBut) {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    this.m_Exp.getDatasets().removeElementAt(n);
                    if (this.m_Exp.getDatasets().size() > n) {
                        this.m_List.setSelectedIndex(n);
                        continue;
                    }
                    this.m_List.setSelectedIndex(n - 1);
                }
            }
            if (this.m_List.getSelectedIndex() == -1) {
                this.m_DeleteBut.setEnabled(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Dataset List Editor"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            DatasetListPanel datasetListPanel = new DatasetListPanel();
            jFrame.getContentPane().add((Component)datasetListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            System.err.println(LocalString.get("Short nap"));
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            datasetListPanel.setExperiment(new Experiment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

