/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import weka.LocalString;
import weka.core.Memory;
import weka.experiment.Experiment;
import weka.gui.LookAndFeel;
import weka.gui.experiment.ResultsPanel;
import weka.gui.experiment.RunPanel;
import weka.gui.experiment.SetupModePanel;

public class Experimenter
extends JPanel {
    protected SetupModePanel m_SetupPanel;
    protected RunPanel m_RunPanel;
    protected ResultsPanel m_ResultsPanel;
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected boolean m_ClassFirst = false;
    private static Experimenter m_experimenter;
    private static Memory m_Memory;

    public Experimenter(boolean bl) {
        this.m_SetupPanel = new SetupModePanel();
        this.m_ResultsPanel = new ResultsPanel();
        this.m_RunPanel = new RunPanel();
        this.m_RunPanel.setResultsPanel(this.m_ResultsPanel);
        this.m_ClassFirst = bl;
        this.m_TabbedPane.addTab("Setup", null, this.m_SetupPanel, LocalString.get("Set up the experiment"));
        this.m_TabbedPane.addTab("Run", null, this.m_RunPanel, LocalString.get("Run the experiment"));
        this.m_TabbedPane.addTab("Analyse", null, this.m_ResultsPanel, LocalString.get("Analyse experiment results"));
        this.m_TabbedPane.setSelectedIndex(0);
        this.m_TabbedPane.setEnabledAt(1, false);
        this.m_SetupPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Experiment experiment = Experimenter.this.m_SetupPanel.getExperiment();
                experiment.classFirst(Experimenter.this.m_ClassFirst);
                Experimenter.this.m_RunPanel.setExperiment(experiment);
                Experimenter.this.m_TabbedPane.setEnabledAt(1, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            boolean bl = false;
            if (stringArray.length > 0) {
                bl = stringArray[0].equals("CLASS_FIRST");
            }
            m_experimenter = new Experimenter(bl);
            final JFrame jFrame = new JFrame(LocalString.get("Weka Experiment Environment"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_experimenter, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jFrame.dispose();
                                m_experimenter = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println(LocalString.get("\ndisplayed message:"));
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }
}

