/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RemoteExperiment;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.xml.XMLExperiment;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.experiment.DatasetListPanel;
import weka.gui.experiment.DistributeExperimentPanel;
import weka.gui.experiment.GeneratorPropertyIteratorPanel;
import weka.gui.experiment.RunNumberPanel;

public class SetupPanel
extends JPanel {
    protected Experiment m_Exp;
    protected JButton m_OpenBut = new JButton("Open...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected JButton m_NewBut = new JButton("New");
    protected FileFilter m_ExpFilter = new ExtensionFileFilter(Experiment.FILE_EXTENSION, LocalString.get("Experiment configuration files (*") + Experiment.FILE_EXTENSION + ")");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".koml", LocalString.get("Experiment configuration files (*") + ".koml" + ")");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", LocalString.get("Experiment configuration files (*.xml)"));
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected GenericObjectEditor m_RPEditor = new GenericObjectEditor();
    protected PropertyPanel m_RPEditorPanel = new PropertyPanel(this.m_RPEditor);
    protected GenericObjectEditor m_RLEditor = new GenericObjectEditor();
    protected PropertyPanel m_RLEditorPanel = new PropertyPanel(this.m_RLEditor);
    protected GeneratorPropertyIteratorPanel m_GeneratorPropertyPanel = new GeneratorPropertyIteratorPanel();
    protected RunNumberPanel m_RunNumberPanel = new RunNumberPanel();
    protected DistributeExperimentPanel m_DistributeExperimentPanel = new DistributeExperimentPanel();
    protected DatasetListPanel m_DatasetListPanel = new DatasetListPanel();
    protected JButton m_NotesButton = new JButton("Notes");
    protected JFrame m_NotesFrame = new JFrame("Notes");
    protected JTextArea m_NotesText = new JTextArea(null, 10, 0);
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected JRadioButton m_advanceDataSetFirst = new JRadioButton(LocalString.get("Data sets first"));
    protected JRadioButton m_advanceIteratorFirst = new JRadioButton(LocalString.get("Custom generator first"));
    ActionListener m_RadioListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            SetupPanel.this.updateRadioLinks();
        }
    };
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$weka$gui$FileEditor;
    static /* synthetic */ Class class$weka$experiment$ResultListener;
    static /* synthetic */ Class class$weka$gui$GenericObjectEditor;
    static /* synthetic */ Class class$weka$experiment$ResultProducer;
    static /* synthetic */ Class class$weka$experiment$SplitEvaluator;
    static /* synthetic */ Class class$weka$classifiers$Classifier;
    static /* synthetic */ Class array$Lweka$classifiers$Classifier;
    static /* synthetic */ Class class$weka$gui$GenericArrayEditor;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$weka$filters$Filter;
    static /* synthetic */ Class class$weka$attributeSelection$ASEvaluation;
    static /* synthetic */ Class class$weka$attributeSelection$ASSearch;
    static /* synthetic */ Class class$weka$attributeSelection$UnsupervisedSubsetEvaluator;
    static /* synthetic */ Class class$weka$clusterers$Clusterer;
    static /* synthetic */ Class class$weka$clusterers$DensityBasedClusterer;
    static /* synthetic */ Class class$weka$core$SelectedTag;
    static /* synthetic */ Class class$weka$gui$SelectedTagEditor;
    static /* synthetic */ Class class$weka$classifiers$CostMatrix;
    static /* synthetic */ Class class$weka$gui$CostMatrixEditor;

    public SetupPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public SetupPanel() {
        this.m_DistributeExperimentPanel.addCheckBoxActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SetupPanel.this.m_DistributeExperimentPanel.distributedExperimentSelected()) {
                    if (!(SetupPanel.this.m_Exp instanceof RemoteExperiment)) {
                        try {
                            RemoteExperiment remoteExperiment = new RemoteExperiment(SetupPanel.this.m_Exp);
                            SetupPanel.this.setExperiment(remoteExperiment);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (SetupPanel.this.m_Exp instanceof RemoteExperiment) {
                    SetupPanel.this.setExperiment(((RemoteExperiment)SetupPanel.this.m_Exp).getBaseExperiment());
                }
            }
        });
        this.m_NewBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPanel.this.setExperiment(new Experiment());
            }
        });
        this.m_SaveBut.setEnabled(false);
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPanel.this.saveExperiment();
            }
        });
        this.m_OpenBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPanel.this.openExperiment();
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_ExpFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        this.m_FileChooser.setFileFilter(this.m_ExpFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_GeneratorPropertyPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPanel.this.updateRadioLinks();
            }
        });
        this.m_RPEditor.setClassType(class$weka$experiment$ResultProducer == null ? (class$weka$experiment$ResultProducer = SetupPanel.class$("weka.experiment.ResultProducer")) : class$weka$experiment$ResultProducer);
        this.m_RPEditor.setEnabled(false);
        this.m_RPEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SetupPanel.this.m_Exp.setResultProducer((ResultProducer)SetupPanel.this.m_RPEditor.getValue());
                SetupPanel.this.m_Exp.setUsePropertyIterator(false);
                SetupPanel.this.m_Exp.setPropertyArray(null);
                SetupPanel.this.m_Exp.setPropertyPath(null);
                SetupPanel.this.m_GeneratorPropertyPanel.setExperiment(SetupPanel.this.m_Exp);
                SetupPanel.this.repaint();
            }
        });
        this.m_RLEditor.setClassType(class$weka$experiment$ResultListener == null ? (class$weka$experiment$ResultListener = SetupPanel.class$("weka.experiment.ResultListener")) : class$weka$experiment$ResultListener);
        this.m_RLEditor.setEnabled(false);
        this.m_RLEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SetupPanel.this.m_Exp.setResultListener((ResultListener)SetupPanel.this.m_RLEditor.getValue());
                SetupPanel.this.m_Support.firePropertyChange("", null, null);
                SetupPanel.this.repaint();
            }
        });
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPanel.this.m_NotesButton.setEnabled(false);
                SetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SetupPanel.this.m_Exp.setNotes(SetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SetupPanel.this.m_Exp.setNotes(SetupPanel.this.m_NotesText.getText());
            }
        });
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_OpenBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_SaveBut, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_NewBut, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(LocalString.get("Result generator")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel2.add((Component)this.m_RPEditorPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Destination"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel3.add((Component)this.m_RLEditorPanel, "North");
        this.m_advanceDataSetFirst.setEnabled(false);
        this.m_advanceIteratorFirst.setEnabled(false);
        this.m_advanceDataSetFirst.setToolTipText(LocalString.get("Advance data set before custom generator"));
        this.m_advanceIteratorFirst.setToolTipText(LocalString.get("Advance custom generator before data set"));
        this.m_advanceDataSetFirst.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_advanceDataSetFirst);
        buttonGroup.add(this.m_advanceIteratorFirst);
        this.m_advanceDataSetFirst.addActionListener(this.m_RadioListener);
        this.m_advanceIteratorFirst.addActionListener(this.m_RadioListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(LocalString.get("Iteration control")));
        jPanel4.setLayout(new GridLayout(1, 2));
        jPanel4.add(this.m_advanceDataSetFirst);
        jPanel4.add(this.m_advanceIteratorFirst);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel6.add((Component)this.m_RunNumberPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        jPanel6.add((Component)this.m_DistributeExperimentPanel, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel7.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel7.add((Component)jPanel4, gridBagConstraints);
        jPanel5.add((Component)jPanel7, "North");
        jPanel5.add((Component)this.m_DatasetListPanel, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 2));
        jPanel8.add(jPanel5);
        jPanel8.add(this.m_GeneratorPropertyPanel);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(2, 1));
        jPanel9.add(jPanel3);
        jPanel9.add(jPanel2);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)this.m_NotesButton, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)jPanel8, "Center");
        jPanel11.add((Component)jPanel10, "South");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.add((Component)jPanel, "North");
        jPanel12.add((Component)jPanel9, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel12, "North");
        this.add((Component)jPanel11, "Center");
    }

    protected void removeNotesFrame() {
        this.m_NotesFrame.setVisible(false);
    }

    public void setExperiment(Experiment experiment) {
        boolean bl = experiment.getUsePropertyIterator();
        Object object = experiment.getPropertyArray();
        PropertyNode[] propertyNodeArray = experiment.getPropertyPath();
        this.m_Exp = experiment;
        this.m_SaveBut.setEnabled(true);
        this.m_RPEditor.setValue(this.m_Exp.getResultProducer());
        this.m_RPEditor.setEnabled(true);
        this.m_RPEditorPanel.repaint();
        this.m_RLEditor.setValue(this.m_Exp.getResultListener());
        this.m_RLEditor.setEnabled(true);
        this.m_RLEditorPanel.repaint();
        this.m_NotesText.setText(experiment.getNotes());
        this.m_NotesButton.setEnabled(true);
        this.m_advanceDataSetFirst.setSelected(this.m_Exp.getAdvanceDataSetFirst());
        this.m_advanceIteratorFirst.setSelected(!this.m_Exp.getAdvanceDataSetFirst());
        this.m_advanceDataSetFirst.setEnabled(true);
        this.m_advanceIteratorFirst.setEnabled(true);
        experiment.setPropertyPath(propertyNodeArray);
        experiment.setPropertyArray(object);
        experiment.setUsePropertyIterator(bl);
        this.m_GeneratorPropertyPanel.setExperiment(this.m_Exp);
        this.m_RunNumberPanel.setExperiment(this.m_Exp);
        this.m_DatasetListPanel.setExperiment(this.m_Exp);
        this.m_DistributeExperimentPanel.setExperiment(this.m_Exp);
        this.m_Support.firePropertyChange("", null, null);
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    private void openExperiment() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!file.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!file.getName().toLowerCase().endsWith(".koml")) {
                file = new File(file.getParent(), file.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !file.getName().toLowerCase().endsWith(".xml")) {
            file = new File(file.getParent(), file.getName() + ".xml");
        }
        try {
            Experiment experiment;
            if (KOML.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".koml")) {
                experiment = (Experiment)KOML.read(file.getAbsolutePath());
            } else if (file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                XMLExperiment xMLExperiment = new XMLExperiment();
                experiment = (Experiment)xMLExperiment.read(file);
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
                experiment = (Experiment)objectInputStream.readObject();
                objectInputStream.close();
            }
            this.setExperiment(experiment);
            System.err.println(LocalString.get("Opened experiment:\n") + this.m_Exp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, LocalString.get("Couldn't open experiment file:\n") + file + "\nReason:\n" + exception.getMessage(), LocalString.get("Open Experiment"), 0);
        }
    }

    private void saveExperiment() {
        int n = this.m_FileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!file.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!file.getName().toLowerCase().endsWith(".koml")) {
                file = new File(file.getParent(), file.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !file.getName().toLowerCase().endsWith(".xml")) {
            file = new File(file.getParent(), file.getName() + ".xml");
        }
        try {
            if (KOML.isPresent() && file.getAbsolutePath().toLowerCase().endsWith(".koml")) {
                KOML.write(file.getAbsolutePath(), (Object)this.m_Exp);
            } else if (file.getAbsolutePath().toLowerCase().endsWith(".xml")) {
                XMLExperiment xMLExperiment = new XMLExperiment();
                xMLExperiment.write(file, (Object)this.m_Exp);
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                objectOutputStream.writeObject(this.m_Exp);
                objectOutputStream.close();
            }
            System.err.println(LocalString.get("Saved experiment:\n") + this.m_Exp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, LocalString.get("Couldn't save experiment file:\n") + file + "\nReason:\n" + exception.getMessage(), LocalString.get("Save Experiment"), 0);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    private void updateRadioLinks() {
        this.m_advanceDataSetFirst.setEnabled(this.m_GeneratorPropertyPanel.getEditorActive());
        this.m_advanceIteratorFirst.setEnabled(this.m_GeneratorPropertyPanel.getEditorActive());
        if (this.m_Exp != null) {
            if (!this.m_GeneratorPropertyPanel.getEditorActive()) {
                this.m_Exp.setAdvanceDataSetFirst(true);
            } else {
                this.m_Exp.setAdvanceDataSetFirst(this.m_advanceDataSetFirst.isSelected());
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            boolean bl = Utils.getFlag('l', stringArray);
            boolean bl2 = Utils.getFlag('s', stringArray);
            String string = Utils.getOption('f', stringArray);
            if ((bl || bl2) && string.length() == 0) {
                throw new Exception(LocalString.get("A filename must be given with the -f option"));
            }
            Experiment experiment = null;
            if (bl) {
                object2 = new FileInputStream(string);
                object = new ObjectInputStream(new BufferedInputStream((InputStream)object2));
                experiment = (Experiment)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            } else {
                experiment = new Experiment();
            }
            System.err.println(LocalString.get("Initial Experiment:\n") + experiment.toString());
            object2 = new JFrame(LocalString.get("Weka Experiment Setup"));
            ((JFrame)object2).getContentPane().setLayout(new BorderLayout());
            object = new SetupPanel();
            ((JFrame)object2).getContentPane().add((Component)object, "Center");
            ((Window)object2).addWindowListener(new WindowAdapter((SetupPanel)object, bl2, string, (JFrame)object2){
                private final /* synthetic */ SetupPanel val$sp;
                private final /* synthetic */ boolean val$writeExp;
                private final /* synthetic */ String val$expFile;
                private final /* synthetic */ JFrame val$jf;
                {
                    this.val$sp = setupPanel;
                    this.val$writeExp = bl;
                    this.val$expFile = string;
                    this.val$jf = jFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    System.err.println(LocalString.get("\nFinal Experiment:\n") + this.val$sp.m_Exp.toString());
                    if (this.val$writeExp) {
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(this.val$expFile);
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                            objectOutputStream.writeObject(this.val$sp.m_Exp);
                            objectOutputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            System.err.println(LocalString.get("Couldn't write experiment to: ") + this.val$expFile + '\n' + exception.getMessage());
                        }
                    }
                    this.val$jf.dispose();
                    System.exit(0);
                }
            });
            ((Window)object2).pack();
            ((Window)object2).setVisible(true);
            System.err.println(LocalString.get("Short nap"));
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            ((SetupPanel)object).setExperiment(experiment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.err.println(LocalString.get("---Registering Weka Editors---"));
        PropertyEditorManager.registerEditor(class$java$io$File == null ? (class$java$io$File = SetupPanel.class$("java.io.File")) : class$java$io$File, class$weka$gui$FileEditor == null ? (class$weka$gui$FileEditor = SetupPanel.class$("weka.gui.FileEditor")) : class$weka$gui$FileEditor);
        PropertyEditorManager.registerEditor(class$weka$experiment$ResultListener == null ? (class$weka$experiment$ResultListener = SetupPanel.class$("weka.experiment.ResultListener")) : class$weka$experiment$ResultListener, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$experiment$ResultProducer == null ? (class$weka$experiment$ResultProducer = SetupPanel.class$("weka.experiment.ResultProducer")) : class$weka$experiment$ResultProducer, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$experiment$SplitEvaluator == null ? (class$weka$experiment$SplitEvaluator = SetupPanel.class$("weka.experiment.SplitEvaluator")) : class$weka$experiment$SplitEvaluator, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = SetupPanel.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(array$Lweka$classifiers$Classifier == null ? (array$Lweka$classifiers$Classifier = SetupPanel.class$("[Lweka.classifiers.Classifier;")) : array$Lweka$classifiers$Classifier, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = SetupPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SetupPanel.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = SetupPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(class$weka$filters$Filter == null ? (class$weka$filters$Filter = SetupPanel.class$("weka.filters.Filter")) : class$weka$filters$Filter, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$attributeSelection$ASEvaluation == null ? (class$weka$attributeSelection$ASEvaluation = SetupPanel.class$("weka.attributeSelection.ASEvaluation")) : class$weka$attributeSelection$ASEvaluation, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$attributeSelection$ASSearch == null ? (class$weka$attributeSelection$ASSearch = SetupPanel.class$("weka.attributeSelection.ASSearch")) : class$weka$attributeSelection$ASSearch, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$attributeSelection$UnsupervisedSubsetEvaluator == null ? (class$weka$attributeSelection$UnsupervisedSubsetEvaluator = SetupPanel.class$("weka.attributeSelection.UnsupervisedSubsetEvaluator")) : class$weka$attributeSelection$UnsupervisedSubsetEvaluator, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$clusterers$Clusterer == null ? (class$weka$clusterers$Clusterer = SetupPanel.class$("weka.clusterers.Clusterer")) : class$weka$clusterers$Clusterer, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$clusterers$DensityBasedClusterer == null ? (class$weka$clusterers$DensityBasedClusterer = SetupPanel.class$("weka.clusterers.DensityBasedClusterer")) : class$weka$clusterers$DensityBasedClusterer, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = SetupPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$core$SelectedTag == null ? (class$weka$core$SelectedTag = SetupPanel.class$("weka.core.SelectedTag")) : class$weka$core$SelectedTag, class$weka$gui$SelectedTagEditor == null ? (class$weka$gui$SelectedTagEditor = SetupPanel.class$("weka.gui.SelectedTagEditor")) : class$weka$gui$SelectedTagEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$CostMatrix == null ? (class$weka$classifiers$CostMatrix = SetupPanel.class$("weka.classifiers.CostMatrix")) : class$weka$classifiers$CostMatrix, class$weka$gui$CostMatrixEditor == null ? (class$weka$gui$CostMatrixEditor = SetupPanel.class$("weka.gui.CostMatrixEditor")) : class$weka$gui$CostMatrixEditor);
    }
}

