/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import weka.LocalString;
import weka.core.Memory;
import weka.gui.LogPanel;
import weka.gui.LookAndFeel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.AssociationsPanel;
import weka.gui.explorer.AttributeSelectionPanel;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.explorer.ClustererPanel;
import weka.gui.explorer.PreprocessPanel;
import weka.gui.visualize.MatrixPanel;

public class Explorer
extends JPanel {
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected ClassifierPanel m_ClassifierPanel = new ClassifierPanel();
    protected ClustererPanel m_ClustererPanel = new ClustererPanel();
    protected AssociationsPanel m_AssociationPanel = new AssociationsPanel();
    protected AttributeSelectionPanel m_AttributeSelectionPanel = new AttributeSelectionPanel();
    protected MatrixPanel m_VisualizePanel = new MatrixPanel();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    private static Explorer m_explorer;
    private static Memory m_Memory;

    public Explorer() {
        String string = new SimpleDateFormat(LocalString.get("EEEE, d MMMM yyyy")).format(new Date());
        this.m_LogPanel.logMessage(LocalString.get("Weka Explorer"));
        this.m_LogPanel.logMessage(LocalString.get("(c) 1999-2005 The University of Waikato, Hamilton,") + LocalString.get(" New Zealand"));
        this.m_LogPanel.logMessage(LocalString.get("web: http://www.cs.waikato.ac.nz/~ml/weka"));
        this.m_LogPanel.logMessage(LocalString.get("Started on ") + string);
        this.m_LogPanel.statusMessage(LocalString.get("Welcome to the Weka Explorer"));
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_ClassifierPanel.setLog(this.m_LogPanel);
        this.m_AssociationPanel.setLog(this.m_LogPanel);
        this.m_ClustererPanel.setLog(this.m_LogPanel);
        this.m_AttributeSelectionPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab("Preprocess", null, this.m_PreprocessPanel, LocalString.get("Open/Edit/Save instances"));
        this.m_TabbedPane.addTab("Classify", null, this.m_ClassifierPanel, LocalString.get("Classify instances"));
        this.m_TabbedPane.addTab("Cluster", null, this.m_ClustererPanel, LocalString.get("Identify instance clusters"));
        this.m_TabbedPane.addTab("Associate", null, this.m_AssociationPanel, LocalString.get("Discover association rules"));
        this.m_TabbedPane.addTab(LocalString.get("Select attributes"), null, this.m_AttributeSelectionPanel, LocalString.get("Determine relevance of attributes"));
        this.m_TabbedPane.addTab("Visualize", null, this.m_VisualizePanel, LocalString.get("Explore the data"));
        this.m_TabbedPane.setSelectedIndex(0);
        this.m_TabbedPane.setEnabledAt(1, false);
        this.m_TabbedPane.setEnabledAt(2, false);
        this.m_TabbedPane.setEnabledAt(3, false);
        this.m_TabbedPane.setEnabledAt(4, false);
        this.m_TabbedPane.setEnabledAt(5, false);
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Explorer.this.m_ClassifierPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AssociationPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_ClustererPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AttributeSelectionPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_VisualizePanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_TabbedPane.setEnabledAt(1, true);
                Explorer.this.m_TabbedPane.setEnabledAt(2, true);
                Explorer.this.m_TabbedPane.setEnabledAt(3, true);
                Explorer.this.m_TabbedPane.setEnabledAt(4, true);
                Explorer.this.m_TabbedPane.setEnabledAt(5, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            m_explorer = new Explorer();
            final JFrame jFrame = new JFrame(LocalString.get("Weka Explorer"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_explorer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
            jFrame.setIconImage(image);
            if (stringArray.length == 1) {
                System.err.println(LocalString.get("Loading instances from ") + stringArray[0]);
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile(new File(stringArray[0]));
            }
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jFrame.dispose();
                                m_explorer = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println(LocalString.get("\ndisplayed message:"));
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }
}

