/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceLoader
extends JPanel
implements Serializable,
ActionListener,
InstanceProducer {
    private Vector m_Listeners;
    private Thread m_LoaderThread;
    private Instance m_OutputInstance;
    private Instances m_OutputInstances;
    private boolean m_Debug;
    private JButton m_StartBut;
    private JTextField m_FileNameTex;

    public InstanceLoader() {
        this.setLayout(new BorderLayout());
        this.m_StartBut = new JButton("Start");
        this.m_StartBut.setBackground(Color.green);
        this.add("West", this.m_StartBut);
        this.m_StartBut.addActionListener(this);
        this.m_FileNameTex = new JTextField("/home/trigg/datasets/UCI/iris.arff");
        this.add("Center", this.m_FileNameTex);
        this.m_Listeners = new Vector();
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setArffFile(String string) {
        this.m_FileNameTex.setText(string);
    }

    public String getArffFile() {
        return this.m_FileNameTex.getText();
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.m_Listeners.addElement(instanceListener);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.m_Listeners.removeElement(instanceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceProduced(InstanceEvent instanceEvent) {
        Vector vector;
        if (this.m_Debug) {
            System.err.println("InstanceLoader::notifyInstanceProduced()");
        }
        InstanceLoader instanceLoader = this;
        synchronized (instanceLoader) {
            vector = (Vector)this.m_Listeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).instanceProduced(instanceEvent);
            }
            if (instanceEvent.getID() == 2) {
                this.m_OutputInstance = null;
            }
        }
    }

    public Instances outputFormat() throws Exception {
        if (this.m_OutputInstances == null) {
            throw new Exception(LocalString.get("No output format defined."));
        }
        return new Instances(this.m_OutputInstances, 0);
    }

    public Instance outputPeek() throws Exception {
        if (this.m_OutputInstances == null || this.m_OutputInstance == null) {
            return null;
        }
        return (Instance)this.m_OutputInstance.copy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_StartBut) {
            if (this.m_LoaderThread == null) {
                this.m_LoaderThread = new LoadThread(this);
                this.m_LoaderThread.setPriority(1);
                this.m_LoaderThread.start();
            } else {
                this.m_LoaderThread = null;
            }
        }
    }

    private class LoadThread
    extends Thread {
        private InstanceProducer m_IP;

        public LoadThread(InstanceProducer instanceProducer) {
            this.m_IP = instanceProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                block10: {
                    try {
                        try {
                            InstanceLoader.this.m_StartBut.setText("Stop");
                            InstanceLoader.this.m_StartBut.setBackground(Color.red);
                            if (InstanceLoader.this.m_Debug) {
                                System.err.println("InstanceLoader::LoadThread::run()");
                            }
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(InstanceLoader.this.m_FileNameTex.getText()));
                            InstanceLoader.this.m_OutputInstances = new Instances(bufferedReader, 1);
                            if (InstanceLoader.this.m_Debug) {
                                System.err.println("InstanceLoader::LoadThread::run()" + LocalString.get(" - Instances opened from: ") + InstanceLoader.this.m_FileNameTex.getText());
                            }
                            InstanceEvent instanceEvent = new InstanceEvent(this.m_IP, 1);
                            InstanceLoader.this.notifyInstanceProduced(instanceEvent);
                            while (InstanceLoader.this.m_OutputInstances.readInstance(bufferedReader)) {
                                if (InstanceLoader.this.m_LoaderThread != this) {
                                    Object var4_4 = null;
                                    break block10;
                                }
                                if (InstanceLoader.this.m_Debug) {
                                    System.err.println("InstanceLoader::LoadThread::run()" + LocalString.get(" - read instance"));
                                }
                                InstanceLoader.this.m_OutputInstance = InstanceLoader.this.m_OutputInstances.instance(0);
                                InstanceLoader.this.m_OutputInstances.delete(0);
                                instanceEvent = new InstanceEvent(this.m_IP, 2);
                                InstanceLoader.this.notifyInstanceProduced(instanceEvent);
                            }
                            instanceEvent = new InstanceEvent(this.m_IP, 3);
                            InstanceLoader.this.notifyInstanceProduced(instanceEvent);
                            break block11;
                        }
                        catch (Exception exception) {
                            System.err.println(exception.getMessage());
                            Object var4_6 = null;
                            InstanceLoader.this.m_LoaderThread = null;
                            InstanceLoader.this.m_StartBut.setText("Start");
                            InstanceLoader.this.m_StartBut.setBackground(Color.green);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        InstanceLoader.this.m_LoaderThread = null;
                        InstanceLoader.this.m_StartBut.setText("Start");
                        InstanceLoader.this.m_StartBut.setBackground(Color.green);
                        throw throwable;
                    }
                }
                InstanceLoader.this.m_LoaderThread = null;
                InstanceLoader.this.m_StartBut.setText("Start");
                InstanceLoader.this.m_StartBut.setBackground(Color.green);
                return;
            }
            Object var4_5 = null;
            InstanceLoader.this.m_LoaderThread = null;
            InstanceLoader.this.m_StartBut.setText("Start");
            InstanceLoader.this.m_StartBut.setBackground(Color.green);
        }
    }
}

