/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.LocalString;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.Plot2DCompanion;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizeUtils;

public class Plot2D
extends JPanel {
    public static final int MAX_SHAPES = 5;
    public static final int ERROR_SHAPE = 1000;
    public static final int MISSING_SHAPE = 2000;
    public static final int CONST_AUTOMATIC_SHAPE = -1;
    public static final int X_SHAPE = 0;
    public static final int PLUS_SHAPE = 1;
    public static final int DIAMOND_SHAPE = 2;
    public static final int TRIANGLEUP_SHAPE = 3;
    public static final int TRIANGLEDOWN_SHAPE = 4;
    public static final int DEFAULT_SHAPE_SIZE = 2;
    protected Color m_axisColour = Color.green;
    protected Color m_backgroundColour = Color.black;
    protected FastVector m_plots = new FastVector();
    protected PlotData2D m_masterPlot = null;
    protected String m_masterName = LocalString.get("master plot");
    protected Instances m_plotInstances = null;
    protected Plot2DCompanion m_plotCompanion = null;
    protected JFrame m_InstanceInfo = null;
    protected JTextArea m_InstanceInfoText = new JTextArea();
    protected FastVector m_colorList;
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected int m_xIndex = 0;
    protected int m_yIndex = 0;
    protected int m_cIndex = 0;
    protected int m_sIndex = 0;
    protected double m_maxX;
    protected double m_minX;
    protected double m_maxY;
    protected double m_minY;
    protected double m_maxC;
    protected double m_minC;
    protected final int m_axisPad = 5;
    protected final int m_tickSize = 5;
    protected int m_XaxisStart = 0;
    protected int m_YaxisStart = 0;
    protected int m_XaxisEnd = 0;
    protected int m_YaxisEnd = 0;
    protected boolean m_plotResize = true;
    protected boolean m_axisChanged = false;
    protected int[][] m_drawnPoints;
    protected Font m_labelFont;
    protected FontMetrics m_labelMetrics = null;
    protected int m_JitterVal = 0;
    protected Random m_JRand = new Random(0L);
    protected double[][] m_pointLookup = null;

    public Plot2D() {
        this.setProperties();
        this.setBackground(this.m_backgroundColour);
        this.m_InstanceInfoText.setFont(new Font("Monospaced", 0, 12));
        this.m_InstanceInfoText.setEditable(false);
        this.m_drawnPoints = new int[this.getWidth()][this.getHeight()];
        this.m_colorList = new FastVector(10);
        for (int i = this.m_colorList.size(); i < 10; ++i) {
            Color color = this.m_DefaultColors[i % 10];
            int n = i / 10;
            n *= 2;
            for (int j = 0; j < n; ++j) {
                color = color.darker();
            }
            this.m_colorList.addElement(color);
        }
    }

    private void setProperties() {
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null) {
            String string = this.getClass().getName();
            String string2 = string + ".axisColour";
            String string3 = string + ".backgroundColour";
            String string4 = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string2);
            if (string4 != null) {
                this.m_axisColour = VisualizeUtils.processColour(string4, this.m_axisColour);
            }
            String string5 = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string3);
            if (string5 != null) {
                this.m_backgroundColour = VisualizeUtils.processColour(string5, this.m_backgroundColour);
            }
        }
    }

    private boolean checkPoints(double d, double d2) {
        return !(d < 0.0 || d > (double)this.getSize().width || d2 < 0.0) && !(d2 > (double)this.getSize().height);
    }

    public void setPlotCompanion(Plot2DCompanion plot2DCompanion) {
        this.m_plotCompanion = plot2DCompanion;
    }

    public void setJitter(int n) {
        if (this.m_plotInstances.numAttributes() > 0 && this.m_plotInstances.numInstances() > 0 && n >= 0) {
            this.m_JitterVal = n;
            this.m_JRand = new Random(this.m_JitterVal);
            this.m_drawnPoints = new int[this.m_XaxisEnd - this.m_XaxisStart + 1][this.m_YaxisEnd - this.m_YaxisStart + 1];
            this.updatePturb();
            this.repaint();
        }
    }

    public void setColours(FastVector fastVector) {
        this.m_colorList = fastVector;
    }

    public void setXindex(int n) {
        this.m_xIndex = n;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            ((PlotData2D)this.m_plots.elementAt(i)).setXindex(this.m_xIndex);
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setYindex(int n) {
        this.m_yIndex = n;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            ((PlotData2D)this.m_plots.elementAt(i)).setYindex(this.m_yIndex);
        }
        this.determineBounds();
        if (this.m_JitterVal != 0) {
            this.updatePturb();
        }
        this.m_axisChanged = true;
        this.repaint();
    }

    public void setCindex(int n) {
        this.m_cIndex = n;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            ((PlotData2D)this.m_plots.elementAt(i)).setCindex(this.m_cIndex);
        }
        this.determineBounds();
        this.m_axisChanged = true;
        this.repaint();
    }

    public FastVector getPlots() {
        return this.m_plots;
    }

    public PlotData2D getMasterPlot() {
        return this.m_masterPlot;
    }

    public double getMaxX() {
        return this.m_maxX;
    }

    public double getMaxY() {
        return this.m_maxY;
    }

    public double getMinX() {
        return this.m_minX;
    }

    public double getMinY() {
        return this.m_minY;
    }

    public double getMaxC() {
        return this.m_maxC;
    }

    public double getMinC() {
        return this.m_minC;
    }

    public void setInstances(Instances instances) throws Exception {
        PlotData2D plotData2D = new PlotData2D(instances);
        plotData2D.setPlotName(LocalString.get("master plot"));
        this.setMasterPlot(plotData2D);
    }

    public void setMasterPlot(PlotData2D plotData2D) throws Exception {
        if (plotData2D.m_plotInstances == null) {
            throw new Exception(LocalString.get("No instances in plot data!"));
        }
        this.removeAllPlots();
        this.m_masterPlot = plotData2D;
        this.m_plots.addElement(this.m_masterPlot);
        this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
        this.determineBounds();
    }

    public void removeAllPlots() {
        this.m_masterPlot = null;
        this.m_plotInstances = null;
        this.m_plots = new FastVector();
        this.m_xIndex = 0;
        this.m_yIndex = 0;
        this.m_cIndex = 0;
    }

    public void addPlot(PlotData2D plotData2D) throws Exception {
        if (plotData2D.m_plotInstances == null) {
            throw new Exception(LocalString.get("No instances in plot data!"));
        }
        if (this.m_masterPlot != null) {
            if (!this.m_masterPlot.m_plotInstances.equalHeaders(plotData2D.m_plotInstances)) {
                throw new Exception(LocalString.get("Plot2D :Plot data's instances are incompatable ") + LocalString.get(" with master plot"));
            }
        } else {
            this.m_masterPlot = plotData2D;
            this.m_plotInstances = this.m_masterPlot.m_plotInstances;
        }
        this.m_plots.addElement(plotData2D);
        this.setXindex(this.m_xIndex);
        this.setYindex(this.m_yIndex);
        this.setCindex(this.m_cIndex);
    }

    private void setFonts(Graphics graphics) {
        if (this.m_labelMetrics == null) {
            this.m_labelFont = new Font("Monospaced", 0, 12);
            this.m_labelMetrics = graphics.getFontMetrics(this.m_labelFont);
        }
        graphics.setFont(this.m_labelFont);
    }

    public void searchPoints(int n, int n2, final boolean bl) {
        if (this.m_masterPlot.m_plotInstances != null) {
            Object object;
            int n3 = 0;
            for (int i = 0; i < this.m_masterPlot.m_plotInstances.numAttributes(); ++i) {
                if (this.m_masterPlot.m_plotInstances.attribute(i).name().length() <= n3) continue;
                n3 = this.m_masterPlot.m_plotInstances.attribute(i).name().length();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_plots.size(); ++i) {
                object = (PlotData2D)this.m_plots.elementAt(i);
                for (int j = 0; j < ((PlotData2D)object).m_plotInstances.numInstances(); ++j) {
                    if (((PlotData2D)object).m_pointLookup[j][0] == Double.NEGATIVE_INFINITY) continue;
                    double d = ((PlotData2D)object).m_pointLookup[j][0] + ((PlotData2D)object).m_pointLookup[j][2];
                    double d2 = ((PlotData2D)object).m_pointLookup[j][1] + ((PlotData2D)object).m_pointLookup[j][3];
                    double d3 = ((PlotData2D)object).m_shapeSize[j];
                    if (!((double)n >= d - d3) || !((double)n <= d + d3) || !((double)n2 >= d2 - d3) || !((double)n2 <= d2 + d3)) continue;
                    stringBuffer.append(LocalString.get("\nPlot : ") + ((PlotData2D)object).m_plotName + LocalString.get("\nInstance: ") + j + "\n");
                    for (int k = 0; k < ((PlotData2D)object).m_plotInstances.numAttributes(); ++k) {
                        for (int i2 = 0; i2 < n3 - ((PlotData2D)object).m_plotInstances.attribute(k).name().length(); ++i2) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(((PlotData2D)object).m_plotInstances.attribute(k).name());
                        stringBuffer.append(" : ");
                        if (((PlotData2D)object).m_plotInstances.instance(j).isMissing(k)) {
                            stringBuffer.append("Missing");
                        } else if (((PlotData2D)object).m_plotInstances.attribute(k).isNominal()) {
                            stringBuffer.append(((PlotData2D)object).m_plotInstances.attribute(k).value((int)((PlotData2D)object).m_plotInstances.instance(j).value(k)));
                        } else {
                            stringBuffer.append(((PlotData2D)object).m_plotInstances.instance(j).value(k));
                        }
                        stringBuffer.append("\n");
                    }
                }
            }
            if (stringBuffer.length() > 0) {
                if (bl || this.m_InstanceInfo == null) {
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setFont(new Font("Monospaced", 0, 12));
                    jTextArea.setEditable(false);
                    jTextArea.setText(stringBuffer.toString());
                    object = new JFrame(LocalString.get("Weka : Instance info"));
                    final JFrame jFrame = this.m_InstanceInfo;
                    ((Window)object).addWindowListener(new WindowAdapter((JFrame)object){
                        private final /* synthetic */ JFrame val$jf;
                        {
                            this.val$jf = jFrame2;
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            if (!bl || jFrame == null) {
                                Plot2D.this.m_InstanceInfo = null;
                            }
                            this.val$jf.dispose();
                        }
                    });
                    ((JFrame)object).getContentPane().setLayout(new BorderLayout());
                    ((JFrame)object).getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                    ((Window)object).pack();
                    ((Window)object).setSize(320, 400);
                    ((Window)object).setVisible(true);
                    if (this.m_InstanceInfo == null) {
                        this.m_InstanceInfo = object;
                        this.m_InstanceInfoText = jTextArea;
                    }
                } else {
                    this.m_InstanceInfoText.setText(stringBuffer.toString());
                }
            }
        }
    }

    public void determineBounds() {
        this.m_minX = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minX;
        this.m_maxX = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxX;
        this.m_minY = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minY;
        this.m_maxY = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxY;
        this.m_minC = ((PlotData2D)this.m_plots.elementAt((int)0)).m_minC;
        this.m_maxC = ((PlotData2D)this.m_plots.elementAt((int)0)).m_maxC;
        for (int i = 1; i < this.m_plots.size(); ++i) {
            double d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minX;
            if (d < this.m_minX) {
                this.m_minX = d;
            }
            if ((d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxX) > this.m_maxX) {
                this.m_maxX = d;
            }
            if ((d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minY) < this.m_minY) {
                this.m_minY = d;
            }
            if ((d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxY) > this.m_maxY) {
                this.m_maxY = d;
            }
            if ((d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_minC) < this.m_minC) {
                this.m_minC = d;
            }
            if (!((d = ((PlotData2D)this.m_plots.elementAt((int)i)).m_maxC) > this.m_maxC)) continue;
            this.m_maxC = d;
        }
        this.fillLookup();
        this.repaint();
    }

    public double convertToAttribX(double d) {
        double d2 = this.m_XaxisEnd - this.m_XaxisStart;
        double d3 = (d - (double)this.m_XaxisStart) * (this.m_maxX - this.m_minX) / d2;
        return d3 += this.m_minX;
    }

    public double convertToAttribY(double d) {
        double d2 = this.m_YaxisEnd - this.m_YaxisStart;
        double d3 = (d - (double)this.m_YaxisEnd) * (this.m_maxY - this.m_minY) / d2;
        d3 = -(d3 - this.m_minY);
        return d3;
    }

    int pturbX(double d, double d2) {
        int n = 0;
        if (this.m_JitterVal > 0 && (d + (double)(n = (int)((double)this.m_JitterVal * (d2 / 2.0))) < (double)this.m_XaxisStart || d + (double)n > (double)this.m_XaxisEnd)) {
            n *= -1;
        }
        return n;
    }

    public double convertToPanelX(double d) {
        double d2 = (d - this.m_minX) / (this.m_maxX - this.m_minX);
        double d3 = d2 * (double)(this.m_XaxisEnd - this.m_XaxisStart);
        return d3 += (double)this.m_XaxisStart;
    }

    int pturbY(double d, double d2) {
        int n = 0;
        if (this.m_JitterVal > 0 && (d + (double)(n = (int)((double)this.m_JitterVal * (d2 / 2.0))) < (double)this.m_YaxisStart || d + (double)n > (double)this.m_YaxisEnd)) {
            n *= -1;
        }
        return n;
    }

    public double convertToPanelY(double d) {
        double d2 = (d - this.m_minY) / (this.m_maxY - this.m_minY);
        double d3 = d2 * (double)(this.m_YaxisEnd - this.m_YaxisStart);
        d3 = (double)this.m_YaxisEnd - d3;
        return d3;
    }

    private static void drawX(Graphics graphics, double d, double d2, int n) {
        graphics.drawLine((int)(d - (double)n), (int)(d2 - (double)n), (int)(d + (double)n), (int)(d2 + (double)n));
        graphics.drawLine((int)(d + (double)n), (int)(d2 - (double)n), (int)(d - (double)n), (int)(d2 + (double)n));
    }

    private static void drawPlus(Graphics graphics, double d, double d2, int n) {
        graphics.drawLine((int)(d - (double)n), (int)d2, (int)(d + (double)n), (int)d2);
        graphics.drawLine((int)d, (int)(d2 - (double)n), (int)d, (int)(d2 + (double)n));
    }

    private static void drawDiamond(Graphics graphics, double d, double d2, int n) {
        graphics.drawLine((int)(d - (double)n), (int)d2, (int)d, (int)(d2 - (double)n));
        graphics.drawLine((int)d, (int)(d2 - (double)n), (int)(d + (double)n), (int)d2);
        graphics.drawLine((int)(d + (double)n), (int)d2, (int)d, (int)(d2 + (double)n));
        graphics.drawLine((int)d, (int)(d2 + (double)n), (int)(d - (double)n), (int)d2);
    }

    private static void drawTriangleUp(Graphics graphics, double d, double d2, int n) {
        graphics.drawLine((int)d, (int)(d2 - (double)n), (int)(d - (double)n), (int)(d2 + (double)n));
        graphics.drawLine((int)(d - (double)n), (int)(d2 + (double)n), (int)(d + (double)n), (int)(d2 + (double)n));
        graphics.drawLine((int)(d + (double)n), (int)(d2 + (double)n), (int)d, (int)(d2 - (double)n));
    }

    private static void drawTriangleDown(Graphics graphics, double d, double d2, int n) {
        graphics.drawLine((int)d, (int)(d2 + (double)n), (int)(d - (double)n), (int)(d2 - (double)n));
        graphics.drawLine((int)(d - (double)n), (int)(d2 - (double)n), (int)(d + (double)n), (int)(d2 - (double)n));
        graphics.drawLine((int)(d + (double)n), (int)(d2 - (double)n), (int)d, (int)(d2 + (double)n));
    }

    protected static void drawDataPoint(double d, double d2, double d3, double d4, int n, int n2, Graphics graphics) {
        Plot2D.drawDataPoint(d, d2, n, n2, graphics);
        graphics.drawLine((int)d, (int)d2, (int)d3, (int)d4);
    }

    protected static void drawDataPoint(double d, double d2, int n, int n2, Graphics graphics) {
        Font font = new Font("Monospaced", 0, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (n == 0) {
            n = 1;
        }
        if (n2 != 1000 && n2 != 2000) {
            n2 %= 5;
        }
        switch (n2) {
            case 0: {
                Plot2D.drawX(graphics, d, d2, n);
                break;
            }
            case 1: {
                Plot2D.drawPlus(graphics, d, d2, n);
                break;
            }
            case 2: {
                Plot2D.drawDiamond(graphics, d, d2, n);
                break;
            }
            case 3: {
                Plot2D.drawTriangleUp(graphics, d, d2, n);
                break;
            }
            case 4: {
                Plot2D.drawTriangleDown(graphics, d, d2, n);
                break;
            }
            case 1000: {
                graphics.drawRect((int)(d - (double)n), (int)(d2 - (double)n), n * 2, n * 2);
                break;
            }
            case 2000: {
                int n3 = fontMetrics.getAscent();
                int n4 = fontMetrics.stringWidth("M");
                graphics.drawString("M", (int)(d - (double)(n4 / 2)), (int)(d2 + (double)(n3 / 2)));
            }
        }
    }

    private void updatePturb() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_plots.size(); ++i) {
            PlotData2D plotData2D = (PlotData2D)this.m_plots.elementAt(i);
            for (int j = 0; j < plotData2D.m_plotInstances.numInstances(); ++j) {
                if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_xIndex) || plotData2D.m_plotInstances.instance(j).isMissing(this.m_yIndex)) continue;
                if (this.m_JitterVal > 0) {
                    d = this.m_JRand.nextGaussian();
                    d2 = this.m_JRand.nextGaussian();
                }
                plotData2D.m_pointLookup[j][2] = this.pturbX(plotData2D.m_pointLookup[j][0], d);
                plotData2D.m_pointLookup[j][3] = this.pturbY(plotData2D.m_pointLookup[j][1], d2);
            }
        }
    }

    private void fillLookup() {
        for (int i = 0; i < this.m_plots.size(); ++i) {
            PlotData2D plotData2D = (PlotData2D)this.m_plots.elementAt(i);
            if (plotData2D.m_plotInstances.numInstances() <= 0 || plotData2D.m_plotInstances.numAttributes() <= 0) continue;
            for (int j = 0; j < plotData2D.m_plotInstances.numInstances(); ++j) {
                if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_xIndex) || plotData2D.m_plotInstances.instance(j).isMissing(this.m_yIndex)) {
                    plotData2D.m_pointLookup[j][0] = Double.NEGATIVE_INFINITY;
                    plotData2D.m_pointLookup[j][1] = Double.NEGATIVE_INFINITY;
                    continue;
                }
                double d = this.convertToPanelX(plotData2D.m_plotInstances.instance(j).value(this.m_xIndex));
                double d2 = this.convertToPanelY(plotData2D.m_plotInstances.instance(j).value(this.m_yIndex));
                plotData2D.m_pointLookup[j][0] = d;
                plotData2D.m_pointLookup[j][1] = d2;
            }
        }
    }

    private void paintData(Graphics graphics) {
        for (int i = 0; i < this.m_plots.size(); ++i) {
            PlotData2D plotData2D = (PlotData2D)this.m_plots.elementAt(i);
            for (int j = 0; j < plotData2D.m_plotInstances.numInstances(); ++j) {
                if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_xIndex) || plotData2D.m_plotInstances.instance(j).isMissing(this.m_yIndex)) continue;
                double d = plotData2D.m_pointLookup[j][0] + plotData2D.m_pointLookup[j][2];
                double d2 = plotData2D.m_pointLookup[j][1] + plotData2D.m_pointLookup[j][3];
                double d3 = 0.0;
                double d4 = 0.0;
                if (j > 0) {
                    d3 = plotData2D.m_pointLookup[j - 1][0] + plotData2D.m_pointLookup[j - 1][2];
                    d4 = plotData2D.m_pointLookup[j - 1][1] + plotData2D.m_pointLookup[j - 1][3];
                }
                int n = (int)d - this.m_XaxisStart;
                int n2 = (int)d2 - this.m_YaxisStart;
                if (n < 0 || n2 < 0 || this.m_drawnPoints[n][n2] != j && this.m_drawnPoints[n][n2] != 0 && !plotData2D.m_displayAllPoints) continue;
                this.m_drawnPoints[n][n2] = j;
                if (plotData2D.m_plotInstances.attribute(this.m_cIndex).isNominal()) {
                    Color color;
                    if (plotData2D.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size() && !plotData2D.m_useCustomColour) {
                        this.extendColourMap(plotData2D.m_plotInstances.attribute(this.m_cIndex).numValues());
                    }
                    if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_cIndex)) {
                        color = Color.gray;
                    } else {
                        int n3 = (int)plotData2D.m_plotInstances.instance(j).value(this.m_cIndex);
                        color = (Color)this.m_colorList.elementAt(n3);
                    }
                    if (!plotData2D.m_useCustomColour) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(plotData2D.m_customColour);
                    }
                    if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_cIndex)) {
                        if (plotData2D.m_connectPoints[j]) {
                            Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], 2000, graphics);
                            continue;
                        }
                        Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], 2000, graphics);
                        continue;
                    }
                    if (plotData2D.m_shapeType[j] == -1) {
                        if (plotData2D.m_connectPoints[j]) {
                            Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], i, graphics);
                            continue;
                        }
                        Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], i, graphics);
                        continue;
                    }
                    if (plotData2D.m_connectPoints[j]) {
                        Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], plotData2D.m_shapeType[j], graphics);
                        continue;
                    }
                    Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], plotData2D.m_shapeType[j], graphics);
                    continue;
                }
                Color color = null;
                if (!plotData2D.m_plotInstances.instance(j).isMissing(this.m_cIndex)) {
                    double d5 = (plotData2D.m_plotInstances.instance(j).value(this.m_cIndex) - this.m_minC) / (this.m_maxC - this.m_minC);
                    d5 = d5 * 240.0 + 15.0;
                    color = new Color((int)d5, 150, (int)(255.0 - d5));
                } else {
                    color = Color.gray;
                }
                if (!plotData2D.m_useCustomColour) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(plotData2D.m_customColour);
                }
                if (plotData2D.m_plotInstances.instance(j).isMissing(this.m_cIndex)) {
                    if (plotData2D.m_connectPoints[j]) {
                        Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], 2000, graphics);
                        continue;
                    }
                    Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], 2000, graphics);
                    continue;
                }
                if (plotData2D.m_shapeType[j] == -1) {
                    if (plotData2D.m_connectPoints[j]) {
                        Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], i, graphics);
                        continue;
                    }
                    Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], i, graphics);
                    continue;
                }
                if (plotData2D.m_connectPoints[j]) {
                    Plot2D.drawDataPoint(d, d2, d3, d4, plotData2D.m_shapeSize[j], plotData2D.m_shapeType[j], graphics);
                    continue;
                }
                Plot2D.drawDataPoint(d, d2, plotData2D.m_shapeSize[j], plotData2D.m_shapeType[j], graphics);
            }
        }
    }

    private void paintAxis(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        block31: {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            block30: {
                double d;
                String string;
                double d2;
                String string2;
                String string3;
                int n10;
                int n11;
                double d3;
                int n12;
                int n13;
                int n14;
                int n15;
                block29: {
                    block28: {
                        this.setFonts(graphics);
                        n4 = this.m_XaxisStart;
                        n3 = this.m_XaxisEnd;
                        n2 = this.m_YaxisStart;
                        n = this.m_YaxisEnd;
                        this.m_plotResize = false;
                        n15 = this.getHeight();
                        n14 = this.getWidth();
                        n9 = this.m_labelMetrics.getAscent();
                        int n16 = 0;
                        n13 = 0;
                        int n17 = 1;
                        int n18 = 1;
                        int n19 = 1;
                        n12 = (int)Math.abs(this.m_maxX);
                        d3 = Math.abs(this.m_maxX) - (double)n12;
                        n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                        int n20 = n17 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxX)) / Math.log(10.0)) + 2 : 1;
                        if (n17 > VisualizeUtils.MAX_PRECISION) {
                            n17 = 1;
                        }
                        String string4 = Utils.doubleToString(this.m_maxX, n11 + 1 + n17, n17);
                        n12 = (int)Math.abs(this.m_minX);
                        d3 = Math.abs(this.m_minX) - (double)n12;
                        n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                        int n21 = n18 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minX)) / Math.log(10.0)) + 2 : 1;
                        if (n18 > VisualizeUtils.MAX_PRECISION) {
                            n18 = 1;
                        }
                        String string5 = Utils.doubleToString(this.m_minX, n11 + 1 + n18, n18);
                        n16 = this.m_labelMetrics.stringWidth(string4);
                        int n22 = 1;
                        int n23 = 1;
                        n10 = 1;
                        n12 = (int)Math.abs(this.m_maxY);
                        d3 = Math.abs(this.m_maxY) - (double)n12;
                        n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                        int n24 = n22 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxY)) / Math.log(10.0)) + 2 : 1;
                        if (n22 > VisualizeUtils.MAX_PRECISION) {
                            n22 = 1;
                        }
                        string3 = Utils.doubleToString(this.m_maxY, n11 + 1 + n22, n22);
                        n12 = (int)Math.abs(this.m_minY);
                        d3 = Math.abs(this.m_minY) - (double)n12;
                        n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                        int n25 = n23 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minY)) / Math.log(10.0)) + 2 : 1;
                        if (n23 > VisualizeUtils.MAX_PRECISION) {
                            n23 = 1;
                        }
                        string2 = Utils.doubleToString(this.m_minY, n11 + 1 + n23, n23);
                        if (this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) {
                            n13 = this.m_labelMetrics.stringWidth(string3) > this.m_labelMetrics.stringWidth(string2) ? this.m_labelMetrics.stringWidth(string3) : this.m_labelMetrics.stringWidth(string2);
                            n13 += this.m_labelMetrics.stringWidth("M");
                        } else {
                            n13 = this.m_labelMetrics.stringWidth("MM");
                        }
                        this.m_YaxisStart = 5;
                        this.m_XaxisStart = 10 + n13;
                        this.m_XaxisEnd = n14 - 5 - n16 / 2;
                        this.m_YaxisEnd = n15 - 5 - 2 * n9 - 5;
                        graphics.setColor(this.m_axisColour);
                        if (!this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block28;
                        if (n14 <= 2 * n16) break block29;
                        graphics.drawString(string4, this.m_XaxisEnd - n16 / 2, this.m_YaxisEnd + n9 + 5);
                        n16 = this.m_labelMetrics.stringWidth(string5);
                        graphics.drawString(string5, this.m_XaxisStart - n16 / 2, this.m_YaxisEnd + n9 + 5);
                        if (n14 <= 3 * n16 || !this.m_plotInstances.attribute(this.m_xIndex).isNumeric()) break block29;
                        d2 = this.m_minX + (this.m_maxX - this.m_minX) / 2.0;
                        n12 = (int)Math.abs(d2);
                        d3 = Math.abs(d2) - (double)n12;
                        n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                        int n26 = n19 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(d2)) / Math.log(10.0)) + 2 : 1;
                        if (n19 > VisualizeUtils.MAX_PRECISION) {
                            n19 = 1;
                        }
                        string = Utils.doubleToString(d2, n11 + 1 + n19, n19);
                        n8 = this.m_labelMetrics.stringWidth(string);
                        d = (double)this.m_XaxisStart + (double)(this.m_XaxisEnd - this.m_XaxisStart) / 2.0;
                        graphics.drawString(string, (int)(d - (double)n8 / 2.0), this.m_YaxisEnd + n9 + 5);
                        graphics.drawLine((int)d, this.m_YaxisEnd, (int)d, this.m_YaxisEnd + 5);
                        break block29;
                    }
                    int n27 = this.m_plotInstances.attribute(this.m_xIndex).numValues();
                    n7 = n27 % 2 > 0 ? n27 / 2 + 1 : n27 / 2;
                    int n28 = (this.m_XaxisEnd - this.m_XaxisStart) / n27;
                    for (n8 = 0; n8 < n27; ++n8) {
                        String string6 = this.m_plotInstances.attribute(this.m_xIndex).value(n8);
                        int n29 = this.m_labelMetrics.stringWidth(string6);
                        if (n29 > n28) {
                            n6 = n29 / string6.length();
                            n5 = (n29 - n28) / n6;
                            if (n5 == 0) {
                                n5 = 1;
                            }
                            string6 = string6.substring(0, string6.length() - n5);
                            n29 = this.m_labelMetrics.stringWidth(string6);
                        }
                        if (n8 == 0) {
                            graphics.drawString(string6, (int)this.convertToPanelX(n8), this.m_YaxisEnd + n9 + 5);
                        } else if (n8 == n27 - 1) {
                            if (n8 % 2 == 0) {
                                graphics.drawString(string6, this.m_XaxisEnd - n29, this.m_YaxisEnd + n9 + 5);
                            } else {
                                graphics.drawString(string6, this.m_XaxisEnd - n29, this.m_YaxisEnd + 2 * n9 + 5);
                            }
                        } else if (n8 % 2 == 0) {
                            graphics.drawString(string6, (int)this.convertToPanelX(n8) - n29 / 2, this.m_YaxisEnd + n9 + 5);
                        } else {
                            graphics.drawString(string6, (int)this.convertToPanelX(n8) - n29 / 2, this.m_YaxisEnd + 2 * n9 + 5);
                        }
                        graphics.drawLine((int)this.convertToPanelX(n8), this.m_YaxisEnd, (int)this.convertToPanelX(n8), this.m_YaxisEnd + 5);
                    }
                }
                if (!this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block30;
                if (n15 <= 2 * n9) break block31;
                graphics.drawString(string3, this.m_XaxisStart - n13 - 5, this.m_YaxisStart + n9);
                graphics.drawString(string2, this.m_XaxisStart - n13 - 5, this.m_YaxisEnd);
                if (n14 <= 3 * n9 || !this.m_plotInstances.attribute(this.m_yIndex).isNumeric()) break block31;
                d2 = this.m_minY + (this.m_maxY - this.m_minY) / 2.0;
                n12 = (int)Math.abs(d2);
                d3 = Math.abs(d2) - (double)n12;
                n11 = n12 > 0 ? (int)(Math.log(n12) / Math.log(10.0)) : 1;
                int n30 = n10 = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(d2)) / Math.log(10.0)) + 2 : 1;
                if (n10 > VisualizeUtils.MAX_PRECISION) {
                    n10 = 1;
                }
                string = Utils.doubleToString(d2, n11 + 1 + n10, n10);
                n8 = this.m_labelMetrics.stringWidth(string);
                d = (double)this.m_YaxisStart + (double)(this.m_YaxisEnd - this.m_YaxisStart) / 2.0;
                graphics.drawString(string, this.m_XaxisStart - n8 - 5 - 1, (int)(d + (double)n9 / 2.0));
                graphics.drawLine(this.m_XaxisStart - 5, (int)d, this.m_XaxisStart, (int)d);
                break block31;
            }
            int n31 = this.m_plotInstances.attribute(this.m_yIndex).numValues();
            n7 = n31 % 2 == 0 ? n31 / 2 : n31 / 2 + 1;
            int n32 = (this.m_YaxisEnd - this.m_XaxisStart) / n7;
            n8 = this.m_labelMetrics.stringWidth("M");
            for (int i = 0; i < n31; ++i) {
                if (n32 >= 2 * n9) {
                    String string = this.m_plotInstances.attribute(this.m_yIndex).value(i);
                    n5 = n32 / n9 > string.length() ? string.length() : n32 / n9;
                    for (n6 = 0; n6 < n5; ++n6) {
                        String string7 = string.substring(n6, n6 + 1);
                        if (string.charAt(n6) == '_' || string.charAt(n6) == '-') {
                            string7 = "|";
                        }
                        if (i == 0) {
                            graphics.drawString(string7, this.m_XaxisStart - n8 - 5 - 1, (int)this.convertToPanelY(i) - (n5 - 1) * n9 + n6 * n9 + n9 / 2);
                            continue;
                        }
                        if (i == n31 - 1) {
                            if (i % 2 == 0) {
                                graphics.drawString(string7, this.m_XaxisStart - n8 - 5 - 1, (int)this.convertToPanelY(i) + n6 * n9 + n9 / 2);
                                continue;
                            }
                            graphics.drawString(string7, this.m_XaxisStart - 2 * n8 - 5 - 1, (int)this.convertToPanelY(i) + n6 * n9 + n9 / 2);
                            continue;
                        }
                        if (i % 2 == 0) {
                            graphics.drawString(string7, this.m_XaxisStart - n8 - 5 - 1, (int)this.convertToPanelY(i) - (n5 - 1) * n9 / 2 + n6 * n9 + n9 / 2);
                            continue;
                        }
                        graphics.drawString(string7, this.m_XaxisStart - 2 * n8 - 5 - 1, (int)this.convertToPanelY(i) - (n5 - 1) * n9 / 2 + n6 * n9 + n9 / 2);
                    }
                }
                graphics.drawLine(this.m_XaxisStart - 5, (int)this.convertToPanelY(i), this.m_XaxisStart, (int)this.convertToPanelY(i));
            }
        }
        graphics.drawLine(this.m_XaxisStart, this.m_YaxisStart, this.m_XaxisStart, this.m_YaxisEnd);
        graphics.drawLine(this.m_XaxisStart, this.m_YaxisEnd, this.m_XaxisEnd, this.m_YaxisEnd);
        if (this.m_XaxisStart != n4 || this.m_XaxisEnd != n3 || this.m_YaxisStart != n2 || this.m_YaxisEnd != n) {
            this.m_plotResize = true;
        }
    }

    private void extendColourMap(int n) {
        for (int i = this.m_colorList.size(); i < n; ++i) {
            Color color = this.m_DefaultColors[i % 10];
            int n2 = i / 10;
            n2 *= 2;
            for (int j = 0; j < n2; ++j) {
                color = color.brighter();
            }
            this.m_colorList.addElement(color);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_plotInstances != null && this.m_plotInstances.numInstances() > 0 && this.m_plotInstances.numAttributes() > 0) {
            if (this.m_plotCompanion != null) {
                this.m_plotCompanion.prePlot(graphics);
            }
            this.m_JRand = new Random(this.m_JitterVal);
            this.paintAxis(graphics);
            if (this.m_axisChanged || this.m_plotResize) {
                int n = this.m_XaxisEnd - this.m_XaxisStart;
                int n2 = this.m_YaxisEnd - this.m_YaxisStart;
                if (n < 10) {
                    n = 10;
                }
                if (n2 < 10) {
                    n2 = 10;
                }
                this.m_drawnPoints = new int[n + 1][n2 + 1];
                this.fillLookup();
                this.m_plotResize = false;
                this.m_axisChanged = false;
            }
            this.paintData(graphics);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println(LocalString.get("Usage : weka.gui.visualize.Plot2D ") + LocalString.get("<dataset> [<dataset> <dataset>...]"));
                System.exit(1);
            }
            final JFrame jFrame = new JFrame(LocalString.get("Weka Explorer: Visualize"));
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            final Plot2D plot2D = new Plot2D();
            jFrame.getContentPane().add((Component)plot2D, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            plot2D.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 0x10) == 16) {
                        plot2D.searchPoints(mouseEvent.getX(), mouseEvent.getY(), false);
                    } else {
                        plot2D.searchPoints(mouseEvent.getX(), mouseEvent.getY(), true);
                    }
                }
            });
            jFrame.setVisible(true);
            if (stringArray.length >= 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.err.println(LocalString.get("Loading instances from ") + stringArray[i]);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[i]));
                    Instances instances = new Instances(bufferedReader);
                    instances.setClassIndex(instances.numAttributes() - 1);
                    PlotData2D plotData2D = new PlotData2D(instances);
                    if (i == 0) {
                        plotData2D.setPlotName(LocalString.get("Master plot"));
                        plot2D.setMasterPlot(plotData2D);
                        plot2D.setXindex(2);
                        plot2D.setYindex(3);
                        plot2D.setCindex(instances.classIndex());
                        continue;
                    }
                    plotData2D.setPlotName(LocalString.get("Plot ") + (i + 1));
                    plotData2D.m_useCustomColour = true;
                    plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                    plot2D.addPlot(plotData2D);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

