/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import weka.LocalString;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PostscriptGraphics;

public class PostscriptWriter
extends JComponentWriter {
    public PostscriptWriter() {
        super(null);
    }

    public PostscriptWriter(JComponent jComponent) {
        super(jComponent);
    }

    public PostscriptWriter(JComponent jComponent, File file) {
        super(jComponent, file);
    }

    public String getDescription() {
        return LocalString.get("Postscript-File (EPS)");
    }

    public String getExtension() {
        return ".eps";
    }

    public static void toOutput(JComponent jComponent, File file) throws Exception {
        PostscriptWriter postscriptWriter = new PostscriptWriter(jComponent, file);
        ((JComponentWriter)postscriptWriter).toOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toOutput() throws Exception {
        super.toOutput();
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
        PostscriptGraphics postscriptGraphics = new PostscriptGraphics(this.getComponent().getHeight(), this.getComponent().getWidth(), bufferedOutputStream);
        postscriptGraphics.setFont(this.getComponent().getFont());
        postscriptGraphics.scale(this.getXScale(), this.getYScale());
        this.getComponent().printAll(postscriptGraphics);
        postscriptGraphics.finished();
        Object var5_3 = null;
        if (bufferedOutputStream == null) return;
        try {
            bufferedOutputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                System.err.println(exception);
                Object var5_4 = null;
                if (bufferedOutputStream == null) return;
                try {
                    bufferedOutputStream.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                bufferedOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(LocalString.get("building TreeVisualizer..."));
        TreeBuild treeBuild = new TreeBuild();
        PlaceNode2 placeNode2 = new PlaceNode2();
        Node node = treeBuild.create(new StringReader(LocalString.get("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }")));
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, node, (NodePlace)placeNode2);
        treeVisualizer.setSize(800, 600);
        String string = System.getProperty("java.io.tmpdir") + "test.eps";
        System.out.println(LocalString.get("outputting to '") + string + "'...");
        PostscriptWriter.toOutput(treeVisualizer, new File(string));
        System.out.println("done!");
    }
}

