/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import weka.LocalString;
import weka.core.RTSI;
import weka.gui.ExtensionFileFilter;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PrintableHandler;
import weka.gui.visualize.VisualizeUtils;

public class PrintableComponent
implements PrintableHandler {
    protected JComponent m_Component;
    protected static JFileChooser m_FileChooserPanel = null;
    protected String m_SaveDialogTitle = LocalString.get("Save as...");
    protected double m_xScale = 1.0;
    protected double m_yScale = 1.0;
    private static final boolean DEBUG = false;
    protected static boolean m_ToolTipUserAsked = false;
    protected static final String PROPERTY_SHOW = "PrintableComponentToolTipShow";
    protected static final String PROPERTY_USERASKED = "PrintableComponentToolTipUserAsked";
    protected static boolean m_ShowToolTip = true;
    static /* synthetic */ Class class$weka$gui$visualize$JComponentWriter;

    public PrintableComponent(JComponent jComponent) {
        this.m_Component = jComponent;
        this.getComponent().addMouseListener(new PrintMouseListener(this));
        this.getComponent().setToolTipText(PrintableComponent.getToolTipText(this));
        this.initFileChooser();
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    public static String getToolTipText(PrintableComponent printableComponent) {
        return null;
    }

    protected void initFileChooser() {
        if (m_FileChooserPanel != null) {
            return;
        }
        m_FileChooserPanel = new JFileChooser();
        m_FileChooserPanel.resetChoosableFileFilters();
        m_FileChooserPanel.setAcceptAllFileFilterUsed(false);
        Vector vector = RTSI.find((class$weka$gui$visualize$JComponentWriter == null ? (class$weka$gui$visualize$JComponentWriter = PrintableComponent.class$("weka.gui.visualize.JComponentWriter")) : class$weka$gui$visualize$JComponentWriter).getPackage().getName(), (class$weka$gui$visualize$JComponentWriter == null ? (class$weka$gui$visualize$JComponentWriter = PrintableComponent.class$("weka.gui.visualize.JComponentWriter")) : class$weka$gui$visualize$JComponentWriter).getName());
        Collections.sort(vector);
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Class<?> clazz = Class.forName(vector.get(i).toString());
                JComponentWriter jComponentWriter = (JComponentWriter)clazz.newInstance();
                m_FileChooserPanel.addChoosableFileFilter(new JComponentWriterFileFilter(jComponentWriter.getExtension(), jComponentWriter.getDescription(), jComponentWriter));
                continue;
            }
            catch (Exception exception) {
                System.err.println(vector.get(i) + ": " + exception);
            }
        }
        if (m_FileChooserPanel.getChoosableFileFilters().length > 0) {
            m_FileChooserPanel.setFileFilter(m_FileChooserPanel.getChoosableFileFilters()[0]);
        }
    }

    public Hashtable getWriters() {
        Hashtable<String, JComponentWriter> hashtable = new Hashtable<String, JComponentWriter>();
        for (int i = 0; i < m_FileChooserPanel.getChoosableFileFilters().length; ++i) {
            JComponentWriter jComponentWriter = ((JComponentWriterFileFilter)m_FileChooserPanel.getChoosableFileFilters()[i]).getWriter();
            hashtable.put(jComponentWriter.getDescription(), jComponentWriter);
        }
        return hashtable;
    }

    public JComponentWriter getWriter(String string) {
        return (JComponentWriter)this.getWriters().get(string);
    }

    public void setSaveDialogTitle(String string) {
        this.m_SaveDialogTitle = string;
    }

    public String getSaveDialogTitle() {
        return this.m_SaveDialogTitle;
    }

    public void setScale(double d, double d2) {
        this.m_xScale = d;
        this.m_yScale = d2;
    }

    public double getXScale() {
        return this.m_xScale;
    }

    public double getYScale() {
        return this.m_xScale;
    }

    public void saveComponent() {
        m_FileChooserPanel.setDialogTitle(this.getSaveDialogTitle());
        do {
            int n;
            if ((n = m_FileChooserPanel.showSaveDialog(this.getComponent())) == 0) continue;
            return;
        } while (m_FileChooserPanel.getSelectedFile() == null);
        try {
            JComponentWriterFileFilter jComponentWriterFileFilter = (JComponentWriterFileFilter)m_FileChooserPanel.getFileFilter();
            File file = m_FileChooserPanel.getSelectedFile();
            JComponentWriter jComponentWriter = jComponentWriterFileFilter.getWriter();
            if (!file.getAbsolutePath().toLowerCase().endsWith(jComponentWriter.getExtension().toLowerCase())) {
                file = new File(file.getAbsolutePath() + jComponentWriter.getExtension());
            }
            jComponentWriter.setComponent(this.getComponent());
            jComponentWriter.setFile(file);
            jComponentWriter.setScale(this.getXScale(), this.getYScale());
            jComponentWriter.toOutput();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            m_ShowToolTip = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_SHOW, "true"));
            m_ToolTipUserAsked = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_USERASKED, "false"));
        }
        catch (Exception exception) {
            m_ToolTipUserAsked = false;
            m_ShowToolTip = true;
        }
    }

    private class PrintMouseListener
    extends MouseAdapter {
        private PrintableComponent m_Component;

        PrintMouseListener(PrintableComponent printableComponent2) {
            this.m_Component = printableComponent2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 1) == 1 && (n & 8) == 8 && (n & 0x10) == 16) {
                mouseEvent.consume();
                this.m_Component.saveComponent();
            }
        }
    }

    protected class JComponentWriterFileFilter
    extends ExtensionFileFilter {
        private JComponentWriter m_Writer;

        public JComponentWriterFileFilter(String string, String string2, JComponentWriter jComponentWriter) {
            super(string, string2);
            this.m_Writer = jComponentWriter;
        }

        public JComponentWriter getWriter() {
            return this.m_Writer;
        }
    }
}

