/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.visualize.AttributePanel;
import weka.gui.visualize.AttributePanelEvent;
import weka.gui.visualize.AttributePanelListener;
import weka.gui.visualize.ClassPanel;
import weka.gui.visualize.LegendPanel;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.Plot2DCompanion;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.PrintablePanel;
import weka.gui.visualize.VisualizePanelEvent;
import weka.gui.visualize.VisualizePanelListener;
import weka.gui.visualize.VisualizeUtils;

public class VisualizePanel
extends PrintablePanel {
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected JComboBox m_XCombo = new JComboBox();
    protected JComboBox m_YCombo = new JComboBox();
    protected JComboBox m_ColourCombo = new JComboBox();
    protected JComboBox m_ShapeCombo = new JComboBox();
    protected JButton m_submit = new JButton("Submit");
    protected JButton m_cancel = new JButton("Clear");
    protected JButton m_saveBut = new JButton("Save");
    private Dimension COMBO_SIZE;
    protected JFileChooser m_FileChooser;
    protected FileFilter m_ArffFilter;
    protected JLabel m_JitterLab;
    protected JSlider m_Jitter;
    protected PlotPanel m_plot;
    protected AttributePanel m_attrib;
    protected LegendPanel m_legendPanel;
    protected JPanel m_plotSurround;
    protected JPanel m_classSurround;
    protected ActionListener listener;
    protected VisualizePanelListener m_splitListener;
    protected String m_plotName;
    protected ClassPanel m_classPanel;
    protected FastVector m_colorList;
    protected String m_preferredXDimension;
    protected String m_preferredYDimension;
    protected String m_preferredColourDimension;
    protected boolean m_showAttBars;
    protected Logger m_Log;

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public VisualizePanel(VisualizePanelListener visualizePanelListener) {
        this();
        this.m_splitListener = visualizePanelListener;
    }

    private void setProperties(String string) {
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null) {
            String string2 = this.getClass().getName();
            if (string == null) {
                String string3 = string2 + ".displayAttributeBars";
                String string4 = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string3);
                this.m_showAttBars = string4 == null ? true : string4.compareTo("true") == 0 || string4.compareTo("on") == 0;
            } else {
                String string5 = string2 + "." + string + ".XDimension";
                String string6 = string2 + "." + string + ".YDimension";
                String string7 = string2 + "." + string + ".ColourDimension";
                this.m_preferredXDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string5);
                this.m_preferredYDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string6);
                this.m_preferredColourDimension = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string7);
            }
        }
    }

    public VisualizePanel() {
        Serializable serializable;
        this.COMBO_SIZE = new Dimension(250, this.m_saveBut.getPreferredSize().height);
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_ArffFilter = new ExtensionFileFilter(Instances.FILE_EXTENSION, LocalString.get("Arff data files"));
        this.m_JitterLab = new JLabel("Jitter", 4);
        this.m_Jitter = new JSlider(0, 50, 0);
        this.m_plot = new PlotPanel();
        this.m_attrib = new AttributePanel();
        this.m_legendPanel = new LegendPanel();
        this.m_plotSurround = new JPanel();
        this.m_classSurround = new JPanel();
        this.listener = null;
        this.m_splitListener = null;
        this.m_plotName = "";
        this.m_classPanel = new ClassPanel();
        this.m_preferredXDimension = null;
        this.m_preferredYDimension = null;
        this.m_preferredColourDimension = null;
        this.m_showAttBars = true;
        this.setProperties(null);
        this.m_FileChooser.setFileFilter(this.m_ArffFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_XCombo.setToolTipText(LocalString.get("Select the attribute for the x axis"));
        this.m_YCombo.setToolTipText(LocalString.get("Select the attribute for the y axis"));
        this.m_ColourCombo.setToolTipText(LocalString.get("Select the attribute to colour on"));
        this.m_ShapeCombo.setToolTipText(LocalString.get("Select the shape to use for data selection"));
        this.m_XCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_YCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ColourCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_XCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_YCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ColourCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_XCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_YCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ColourCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_ShapeCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_XCombo.setEnabled(false);
        this.m_YCombo.setEnabled(false);
        this.m_ColourCombo.setEnabled(false);
        this.m_ShapeCombo.setEnabled(false);
        this.m_classPanel.addRepaintNotify(this);
        this.m_legendPanel.addRepaintNotify(this);
        this.m_colorList = new FastVector(10);
        for (int i = this.m_colorList.size(); i < 10; ++i) {
            serializable = this.m_DefaultColors[i % 10];
            int n = i / 10;
            n *= 2;
            for (int j = 0; j < n; ++j) {
                serializable = serializable.darker();
            }
            this.m_colorList.addElement(serializable);
        }
        this.m_plot.setColours(this.m_colorList);
        this.m_classPanel.setColours(this.m_colorList);
        this.m_attrib.setColours(this.m_colorList);
        this.m_attrib.addAttributePanelListener(new AttributePanelListener(){

            public void attributeSelectionChange(AttributePanelEvent attributePanelEvent) {
                if (attributePanelEvent.m_xChange) {
                    VisualizePanel.this.m_XCombo.setSelectedIndex(attributePanelEvent.m_indexVal);
                } else {
                    VisualizePanel.this.m_YCombo.setSelectedIndex(attributePanelEvent.m_indexVal);
                }
            }
        });
        this.m_XCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = VisualizePanel.this.m_XCombo.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                VisualizePanel.this.m_plot.setXindex(n);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(actionEvent);
                }
            }
        });
        this.m_YCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = VisualizePanel.this.m_YCombo.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                VisualizePanel.this.m_plot.setYindex(n);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(actionEvent);
                }
            }
        });
        this.m_ColourCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = VisualizePanel.this.m_ColourCombo.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                VisualizePanel.this.m_plot.setCindex(n);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(actionEvent);
                }
            }
        });
        this.m_ShapeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = VisualizePanel.this.m_ShapeCombo.getSelectedIndex();
                if (n < 0) {
                    n = 0;
                }
                VisualizePanel.this.m_plot.setSindex(n);
                if (VisualizePanel.this.listener != null) {
                    VisualizePanel.this.listener.actionPerformed(actionEvent);
                }
            }
        });
        this.m_Jitter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VisualizePanel.this.m_plot.setJitter(VisualizePanel.this.m_Jitter.getValue());
            }
        });
        this.m_saveBut.setEnabled(false);
        this.m_saveBut.setToolTipText(LocalString.get("Save the visible instances to a file"));
        this.m_saveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisualizePanel.this.saveVisibleInstances();
            }
        });
        JPanel jPanel = new JPanel();
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_XCombo.setLightWeightPopupEnabled(false);
        this.m_YCombo.setLightWeightPopupEnabled(false);
        this.m_ColourCombo.setLightWeightPopupEnabled(false);
        this.m_ShapeCombo.setLightWeightPopupEnabled(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_XCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_YCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_ColourCombo, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_ShapeCombo, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        jPanel2.add(this.m_submit);
        jPanel2.add(this.m_cancel);
        jPanel2.add(this.m_saveBut);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        jPanel.add((Component)this.m_JitterLab, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.m_Jitter, gridBagConstraints);
        this.m_classSurround = new JPanel();
        this.m_classSurround.setBorder(BorderFactory.createTitledBorder(LocalString.get("Class colour")));
        this.m_classSurround.setLayout(new BorderLayout());
        this.m_classPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.m_classSurround.add((Component)this.m_classPanel, "Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_plotSurround.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.m_plotSurround.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 5.0;
        this.m_plotSurround.add((Component)this.m_plot, gridBagConstraints);
        if (this.m_showAttBars) {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 5.0;
            this.m_plotSurround.add((Component)this.m_attrib, gridBagConstraints);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.m_plotSurround, "Center");
        this.add((Component)this.m_classSurround, "South");
        String[] stringArray = new String[]{LocalString.get("Select Instance"), "Rectangle", "Polygon", "Polyline"};
        this.m_ShapeCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_ShapeCombo.setEnabled(true);
    }

    private void saveVisibleInstances() {
        FastVector fastVector = this.m_plot.m_plot2D.getPlots();
        if (fastVector != null) {
            Object object;
            Object object2;
            int n;
            PlotData2D plotData2D = (PlotData2D)fastVector.elementAt(0);
            Instances instances = new Instances(plotData2D.getPlotInstances());
            for (n = 1; n < fastVector.size(); ++n) {
                object2 = (PlotData2D)fastVector.elementAt(n);
                object = ((PlotData2D)object2).getPlotInstances();
                for (int i = 0; i < ((Instances)object).numInstances(); ++i) {
                    instances.add(((Instances)object).instance(i));
                }
            }
            try {
                n = this.m_FileChooser.showSaveDialog(this);
                if (n == 0) {
                    object2 = this.m_FileChooser.getSelectedFile();
                    if (!((File)object2).getName().toLowerCase().endsWith(Instances.FILE_EXTENSION)) {
                        object2 = new File(((File)object2).getParent(), ((File)object2).getName() + Instances.FILE_EXTENSION);
                    }
                    object = object2;
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((File)object));
                    bufferedWriter.write(instances.toString());
                    ((Writer)bufferedWriter).close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setColourIndex(int n) {
        if (n >= 0) {
            this.m_ColourCombo.setSelectedIndex(n);
        } else {
            this.m_ColourCombo.setSelectedIndex(0);
        }
        this.m_ColourCombo.setEnabled(false);
    }

    public void setXIndex(int n) throws Exception {
        if (n < 0 || n >= this.m_XCombo.getItemCount()) {
            throw new Exception(LocalString.get("x index is out of range!"));
        }
        this.m_XCombo.setSelectedIndex(n);
    }

    public int getXIndex() {
        return this.m_XCombo.getSelectedIndex();
    }

    public void setYIndex(int n) throws Exception {
        if (n < 0 || n >= this.m_YCombo.getItemCount()) {
            throw new Exception(LocalString.get("y index is out of range!"));
        }
        this.m_YCombo.setSelectedIndex(n);
    }

    public int getYIndex() {
        return this.m_YCombo.getSelectedIndex();
    }

    public int getCIndex() {
        return this.m_ColourCombo.getSelectedIndex();
    }

    public int getSIndex() {
        return this.m_ShapeCombo.getSelectedIndex();
    }

    public void setSIndex(int n) throws Exception {
        if (n < 0 || n >= this.m_ShapeCombo.getItemCount()) {
            throw new Exception(LocalString.get("s index is out of range!"));
        }
        this.m_ShapeCombo.setSelectedIndex(n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void setName(String string) {
        this.m_plotName = string;
    }

    public String getName() {
        return this.m_plotName;
    }

    public Instances getInstances() {
        return this.m_plot.m_plotInstances;
    }

    protected void newColorAttribute(int n, Instances instances) {
        if (instances.attribute(n).isNominal()) {
            for (int i = this.m_colorList.size(); i < instances.attribute(n).numValues(); ++i) {
                Color color = this.m_DefaultColors[i % 10];
                int n2 = i / 10;
                n2 *= 2;
                for (int j = 0; j < n2; ++j) {
                    color = color.brighter();
                }
                this.m_colorList.addElement(color);
            }
            this.m_plot.setColours(this.m_colorList);
            this.m_attrib.setColours(this.m_colorList);
            this.m_classPanel.setColours(this.m_colorList);
        }
    }

    public void setShapes(FastVector fastVector) {
        this.m_plot.setShapes(fastVector);
    }

    public void setInstances(Instances instances) {
        if (instances.numAttributes() > 0 && instances.numInstances() > 0) {
            this.newColorAttribute(instances.numAttributes() - 1, instances);
        }
        PlotData2D plotData2D = new PlotData2D(instances);
        plotData2D.setPlotName(instances.relationName());
        try {
            this.setMasterPlot(plotData2D);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void setUpComboBoxes(Instances instances) {
        this.setProperties(instances.relationName());
        int n = -1;
        int n2 = -1;
        if (instances.numAttributes() > 1) {
            n2 = 1;
        }
        int n3 = -1;
        String[] stringArray = new String[instances.numAttributes()];
        String[] stringArray2 = new String[instances.numAttributes()];
        String[] stringArray3 = new String[instances.numAttributes()];
        String[] stringArray4 = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            switch (instances.attribute(i).type()) {
                case 1: {
                    string = LocalString.get(" (Nom)");
                    break;
                }
                case 0: {
                    string = LocalString.get(" (Num)");
                    break;
                }
                case 2: {
                    string = LocalString.get(" (Str)");
                    break;
                }
                default: {
                    string = " (???)";
                }
            }
            stringArray[i] = "X: " + instances.attribute(i).name() + string;
            stringArray2[i] = "Y: " + instances.attribute(i).name() + string;
            stringArray3[i] = LocalString.get("Colour: ") + instances.attribute(i).name() + string;
            if (this.m_preferredXDimension != null && this.m_preferredXDimension.compareTo(instances.attribute(i).name()) == 0) {
                n = i;
            }
            if (this.m_preferredYDimension != null && this.m_preferredYDimension.compareTo(instances.attribute(i).name()) == 0) {
                n2 = i;
            }
            if (this.m_preferredColourDimension == null || this.m_preferredColourDimension.compareTo(instances.attribute(i).name()) != 0) continue;
            n3 = i;
        }
        this.m_XCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.m_YCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.m_ColourCombo.setModel(new DefaultComboBoxModel<String>(stringArray3));
        this.m_XCombo.setEnabled(true);
        this.m_YCombo.setEnabled(true);
        if (this.m_splitListener == null) {
            this.m_ColourCombo.setEnabled(true);
            this.m_ColourCombo.setSelectedIndex(instances.numAttributes() - 1);
        }
        this.m_plotSurround.setBorder(BorderFactory.createTitledBorder(LocalString.get("Plot: ") + instances.relationName()));
        try {
            if (n != -1) {
                this.setXIndex(n);
            }
            if (n2 != -1) {
                this.setYIndex(n2);
            }
            if (n3 != -1) {
                this.m_ColourCombo.setSelectedIndex(n3);
            }
        }
        catch (Exception exception) {
            System.err.println(LocalString.get("Problem setting preferred Visualization dimensions"));
        }
    }

    public void setMasterPlot(PlotData2D plotData2D) throws Exception {
        this.m_plot.setMasterPlot(plotData2D);
        this.setUpComboBoxes(plotData2D.m_plotInstances);
        this.m_saveBut.setEnabled(true);
        this.repaint();
    }

    public void addPlot(PlotData2D plotData2D) throws Exception {
        this.m_plot.addPlot(plotData2D);
        if (this.m_plot.m_plot2D.getMasterPlot() != null) {
            this.setUpComboBoxes(plotData2D.m_plotInstances);
        }
        this.m_saveBut.setEnabled(true);
        this.repaint();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println(LocalString.get("Usage : weka.gui.visualize.VisualizePanel ") + LocalString.get("<dataset> [<dataset> <dataset>...]"));
                System.exit(1);
            }
            final JFrame jFrame = new JFrame(LocalString.get("Weka Explorer: Visualize"));
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            VisualizePanel visualizePanel = new VisualizePanel();
            jFrame.getContentPane().add((Component)visualizePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setVisible(true);
            if (stringArray.length >= 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.err.println(LocalString.get("Loading instances from ") + stringArray[i]);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[i]));
                    Instances instances = new Instances(bufferedReader);
                    instances.setClassIndex(instances.numAttributes() - 1);
                    PlotData2D plotData2D = new PlotData2D(instances);
                    if (i == 0) {
                        plotData2D.setPlotName(LocalString.get("Master plot"));
                        visualizePanel.setMasterPlot(plotData2D);
                        continue;
                    }
                    plotData2D.setPlotName(LocalString.get("Plot ") + (i + 1));
                    plotData2D.m_useCustomColour = true;
                    plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                    visualizePanel.addPlot(plotData2D);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected class PlotPanel
    extends PrintablePanel
    implements Plot2DCompanion {
        protected Plot2D m_plot2D = new Plot2D();
        protected Instances m_plotInstances = null;
        protected PlotData2D m_originalPlot = null;
        protected int m_xIndex = 0;
        protected int m_yIndex = 0;
        protected int m_cIndex = 0;
        protected int m_sIndex = 0;
        private final int m_axisPad = 5;
        private final int m_tickSize = 5;
        private int m_XaxisStart = 0;
        private int m_YaxisStart = 0;
        private int m_XaxisEnd = 0;
        private int m_YaxisEnd = 0;
        private boolean m_createShape;
        private FastVector m_shapes;
        private FastVector m_shapePoints;
        private Dimension m_newMousePos;

        public PlotPanel() {
            this.setBackground(this.m_plot2D.getBackground());
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_plot2D, "Center");
            this.m_plot2D.setPlotCompanion(this);
            this.m_createShape = false;
            this.m_shapes = null;
            this.m_shapePoints = null;
            this.m_newMousePos = new Dimension();
            this.addMouseListener(new MouseAdapter(this, VisualizePanel.this){
                private final /* synthetic */ VisualizePanel val$this$0;
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                    this.val$this$0 = visualizePanel;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 0x10) == 16 && this.this$1.m_sIndex != 0 && this.this$1.m_sIndex == 1) {
                        PlotPanel.access$002(this.this$1, true);
                        PlotPanel.access$102(this.this$1, new FastVector(5));
                        PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_sIndex));
                        PlotPanel.access$100(this.this$1).addElement(new Double(mouseEvent.getX()));
                        PlotPanel.access$100(this.this$1).addElement(new Double(mouseEvent.getY()));
                        PlotPanel.access$100(this.this$1).addElement(new Double(mouseEvent.getX()));
                        PlotPanel.access$100(this.this$1).addElement(new Double(mouseEvent.getY()));
                        Graphics graphics = this.this$1.m_plot2D.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        graphics.drawRect(((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(3)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(4)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue());
                        graphics.dispose();
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void mouseClicked(MouseEvent mouseEvent) {
                    block16: {
                        block17: {
                            if (this.this$1.m_sIndex != 2 && this.this$1.m_sIndex != 3) break block16;
                            if (PlotPanel.access$000(this.this$1)) break block17;
                            if ((mouseEvent.getModifiers() & 0x10) != 16) break block16;
                        }
                        if (!PlotPanel.access$000(this.this$1)) {
                            if ((mouseEvent.getModifiers() & 0x10) != 16) return;
                            PlotPanel.access$002(this.this$1, true);
                            PlotPanel.access$102(this.this$1, new FastVector(17));
                            PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_sIndex));
                            PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_plot2D.convertToAttribX(mouseEvent.getX())));
                            PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_plot2D.convertToAttribY(mouseEvent.getY())));
                            PlotPanel.access$200((PlotPanel)this.this$1).width = mouseEvent.getX();
                            PlotPanel.access$200((PlotPanel)this.this$1).height = mouseEvent.getY();
                            Graphics graphics = this.this$1.m_plot2D.getGraphics();
                            graphics.setColor(Color.black);
                            graphics.setXORMode(Color.white);
                            graphics.drawLine((int)Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(1))), (int)Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(2))), PlotPanel.access$200((PlotPanel)this.this$1).width, PlotPanel.access$200((PlotPanel)this.this$1).height);
                            graphics.dispose();
                            return;
                        }
                        Graphics graphics = this.this$1.m_plot2D.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        if ((mouseEvent.getModifiers() & 0x10) == 16 && !mouseEvent.isAltDown()) {
                            PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_plot2D.convertToAttribX(mouseEvent.getX())));
                            PlotPanel.access$100(this.this$1).addElement(new Double(this.this$1.m_plot2D.convertToAttribY(mouseEvent.getY())));
                            PlotPanel.access$200((PlotPanel)this.this$1).width = mouseEvent.getX();
                            PlotPanel.access$200((PlotPanel)this.this$1).height = mouseEvent.getY();
                            graphics.drawLine((int)Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2))), (int)Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 1))), PlotPanel.access$200((PlotPanel)this.this$1).width, PlotPanel.access$200((PlotPanel)this.this$1).height);
                        } else if (this.this$1.m_sIndex == 3) {
                            PlotPanel.access$002(this.this$1, false);
                            if (PlotPanel.access$100(this.this$1).size() >= 5) {
                                double d = Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 4)));
                                double d2 = Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2))) - d;
                                d2 *= 50000.0;
                                double d3 = Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 3)));
                                double d4 = Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 1))) - d3;
                                d4 *= 50000.0;
                                double d5 = Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(3)));
                                double d6 = Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(1))) - d5;
                                double d7 = Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(4)));
                                double d8 = Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(2))) - d7;
                                PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribX((d6 *= 50000.0) + d5)), 1);
                                PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribY(d4 + d3)), PlotPanel.access$100(this.this$1).size() - 1);
                                PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribX(d2 + d)), PlotPanel.access$100(this.this$1).size() - 2);
                                PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribY((d8 *= 50000.0) + d7)), 2);
                                d3 = Double.POSITIVE_INFINITY;
                                d4 = Double.NEGATIVE_INFINITY;
                                if ((Double)PlotPanel.access$100(this.this$1).elementAt(1) > (Double)PlotPanel.access$100(this.this$1).elementAt(3) && ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).doubleValue() == ((Double)PlotPanel.access$100(this.this$1).elementAt(4)).doubleValue()) {
                                    d3 = (Double)PlotPanel.access$100(this.this$1).elementAt(2);
                                }
                                if ((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2) > (Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 4) && ((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 3)).doubleValue() == ((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 1)).doubleValue()) {
                                    d4 = (Double)PlotPanel.access$100(this.this$1).lastElement();
                                }
                                PlotPanel.access$100(this.this$1).addElement(new Double(d3));
                                PlotPanel.access$100(this.this$1).addElement(new Double(d4));
                                if (!PlotPanel.access$300(this.this$1, PlotPanel.access$100(this.this$1), this.this$1.m_plot2D.convertToAttribX(mouseEvent.getX()), this.this$1.m_plot2D.convertToAttribY(mouseEvent.getY()))) {
                                    Double d9 = (Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2);
                                    PlotPanel.access$100(this.this$1).setElementAt(PlotPanel.access$100(this.this$1).lastElement(), PlotPanel.access$100(this.this$1).size() - 2);
                                    PlotPanel.access$100(this.this$1).setElementAt(d9, PlotPanel.access$100(this.this$1).size() - 1);
                                }
                                if (PlotPanel.access$400(this.this$1) == null) {
                                    PlotPanel.access$402(this.this$1, new FastVector(4));
                                }
                                PlotPanel.access$400(this.this$1).addElement(PlotPanel.access$100(this.this$1));
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setText("Submit");
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setActionCommand("Submit");
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setEnabled(true);
                            }
                            PlotPanel.access$102(this.this$1, null);
                            this.this$1.repaint();
                        } else {
                            PlotPanel.access$002(this.this$1, false);
                            if (PlotPanel.access$100(this.this$1).size() >= 7) {
                                PlotPanel.access$100(this.this$1).addElement(PlotPanel.access$100(this.this$1).elementAt(1));
                                PlotPanel.access$100(this.this$1).addElement(PlotPanel.access$100(this.this$1).elementAt(2));
                                if (PlotPanel.access$400(this.this$1) == null) {
                                    PlotPanel.access$402(this.this$1, new FastVector(4));
                                }
                                PlotPanel.access$400(this.this$1).addElement(PlotPanel.access$100(this.this$1));
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setText("Submit");
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setActionCommand("Submit");
                                PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setEnabled(true);
                            }
                            PlotPanel.access$102(this.this$1, null);
                            this.this$1.repaint();
                        }
                        graphics.dispose();
                        return;
                    }
                    if ((mouseEvent.getModifiers() & 0x10) == 16) {
                        this.this$1.m_plot2D.searchPoints(mouseEvent.getX(), mouseEvent.getY(), false);
                        return;
                    }
                    this.this$1.m_plot2D.searchPoints(mouseEvent.getX(), mouseEvent.getY(), true);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (PlotPanel.access$000(this.this$1) && ((Double)PlotPanel.access$100(this.this$1).elementAt(0)).intValue() == 1) {
                        PlotPanel.access$002(this.this$1, false);
                        Graphics graphics = this.this$1.m_plot2D.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        graphics.drawRect(((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(3)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(4)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue());
                        graphics.dispose();
                        if (PlotPanel.access$600(this.this$1, (Double)PlotPanel.access$100(this.this$1).elementAt(1), (Double)PlotPanel.access$100(this.this$1).elementAt(2)) && PlotPanel.access$600(this.this$1, (Double)PlotPanel.access$100(this.this$1).elementAt(3), (Double)PlotPanel.access$100(this.this$1).elementAt(4)) && (Double)PlotPanel.access$100(this.this$1).elementAt(1) < (Double)PlotPanel.access$100(this.this$1).elementAt(3) && (Double)PlotPanel.access$100(this.this$1).elementAt(2) < (Double)PlotPanel.access$100(this.this$1).elementAt(4)) {
                            if (PlotPanel.access$400(this.this$1) == null) {
                                PlotPanel.access$402(this.this$1, new FastVector(2));
                            }
                            PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribX((Double)PlotPanel.access$100(this.this$1).elementAt(1))), 1);
                            PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribY((Double)PlotPanel.access$100(this.this$1).elementAt(2))), 2);
                            PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribX((Double)PlotPanel.access$100(this.this$1).elementAt(3))), 3);
                            PlotPanel.access$100(this.this$1).setElementAt(new Double(this.this$1.m_plot2D.convertToAttribY((Double)PlotPanel.access$100(this.this$1).elementAt(4))), 4);
                            PlotPanel.access$400(this.this$1).addElement(PlotPanel.access$100(this.this$1));
                            PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setText("Submit");
                            PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setActionCommand("Submit");
                            PlotPanel.access$500((PlotPanel)this.this$1).m_submit.setEnabled(true);
                            this.this$1.repaint();
                        }
                        PlotPanel.access$102(this.this$1, null);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (PlotPanel.access$000(this.this$1) && ((Double)PlotPanel.access$100(this.this$1).elementAt(0)).intValue() == 1) {
                        Graphics graphics = this.this$1.m_plot2D.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        graphics.drawRect(((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(3)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(4)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue());
                        PlotPanel.access$100(this.this$1).setElementAt(new Double(mouseEvent.getX()), 3);
                        PlotPanel.access$100(this.this$1).setElementAt(new Double(mouseEvent.getY()), 4);
                        graphics.drawRect(((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(3)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(1)).intValue(), ((Double)PlotPanel.access$100(this.this$1).elementAt(4)).intValue() - ((Double)PlotPanel.access$100(this.this$1).elementAt(2)).intValue());
                        graphics.dispose();
                    }
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (PlotPanel.access$000(this.this$1) && (((Double)PlotPanel.access$100(this.this$1).elementAt(0)).intValue() == 2 || ((Double)PlotPanel.access$100(this.this$1).elementAt(0)).intValue() == 3)) {
                        Graphics graphics = this.this$1.m_plot2D.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.setXORMode(Color.white);
                        graphics.drawLine((int)Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2))), (int)Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 1))), PlotPanel.access$200((PlotPanel)this.this$1).width, PlotPanel.access$200((PlotPanel)this.this$1).height);
                        PlotPanel.access$200((PlotPanel)this.this$1).width = mouseEvent.getX();
                        PlotPanel.access$200((PlotPanel)this.this$1).height = mouseEvent.getY();
                        graphics.drawLine((int)Math.ceil(this.this$1.m_plot2D.convertToPanelX((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 2))), (int)Math.ceil(this.this$1.m_plot2D.convertToPanelY((Double)PlotPanel.access$100(this.this$1).elementAt(PlotPanel.access$100(this.this$1).size() - 1))), PlotPanel.access$200((PlotPanel)this.this$1).width, PlotPanel.access$200((PlotPanel)this.this$1).height);
                        graphics.dispose();
                    }
                }
            });
            VisualizePanel.this.m_submit.addActionListener(new ActionListener(this, VisualizePanel.this){
                private final /* synthetic */ VisualizePanel val$this$0;
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                    this.val$this$0 = visualizePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("Submit")) {
                        if (PlotPanel.access$500((PlotPanel)this.this$1).m_splitListener != null && PlotPanel.access$400(this.this$1) != null) {
                            Instances instances = new Instances(this.this$1.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            Instances instances2 = new Instances(this.this$1.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            if (this.this$1.m_plot2D.getMasterPlot().m_plotInstances != null) {
                                for (int i = 0; i < this.this$1.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++i) {
                                    if (this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i).isMissing(this.this$1.m_xIndex) || this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i).isMissing(this.this$1.m_yIndex)) continue;
                                    if (this.this$1.inSplit(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i))) {
                                        instances.add(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i));
                                        continue;
                                    }
                                    instances2.add(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i));
                                }
                                FastVector fastVector = PlotPanel.access$400(this.this$1);
                                this.this$1.cancelShapes();
                                PlotPanel.access$500((PlotPanel)this.this$1).m_splitListener.userDataEvent(new VisualizePanelEvent(fastVector, instances, instances2, this.this$1.m_xIndex, this.this$1.m_yIndex));
                            }
                        } else if (PlotPanel.access$400(this.this$1) != null && this.this$1.m_plot2D.getMasterPlot().m_plotInstances != null) {
                            Instances instances = new Instances(this.this$1.m_plot2D.getMasterPlot().m_plotInstances, 500);
                            int n = 0;
                            for (int i = 0; i < this.this$1.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++i) {
                                if (!this.this$1.inSplit(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i))) continue;
                                instances.add(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i));
                                ++n;
                            }
                            int[] nArray = null;
                            int[] nArray2 = null;
                            int n2 = this.this$1.m_xIndex;
                            int n3 = this.this$1.m_yIndex;
                            if (this.this$1.m_originalPlot == null) {
                                this.this$1.m_originalPlot = this.this$1.m_plot2D.getMasterPlot();
                            }
                            if (n > 0) {
                                nArray2 = new int[n];
                                nArray = new int[n];
                                n = 0;
                                for (int i = 0; i < this.this$1.m_plot2D.getMasterPlot().m_plotInstances.numInstances(); ++i) {
                                    if (!this.this$1.inSplit(this.this$1.m_plot2D.getMasterPlot().m_plotInstances.instance(i))) continue;
                                    nArray2[n] = this.this$1.m_plot2D.getMasterPlot().m_shapeType[i];
                                    nArray[n] = this.this$1.m_plot2D.getMasterPlot().m_shapeSize[i];
                                    ++n;
                                }
                            }
                            this.this$1.cancelShapes();
                            PlotData2D plotData2D = new PlotData2D(instances);
                            try {
                                plotData2D.setShapeSize(nArray);
                                plotData2D.setShapeType(nArray2);
                                this.this$1.m_plot2D.removeAllPlots();
                                PlotPanel.access$500(this.this$1).addPlot(plotData2D);
                            }
                            catch (Exception exception) {
                                System.err.println(exception);
                                exception.printStackTrace();
                            }
                            try {
                                PlotPanel.access$500(this.this$1).setXIndex(n2);
                                PlotPanel.access$500(this.this$1).setYIndex(n3);
                            }
                            catch (Exception exception) {
                                System.out.println(LocalString.get("Error : ") + exception);
                            }
                        }
                    } else if (actionEvent.getActionCommand().equals("Reset")) {
                        int n = this.this$1.m_xIndex;
                        int n4 = this.this$1.m_yIndex;
                        this.this$1.m_plot2D.removeAllPlots();
                        try {
                            PlotPanel.access$500(this.this$1).addPlot(this.this$1.m_originalPlot);
                        }
                        catch (Exception exception) {
                            System.err.println(exception);
                            exception.printStackTrace();
                        }
                        try {
                            PlotPanel.access$500(this.this$1).setXIndex(n);
                            PlotPanel.access$500(this.this$1).setYIndex(n4);
                        }
                        catch (Exception exception) {
                            System.out.println(LocalString.get("Error : ") + exception);
                        }
                    }
                }
            });
            VisualizePanel.this.m_cancel.addActionListener(new ActionListener(this, VisualizePanel.this){
                private final /* synthetic */ VisualizePanel val$this$0;
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                    this.val$this$0 = visualizePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cancelShapes();
                    this.this$1.repaint();
                }
            });
        }

        public FastVector getShapes() {
            return this.m_shapes;
        }

        public void cancelShapes() {
            if (VisualizePanel.this.m_splitListener == null) {
                VisualizePanel.this.m_submit.setText("Reset");
                VisualizePanel.this.m_submit.setActionCommand("Reset");
                if (this.m_originalPlot == null || this.m_originalPlot.m_plotInstances == this.m_plotInstances) {
                    VisualizePanel.this.m_submit.setEnabled(false);
                } else {
                    VisualizePanel.this.m_submit.setEnabled(true);
                }
            } else {
                VisualizePanel.this.m_submit.setEnabled(false);
            }
            this.m_createShape = false;
            this.m_shapePoints = null;
            this.m_shapes = null;
            this.repaint();
        }

        public void setShapes(FastVector fastVector) {
            if (fastVector != null) {
                this.m_shapes = new FastVector(fastVector.size());
                for (int i = 0; i < fastVector.size(); ++i) {
                    FastVector fastVector2 = new FastVector(((FastVector)fastVector.elementAt(i)).size());
                    this.m_shapes.addElement(fastVector2);
                    for (int j = 0; j < ((FastVector)fastVector.elementAt(i)).size(); ++j) {
                        fastVector2.addElement(((FastVector)fastVector.elementAt(i)).elementAt(j));
                    }
                }
            } else {
                this.m_shapes = null;
            }
            this.repaint();
        }

        private boolean checkPoints(double d, double d2) {
            return !(d < 0.0 || d > (double)this.getSize().width || d2 < 0.0) && !(d2 > (double)this.getSize().height);
        }

        public boolean inSplit(Instance instance) {
            if (this.m_shapes != null) {
                for (int i = 0; i < this.m_shapes.size(); ++i) {
                    FastVector fastVector = (FastVector)this.m_shapes.elementAt(i);
                    if (((Double)fastVector.elementAt(0)).intValue() == 1) {
                        double d = (Double)fastVector.elementAt(1);
                        double d2 = (Double)fastVector.elementAt(2);
                        double d3 = (Double)fastVector.elementAt(3);
                        double d4 = (Double)fastVector.elementAt(4);
                        if (!(instance.value(this.m_xIndex) >= d) || !(instance.value(this.m_xIndex) <= d3) || !(instance.value(this.m_yIndex) <= d2) || !(instance.value(this.m_yIndex) >= d4)) continue;
                        return true;
                    }
                    if (!(((Double)fastVector.elementAt(0)).intValue() == 2 ? this.inPoly(fastVector, instance.value(this.m_xIndex), instance.value(this.m_yIndex)) : ((Double)fastVector.elementAt(0)).intValue() == 3 && this.inPolyline(fastVector, instance.value(this.m_xIndex), instance.value(this.m_yIndex)))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean inPolyline(FastVector fastVector, double d, double d2) {
            double d3;
            double d4;
            int n = 0;
            for (int i = 1; i < fastVector.size() - 4; i += 2) {
                double d5;
                d4 = (Double)fastVector.elementAt(i + 1);
                d3 = (Double)fastVector.elementAt(i + 3);
                double d6 = (Double)fastVector.elementAt(i);
                double d7 = (Double)fastVector.elementAt(i + 2);
                double d8 = d3 - d4;
                double d9 = d7 - d6;
                if (i == 1 && i == fastVector.size() - 6) {
                    if (d8 == 0.0 || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (i == 1) {
                    if (!(d2 < d3 && d8 > 0.0) && (!(d2 > d3) || !(d8 < 0.0)) || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (i == fastVector.size() - 6) {
                    if (!(d2 <= d4 && d8 < 0.0) && (!(d2 >= d4) || !(d8 > 0.0)) || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                    ++n;
                    continue;
                }
                if (!(d4 <= d2 && d2 < d3) && (!(d3 < d2) || !(d2 <= d4)) || d8 == 0.0 || !(d9 * (d5 = (d2 - d4) / d8) + d6 >= d)) continue;
                ++n;
            }
            d4 = (Double)fastVector.elementAt(fastVector.size() - 2);
            if (d4 > (d3 = ((Double)fastVector.elementAt(fastVector.size() - 1)).doubleValue())) {
                if (d4 >= d2 && d2 > d3) {
                    ++n;
                }
            } else if (d4 >= d2 || d2 > d3) {
                ++n;
            }
            return n % 2 == 1;
        }

        private boolean inPoly(FastVector fastVector, double d, double d2) {
            int n = 0;
            for (int i = 1; i < fastVector.size() - 2; i += 2) {
                double d3;
                double d4;
                double d5 = (Double)fastVector.elementAt(i + 1);
                double d6 = (Double)fastVector.elementAt(i + 3);
                if (!((d5 <= d2 && d2 < d6 || d6 < d2 && d2 <= d5) && (d4 = d6 - d5) != 0.0)) continue;
                double d7 = (Double)fastVector.elementAt(i);
                double d8 = (Double)fastVector.elementAt(i + 2);
                double d9 = d8 - d7;
                if (!(d9 * (d3 = (d2 - d5) / d4) + d7 >= d)) continue;
                ++n;
            }
            return n % 2 == 1;
        }

        public void setJitter(int n) {
            this.m_plot2D.setJitter(n);
        }

        public void setXindex(int n) {
            if (n != this.m_xIndex) {
                this.cancelShapes();
            }
            this.m_xIndex = n;
            this.m_plot2D.setXindex(n);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setX(n);
            }
        }

        public void setYindex(int n) {
            if (n != this.m_yIndex) {
                this.cancelShapes();
            }
            this.m_yIndex = n;
            this.m_plot2D.setYindex(n);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setY(n);
            }
        }

        public void setCindex(int n) {
            this.m_cIndex = n;
            this.m_plot2D.setCindex(n);
            if (VisualizePanel.this.m_showAttBars) {
                VisualizePanel.this.m_attrib.setCindex(n, this.m_plot2D.getMaxC(), this.m_plot2D.getMinC());
            }
            VisualizePanel.this.m_classPanel.setCindex(n);
            this.repaint();
        }

        public void setSindex(int n) {
            if (n != this.m_sIndex) {
                this.m_shapePoints = null;
                this.m_createShape = false;
            }
            this.m_sIndex = n;
            this.repaint();
        }

        public void setMasterPlot(PlotData2D plotData2D) throws Exception {
            this.m_plot2D.removeAllPlots();
            this.addPlot(plotData2D);
        }

        public void addPlot(PlotData2D plotData2D) throws Exception {
            if (this.m_plot2D.getPlots().size() == 0) {
                block12: {
                    this.m_plot2D.addPlot(plotData2D);
                    if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_attrib && VisualizePanel.this.m_showAttBars) {
                        try {
                            VisualizePanel.this.m_attrib.setInstances(plotData2D.m_plotInstances);
                            VisualizePanel.this.m_attrib.setCindex(0);
                            VisualizePanel.this.m_attrib.setX(0);
                            VisualizePanel.this.m_attrib.setY(0);
                        }
                        catch (Exception exception) {
                            VisualizePanel.this.m_plotSurround.remove(VisualizePanel.this.m_attrib);
                            System.err.println(LocalString.get("Warning : data contains more attributes ") + LocalString.get("than can be displayed as attribute bars."));
                            if (VisualizePanel.this.m_Log != null) {
                                VisualizePanel.this.m_Log.logMessage(LocalString.get("Warning : data contains more attributes ") + LocalString.get("than can be displayed as attribute bars."));
                            }
                            break block12;
                        }
                    }
                    if (VisualizePanel.this.m_showAttBars) {
                        try {
                            VisualizePanel.this.m_attrib.setInstances(plotData2D.m_plotInstances);
                            VisualizePanel.this.m_attrib.setCindex(0);
                            VisualizePanel.this.m_attrib.setX(0);
                            VisualizePanel.this.m_attrib.setY(0);
                            GridBagConstraints gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.fill = 1;
                            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                            gridBagConstraints.gridx = 4;
                            gridBagConstraints.gridy = 0;
                            gridBagConstraints.weightx = 1.0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.gridheight = 1;
                            gridBagConstraints.weighty = 5.0;
                            VisualizePanel.this.m_plotSurround.add((Component)VisualizePanel.this.m_attrib, gridBagConstraints);
                        }
                        catch (Exception exception) {
                            System.err.println(LocalString.get("Warning : data contains more attributes ") + LocalString.get("than can be displayed as attribute bars."));
                            if (VisualizePanel.this.m_Log == null) break block12;
                            VisualizePanel.this.m_Log.logMessage(LocalString.get("Warning : data contains more attributes ") + LocalString.get("than can be displayed as attribute bars."));
                        }
                    }
                }
                VisualizePanel.this.m_classPanel.setInstances(plotData2D.m_plotInstances);
                this.plotReset(plotData2D.m_plotInstances, plotData2D.getCindex());
                if (plotData2D.m_useCustomColour) {
                    VisualizePanel.this.remove(VisualizePanel.this.m_classSurround);
                    this.switchToLegend();
                    VisualizePanel.this.m_legendPanel.setPlotList(this.m_plot2D.getPlots());
                    VisualizePanel.this.m_ColourCombo.setEnabled(false);
                }
            } else {
                if (!plotData2D.m_useCustomColour) {
                    VisualizePanel.this.add((Component)VisualizePanel.this.m_classSurround, "South");
                    VisualizePanel.this.m_ColourCombo.setEnabled(true);
                }
                if (this.m_plot2D.getPlots().size() == 1) {
                    this.switchToLegend();
                }
                this.m_plot2D.addPlot(plotData2D);
                VisualizePanel.this.m_legendPanel.setPlotList(this.m_plot2D.getPlots());
            }
        }

        protected void switchToLegend() {
            if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_attrib) {
                VisualizePanel.this.m_plotSurround.remove(VisualizePanel.this.m_attrib);
            }
            if (VisualizePanel.this.m_plotSurround.getComponentCount() > 1 && VisualizePanel.this.m_plotSurround.getComponent(1) == VisualizePanel.this.m_legendPanel) {
                return;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 5.0;
            VisualizePanel.this.m_plotSurround.add((Component)VisualizePanel.this.m_legendPanel, gridBagConstraints);
            this.setSindex(0);
            VisualizePanel.this.m_ShapeCombo.setEnabled(false);
        }

        private void plotReset(Instances instances, int n) {
            if (VisualizePanel.this.m_splitListener == null) {
                VisualizePanel.this.m_submit.setText("Reset");
                VisualizePanel.this.m_submit.setActionCommand("Reset");
                if (this.m_originalPlot == null || this.m_originalPlot.m_plotInstances == instances) {
                    VisualizePanel.this.m_submit.setEnabled(false);
                } else {
                    VisualizePanel.this.m_submit.setEnabled(true);
                }
            } else {
                VisualizePanel.this.m_submit.setEnabled(false);
            }
            this.m_plotInstances = instances;
            if (VisualizePanel.this.m_splitListener != null) {
                this.m_plotInstances.randomize(new Random());
            }
            this.m_xIndex = 0;
            this.m_yIndex = 0;
            this.m_cIndex = n;
            this.cancelShapes();
        }

        public void setColours(FastVector fastVector) {
            this.m_plot2D.setColours(fastVector);
            VisualizePanel.this.m_colorList = fastVector;
        }

        private void drawShapes(Graphics graphics) {
            Object object;
            if (this.m_shapes != null) {
                for (int i = 0; i < this.m_shapes.size(); ++i) {
                    int[] nArray;
                    int[] nArray2;
                    object = (FastVector)this.m_shapes.elementAt(i);
                    if (((Double)((FastVector)object).elementAt(0)).intValue() == 1) {
                        int n = (int)this.m_plot2D.convertToPanelX((Double)((FastVector)object).elementAt(1));
                        int n2 = (int)this.m_plot2D.convertToPanelY((Double)((FastVector)object).elementAt(2));
                        int n3 = (int)this.m_plot2D.convertToPanelX((Double)((FastVector)object).elementAt(3));
                        int n4 = (int)this.m_plot2D.convertToPanelY((Double)((FastVector)object).elementAt(4));
                        graphics.setColor(Color.gray);
                        graphics.fillRect(n, n2, n3 - n, n4 - n2);
                        graphics.setColor(Color.black);
                        graphics.drawRect(n, n2, n3 - n, n4 - n2);
                        continue;
                    }
                    if (((Double)((FastVector)object).elementAt(0)).intValue() == 2) {
                        nArray2 = this.getXCoords((FastVector)object);
                        nArray = this.getYCoords((FastVector)object);
                        graphics.setColor(Color.gray);
                        graphics.fillPolygon(nArray2, nArray, (((FastVector)object).size() - 1) / 2);
                        graphics.setColor(Color.black);
                        graphics.drawPolyline(nArray2, nArray, (((FastVector)object).size() - 1) / 2);
                        continue;
                    }
                    if (((Double)((FastVector)object).elementAt(0)).intValue() != 3) continue;
                    FastVector fastVector = this.makePolygon((FastVector)object);
                    nArray2 = this.getXCoords(fastVector);
                    nArray = this.getYCoords(fastVector);
                    graphics.setColor(Color.gray);
                    graphics.fillPolygon(nArray2, nArray, (fastVector.size() - 1) / 2);
                    graphics.setColor(Color.black);
                    graphics.drawPolyline(nArray2, nArray, (fastVector.size() - 1) / 2);
                }
            }
            if (this.m_shapePoints != null && (((Double)this.m_shapePoints.elementAt(0)).intValue() == 2 || ((Double)this.m_shapePoints.elementAt(0)).intValue() == 3)) {
                graphics.setColor(Color.black);
                graphics.setXORMode(Color.white);
                object = this.getXCoords(this.m_shapePoints);
                int[] nArray = this.getYCoords(this.m_shapePoints);
                graphics.drawPolyline((int[])object, nArray, (this.m_shapePoints.size() - 1) / 2);
                this.m_newMousePos.width = (int)Math.ceil(this.m_plot2D.convertToPanelX((Double)this.m_shapePoints.elementAt(this.m_shapePoints.size() - 2)));
                this.m_newMousePos.height = (int)Math.ceil(this.m_plot2D.convertToPanelY((Double)this.m_shapePoints.elementAt(this.m_shapePoints.size() - 1)));
                graphics.drawLine((int)Math.ceil(this.m_plot2D.convertToPanelX((Double)this.m_shapePoints.elementAt(this.m_shapePoints.size() - 2))), (int)Math.ceil(this.m_plot2D.convertToPanelY((Double)this.m_shapePoints.elementAt(this.m_shapePoints.size() - 1))), this.m_newMousePos.width, this.m_newMousePos.height);
                graphics.setPaintMode();
            }
        }

        private double[] lineIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            double d8 = -100.0;
            double d9 = -100.0;
            if (d5 == 0.0) {
                if (d <= d7 && d7 < d3 || d >= d7 && d7 > d3) {
                    double d10 = d - d3;
                    double d11 = (d7 - d3) / d10;
                    d9 = (d2 - d4) * d11 + d4;
                    d8 = 0.0 <= d9 && d9 <= d6 ? d7 : -100.0;
                }
            } else if (d6 == 0.0 && (d2 <= d7 && d7 < d4 || d2 >= d7 && d7 > d4)) {
                double d12 = d2 - d4;
                double d13 = (d7 - d4) / d12;
                d8 = (d - d3) * d13 + d3;
                if (0.0 <= d8 && d8 <= d5) {
                    d9 = d7;
                } else {
                    d8 = -100.0;
                }
            }
            double[] dArray = new double[]{d8, d9};
            return dArray;
        }

        private FastVector makePolygon(FastVector fastVector) {
            FastVector fastVector2;
            block28: {
                int n;
                int n2;
                int n3;
                int n4;
                block27: {
                    double[] dArray;
                    fastVector2 = new FastVector(fastVector.size() + 10);
                    n4 = 0;
                    n3 = 0;
                    for (int i = 0; i < fastVector.size() - 2; ++i) {
                        fastVector2.addElement(new Double((Double)fastVector.elementAt(i)));
                    }
                    double d = this.m_plot2D.convertToPanelX((Double)fastVector.elementAt(1));
                    double d2 = this.m_plot2D.convertToPanelY((Double)fastVector.elementAt(2));
                    double d3 = this.m_plot2D.convertToPanelX((Double)fastVector.elementAt(3));
                    double d4 = this.m_plot2D.convertToPanelY((Double)fastVector.elementAt(4));
                    if (d < 0.0) {
                        dArray = this.lineIntersect(d, d2, d3, d4, 0.0, this.getHeight(), 0.0);
                        n4 = 0;
                        if (dArray[0] < 0.0) {
                            if (d2 < 0.0) {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                                n4 = 1;
                            } else {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                                n4 = 3;
                            }
                        }
                    } else if (d > (double)this.getWidth()) {
                        dArray = this.lineIntersect(d, d2, d3, d4, 0.0, this.getHeight(), this.getWidth());
                        n4 = 2;
                        if (dArray[0] < 0.0) {
                            if (d2 < 0.0) {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                                n4 = 1;
                            } else {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                                n4 = 3;
                            }
                        }
                    } else if (d2 < 0.0) {
                        dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                        n4 = 1;
                    } else {
                        dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                        n4 = 3;
                    }
                    fastVector2.setElementAt(new Double(this.m_plot2D.convertToAttribX(dArray[0])), 1);
                    fastVector2.setElementAt(new Double(this.m_plot2D.convertToAttribY(dArray[1])), 2);
                    d = this.m_plot2D.convertToPanelX((Double)fastVector.elementAt(fastVector.size() - 4));
                    d2 = this.m_plot2D.convertToPanelY((Double)fastVector.elementAt(fastVector.size() - 3));
                    d3 = this.m_plot2D.convertToPanelX((Double)fastVector.elementAt(fastVector.size() - 6));
                    d4 = this.m_plot2D.convertToPanelY((Double)fastVector.elementAt(fastVector.size() - 5));
                    if (d < 0.0) {
                        dArray = this.lineIntersect(d, d2, d3, d4, 0.0, this.getHeight(), 0.0);
                        n3 = 0;
                        if (dArray[0] < 0.0) {
                            if (d2 < 0.0) {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                                n3 = 1;
                            } else {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                                n3 = 3;
                            }
                        }
                    } else if (d > (double)this.getWidth()) {
                        dArray = this.lineIntersect(d, d2, d3, d4, 0.0, this.getHeight(), this.getWidth());
                        n3 = 2;
                        if (dArray[0] < 0.0) {
                            if (d2 < 0.0) {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                                n3 = 1;
                            } else {
                                dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                                n3 = 3;
                            }
                        }
                    } else if (d2 < 0.0) {
                        dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, 0.0);
                        n3 = 1;
                    } else {
                        dArray = this.lineIntersect(d, d2, d3, d4, this.getWidth(), 0.0, this.getHeight());
                        n3 = 3;
                    }
                    fastVector2.setElementAt(new Double(this.m_plot2D.convertToAttribX(dArray[0])), fastVector2.size() - 2);
                    fastVector2.setElementAt(new Double(this.m_plot2D.convertToAttribY(dArray[1])), fastVector2.size() - 1);
                    n2 = this.getWidth() * (n3 & 1 ^ (n3 & 2) / 2);
                    n = this.getHeight() * ((n3 & 2) / 2);
                    if (!this.inPolyline(fastVector, this.m_plot2D.convertToAttribX(n2), this.m_plot2D.convertToAttribY(n))) break block27;
                    fastVector2.addElement(new Double(this.m_plot2D.convertToAttribX(n2)));
                    fastVector2.addElement(new Double(this.m_plot2D.convertToAttribY(n)));
                    int n5 = (n3 + 1) % 4;
                    while (n5 != n4) {
                        n2 = this.getWidth() * (n5 & 1 ^ (n5 & 2) / 2);
                        n = this.getHeight() * ((n5 & 2) / 2);
                        fastVector2.addElement(new Double(this.m_plot2D.convertToAttribX(n2)));
                        fastVector2.addElement(new Double(this.m_plot2D.convertToAttribY(n)));
                        n5 = (n5 + 1) % 4;
                    }
                    break block28;
                }
                n2 = this.getWidth() * ((n3 & 2) / 2);
                n = this.getHeight() * (1 & ~(n3 & 1 ^ (n3 & 2) / 2));
                if (!this.inPolyline(fastVector, this.m_plot2D.convertToAttribX(n2), this.m_plot2D.convertToAttribY(n))) break block28;
                fastVector2.addElement(new Double(this.m_plot2D.convertToAttribX(n2)));
                fastVector2.addElement(new Double(this.m_plot2D.convertToAttribY(n)));
                int n6 = (n3 + 3) % 4;
                while (n6 != n4) {
                    n2 = this.getWidth() * ((n6 & 2) / 2);
                    n = this.getHeight() * (1 & ~(n6 & 1 ^ (n6 & 2) / 2));
                    fastVector2.addElement(new Double(this.m_plot2D.convertToAttribX(n2)));
                    fastVector2.addElement(new Double(this.m_plot2D.convertToAttribY(n)));
                    n6 = (n6 + 3) % 4;
                }
            }
            return fastVector2;
        }

        private int[] getXCoords(FastVector fastVector) {
            int n = (fastVector.size() - 1) / 2;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)this.m_plot2D.convertToPanelX((Double)fastVector.elementAt(i * 2 + 1));
            }
            return nArray;
        }

        private int[] getYCoords(FastVector fastVector) {
            int n = (fastVector.size() - 1) / 2;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)this.m_plot2D.convertToPanelY((Double)fastVector.elementAt(i * 2 + 2));
            }
            return nArray;
        }

        public void prePlot(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.m_plotInstances != null) {
                this.drawShapes(graphics);
            }
        }

        static /* synthetic */ boolean access$002(PlotPanel plotPanel, boolean bl) {
            plotPanel.m_createShape = bl;
            return plotPanel.m_createShape;
        }

        static /* synthetic */ FastVector access$102(PlotPanel plotPanel, FastVector fastVector) {
            plotPanel.m_shapePoints = fastVector;
            return plotPanel.m_shapePoints;
        }

        static /* synthetic */ FastVector access$100(PlotPanel plotPanel) {
            return plotPanel.m_shapePoints;
        }

        static /* synthetic */ boolean access$000(PlotPanel plotPanel) {
            return plotPanel.m_createShape;
        }

        static /* synthetic */ Dimension access$200(PlotPanel plotPanel) {
            return plotPanel.m_newMousePos;
        }

        static /* synthetic */ boolean access$300(PlotPanel plotPanel, FastVector fastVector, double d, double d2) {
            return plotPanel.inPolyline(fastVector, d, d2);
        }

        static /* synthetic */ FastVector access$400(PlotPanel plotPanel) {
            return plotPanel.m_shapes;
        }

        static /* synthetic */ FastVector access$402(PlotPanel plotPanel, FastVector fastVector) {
            plotPanel.m_shapes = fastVector;
            return plotPanel.m_shapes;
        }

        static /* synthetic */ VisualizePanel access$500(PlotPanel plotPanel) {
            return plotPanel.VisualizePanel.this;
        }

        static /* synthetic */ boolean access$600(PlotPanel plotPanel, double d, double d2) {
            return plotPanel.checkPoints(d, d2);
        }
    }
}

