<?php
// 
// WHLX CMS - init.php
// 
// 20040330 - 0.00 alpha
// 20040402 - 0.02 alpha    名称変更:whlx_init.php -> init.php etc. 
// 20040402 - 0.03 alpha    アイテム挿入位置を示す mark は不要と考え, コメント・アウト. 
// 20040410 - 0.04 alpha    外部ファイルの整理. ディレクトリ類は 'path.ini', へ移動. 設定類は 'whlx.ini' へ移動. 
// 20040410 - 0.05 alpha    XML/XSLT 形式の出力に変更. それに伴い, '_script.xsl' を作成し, XSLTファイルとして之を指定する. 
// 




error_reporting( E_ERROR | E_PARSE );


$error   =  1;
$message =  'FAILED    : 初期化に失敗しました. ';
$others  =  '';


// './path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// './path.ini' はスクリプトと同じディレクトリに置く必要があります. 
$whlx =  parse_ini_file( './path.ini',      true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 


$result =  WHLX_Initializer( $error, $message, $others, $whlx );

$others =  
	'		<title> WHLX CMS - 初期化スクリプト </title> '.                          "\n".    
	'		<form password="yes"> '.                                                 "\n".    
	'			<action >'.  $whlx[ 'script' ][ 'initialize' ].  '</action > '.  "\n".    
	'		</form> '.                                                               "\n";    

$output =  WHLX_PostingResponse( $error, $message, $others, './_script.xsl' );


WHLX_ResponseHeader_XML ();
echo  $output;


exit;








function  WHLX_Initializer( &$error, &$message, &$others, $data )
{
	// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
	// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
	// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
	$formclass =  new WHLX_Formdata();     
	$form      =  $formclass->form  ();    
	$header    =  $formclass->header();    

	// function WHLX_PasswordChecker は './utilities.php' の中で記述されている補助関数です. 
	if( !WHLX_PasswordChecker( $form[ 'password' ], $data[ 'owner' ][ 'password' ] ) ) return false;

	WHLX_Initializer_ListCategories  ( $data );
	WHLX_Initializer_ListArticles    ( $data );
	WHLX_Initializer_ListComments    ( $data );
	WHLX_Initializer_ListTrackbacks  ( $data );
	WHLX_Initializer_InitialCategory ( $data );
	WHLX_Initializer_InitialArticle  ( $data );
	WHLX_Initializer_ListContents    ( $data );
	WHLX_Initializer_ListInformations( $data );
	WHLX_Initializer_ListOthers      ( $data );

	$error   =  0;
	$message =  'SUCCEEDED : 初期化に成功しました. ';
	$others  =  '';

	return true;
}




function  WHLX_Initializer_ListCategories  ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'categories'   ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'      , '' );    
	$categories =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'categories', '' );    
	$item       =  WHLX_DomXML_CreateChild  ( $dom, $categories, 'item'      , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_ListCategories  series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_ListCategories  title_short ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'id'      , 'WHLX_Initializer_ListCategories  id          ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'resource', 'WHLX_Initializer_ListCategories  ini_resource' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'title'   , 'WHLX_Initializer_ListCategories  ini_title   ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><'                                           , ">\r\n<"                                   , $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  series      ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  category    ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  title_short ', $ini[ 'title' ][ 'categories' ]            , $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  id          ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  ini_resource', $ini[ 'initial_category' ][ 'url'         ], $output );
	$output =  str_replace( 'WHLX_Initializer_ListCategories  ini_title   ', $ini[ 'initial_category' ][ 'title_short' ], $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'categories'   ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListArticles    ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'articles'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'      , '' );    
	$articles   =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'articles'  , '' );    
	$item       =  WHLX_DomXML_CreateChild  ( $dom, $articles  , 'item'      , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_ListArticles    series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_ListArticles    title_short ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'id'      , 'WHLX_Initializer_ListArticles    id          ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'resource', 'WHLX_Initializer_ListArticles    ini_resource' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'title'   , 'WHLX_Initializer_ListArticles    ini_title   ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><'                                           , ">\r\n<"                                   , $output );
	$output =  str_replace( 'WHLX_Initializer_ListArticles    series      ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListArticles    title_short ', $ini[ 'title' ][ 'articles'   ]            , $output );
	$output =  str_replace( 'WHLX_Initializer_ListArticles    id          ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListArticles    ini_resource', $ini[ 'initial_article'  ][ 'url'         ], $output );
	$output =  str_replace( 'WHLX_Initializer_ListArticles    ini_title   ', $ini[ 'initial_article'  ][ 'title_short' ], $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'articles'    ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListComments    ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'comments'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'         , '' );    
	$comments   =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'comments'     , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_ListComments    series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_ListComments    title_short ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><'                                           , ">\r\n<"                                   , $output );
	$output =  str_replace( 'WHLX_Initializer_ListComments    series      ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListComments    title_short ', $ini[ 'title' ][ 'comments'   ]            , $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'comments'    ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListTrackbacks  ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'trackbacks'   ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'         , '' );    
	$trackbacks =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'trackbacks'   , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_ListTrackbacks  series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_ListTrackbacks  title_short ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><'                                           , ">\r\n<"                                   , $output );
	$output =  str_replace( 'WHLX_Initializer_ListTrackbacks  series      ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_ListTrackbacks  title_short ', $ini[ 'title' ][ 'trackbacks' ]            , $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'trackbacks'  ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_InitialCategory ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'cat_0001'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'         , '' );    
	$category   =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'category'     , '' );    
	$item       =  WHLX_DomXML_CreateChild  ( $dom, $category  , 'item'         , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_InitialCategory series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_InitialCategory title_short ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'id'      , 'WHLX_Initializer_InitialCategory id          ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'resource', 'WHLX_Initializer_InitialCategory ini_resource' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'title'   , 'WHLX_Initializer_InitialCategory ini_title   ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><'                                           , ">\r\n<"                                   , $output );
	$output =  str_replace( 'WHLX_Initializer_InitialCategory series      ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_InitialCategory title_short ', $ini[ 'initial_category' ][ 'title_short' ], $output );
	$output =  str_replace( 'WHLX_Initializer_InitialCategory id          ', '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_InitialCategory ini_resource', $ini[ 'initial_article'  ][ 'title_short' ], $output );
	$output =  str_replace( 'WHLX_Initializer_InitialCategory ini_title   ', $ini[ 'title' ][ 'art_0001'   ]            , $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'cat_0001'    ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_InitialArticle  ( $ini )
{
	$dom        =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi         =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'art_0001'     ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx       =  WHLX_DomXML_CreateChild  ( $dom, $dom       , 'whlx'         , '' );    
	$items      =  WHLX_DomXML_CreateChild  ( $dom, $whlx      , 'items'        , '' );    
	$item       =  WHLX_DomXML_CreateChild  ( $dom, $items     , 'item'         , '' );    
	$title      =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'title    '    , '' );    
	$url        =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'url      '    , '' );    
	$text       =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'text     '    , '' );    
	$creator    =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'creator  '    , '' );    
	$date       =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'date     '    , '' );    
	$trackback  =  WHLX_DomXML_CreateChild  ( $dom, $item      , 'trackback'    , '' );    

	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'series'  , 'WHLX_Initializer_InitialArticle  series      ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'category', 'WHLX_Initializer_InitialArticle  category    ' );    
	WHLX_DomXML_CreateAttribute( $dom, $whlx, 'title'   , 'WHLX_Initializer_InitialArticle  title_short ' );    
	WHLX_DomXML_CreateAttribute( $dom, $item, 'id'      , 'WHLX_Initializer_InitialArticle  id          ' );    
	WHLX_DomXML_CreateComment  ( $dom, $title    , ' WHLX_Initializer_InitialArticle  title     ' );    
	WHLX_DomXML_CreateComment  ( $dom, $url      , ' WHLX_Initializer_InitialArticle  url       ' );    
	WHLX_DomXML_CreateComment  ( $dom, $text     , ' WHLX_Initializer_InitialArticle  text      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $creator  , ' WHLX_Initializer_InitialArticle  creator   ' );    
	WHLX_DomXML_CreateComment  ( $dom, $date     , ' WHLX_Initializer_InitialArticle  date      ' );    
	WHLX_DomXML_CreateComment  ( $dom, $trackback, ' WHLX_Initializer_InitialArticle  trackback ' );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );
	$output =  str_replace( 'WHLX_Initializer_InitialArticle  series      '      , '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_InitialArticle  category    '      , '0001'                                     , $output );
	$output =  str_replace( 'WHLX_Initializer_InitialArticle  title_short '      , $ini[ 'initial_article'  ][ 'title_short' ], $output );
	$output =  str_replace( 'WHLX_Initializer_InitialArticle  id          '      , '0001'                                     , $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  title     -->', $ini[ 'initial_article'  ][ 'title'       ], $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  url       -->', $ini[ 'initial_article'  ][ 'url'         ], $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  text      -->', $ini[ 'initial_article'  ][ 'text'        ], $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  creator   -->', $ini[ 'initial_article'  ][ 'creator'     ], $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  date      -->', WHLX_DateTimeString()                      , $output );
	$output =  str_replace( '<!-- WHLX_Initializer_InitialArticle  trackback -->', $ini[ 'initial_article'  ][ 'trackback'   ], $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'art_0001'    ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListContents    ( $ini )
{
	$dom             =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi              =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'contents' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx            =  WHLX_DomXML_CreateChild  ( $dom, $dom     , 'whlx'    , '' );    $whlx        ->set_attribute( 'series', '0001' );           $whlx        ->set_attribute( 'title', 'Contents' );    
	$contents        =  WHLX_DomXML_CreateChild  ( $dom, $whlx    , 'contents', '' );    
	$Index           =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Index       ->set_attribute( 'title', "Index"        );    $Index       ->set_attribute( 'resource', "./index.xml"        );    
	$Recents         =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Recents     ->set_attribute( 'title', "Recents"      );    $Recents     ->set_attribute( 'resource', "./recents.xml"      );    
	$Excerpts        =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Excerpts    ->set_attribute( 'title', "Excerpts"     );    $Excerpts    ->set_attribute( 'resource', "./excerpts.xml"     );    
	$Contents        =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Contents    ->set_attribute( 'title', "Contents"     );    $Contents    ->set_attribute( 'resource', "./contents.xml"     );    
	$Informations    =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Informations->set_attribute( 'title', "Informations" );    $Informations->set_attribute( 'resource', "./informations.xml" );    
	$Categories      =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Categories  ->set_attribute( 'title', "Categories"   );    $Categories  ->set_attribute( 'resource', "./categories.xml"   );    
	$Articles        =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Articles    ->set_attribute( 'title', "Articles"     );    $Articles    ->set_attribute( 'resource', "./articles.xml"     );    
	$Comments        =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Comments    ->set_attribute( 'title', "Comments"     );    $Comments    ->set_attribute( 'resource', "./comments.xml"     );    
	$Trackbacks      =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Trackbacks  ->set_attribute( 'title', "Trackbacks"   );    $Trackbacks  ->set_attribute( 'resource', "./trackbacks.xml"   );    
	$Initialize      =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Initialize  ->set_attribute( 'title', "初期化"       );    $Initialize  ->set_attribute( 'resource', "./script/init.php"  );    
	$NewArticle      =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $NewArticle  ->set_attribute( 'title', "新規投稿"     );    $NewArticle  ->set_attribute( 'resource', "./script/new.php"   );    
	$Trackback       =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Trackback   ->set_attribute( 'title', "返事"         );    $Trackback   ->set_attribute( 'resource', "./script/tb.php"    );    
	$Edit            =  WHLX_DomXML_CreateChild  ( $dom, $contents, 'item'    , '' );    $Edit        ->set_attribute( 'title', "編集"         );    $Edit        ->set_attribute( 'resource', "./script/edit.php"  );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'contents' ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListInformations( $ini )
{
	$dom         =  WHLX_DomXML_NewDocument  ( WHLX_XML_VERSION );    
	$pi          =  WHLX_DomXML_RegisterXSLT ( $dom, $ini[ 'xslt' ][ 'informations' ], WHLX_XML_VERSION, 'text/xsl', 'UTF-8' );
	$whlx        =  WHLX_DomXML_CreateChild  ( $dom, $dom , 'whlx'        , '' );    $whlx       ->set_attribute( 'series', '0001' );    $whlx       ->set_attribute( 'title', 'サイトの情報 etc.' );    
	$info        =  WHLX_DomXML_CreateChild  ( $dom, $whlx, 'informations', '' );    
	$title       =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $title      ->set_attribute( 'id',     '0001' );    $title      ->set_attribute( 'title', 'title'             );    $title      ->set_attribute( 'value', $ini[ 'informations'  ][ 'title'       ]  );    
	$link        =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $link       ->set_attribute( 'id',     '0002' );    $link       ->set_attribute( 'title', 'link'              );    $link       ->set_attribute( 'value', $ini[ 'informations'  ][ 'link'        ]  );    
	$description =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $description->set_attribute( 'id',     '0003' );    $description->set_attribute( 'title', 'description'       );    $description->set_attribute( 'value', $ini[ 'informations'  ][ 'description' ]  );    
	$date        =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $date       ->set_attribute( 'id',     '0004' );    $date       ->set_attribute( 'title', 'date'              );    $date       ->set_attribute( 'value', WHLX_DateTimeString()                     );    
	$creator     =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $creator    ->set_attribute( 'id',     '0005' );    $creator    ->set_attribute( 'title', 'creator'           );    $creator    ->set_attribute( 'value', $ini[ 'informations'  ][ 'creator'     ]  );    
	$publisher   =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $publisher  ->set_attribute( 'id',     '0006' );    $publisher  ->set_attribute( 'title', 'publisher'         );    $publisher  ->set_attribute( 'value', $ini[ 'informations'  ][ 'publisher'   ]  );    
	$rights      =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $rights     ->set_attribute( 'id',     '0007' );    $rights     ->set_attribute( 'title', 'rights'            );    $rights     ->set_attribute( 'value', $ini[ 'informations'  ][ 'rights'      ]  );    
	$language    =  WHLX_DomXML_CreateChild  ( $dom, $info, 'item'        , '' );    $language   ->set_attribute( 'id',     '0008' );    $language   ->set_attribute( 'title', 'language'          );    $language   ->set_attribute( 'value', $ini[ 'informations'  ][ 'language'    ]  );    

	$output =  $dom->dumpmem();
	$output =  str_replace( '><', ">\r\n<", $output );

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'informations' ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListOthers      ( $ini )
{
	$filedata_index    =  '<?xml version="1.0" encoding="UTF-8"?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'index'    ].  '"?> '.  "\r\n".  '<whlx title="Index">          '.  "\r\n".  '<index />    '.  '</whlx> ';
	$filedata_recents  =  '<?xml version="1.0" encoding="UTF-8"?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'recents'  ].  '"?> '.  "\r\n".  '<whlx title="Recent Entries"> '.  "\r\n".  '<recents />  '.  '</whlx> ';
	$filedata_excerpts =  '<?xml version="1.0" encoding="UTF-8"?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'excerpts' ].  '"?> '.  "\r\n".  '<whlx title="Excerptions">    '.  "\r\n".  '<excerpts /> '.  '</whlx> ';
	WHLX_FileOutput( $filedata_index   , $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'index'    ], WHLX_XML_FILEMODE );
	WHLX_FileOutput( $filedata_recents , $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'recents'  ], WHLX_XML_FILEMODE );
	WHLX_FileOutput( $filedata_excerpts, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'excerpts' ], WHLX_XML_FILEMODE );
}




?>
