<?php
// 
// WHLX CMS - utilities.php
// 
// 20040330 - 0.00 alpha
// 20040402 - 0.02 alpha    名称変更:whlx_utilities.php -> utilities.php etc. 
// 20040410 - 0.03 alpha    関数 WHLX_PostingResponse, $xslt 指定/未指定時の xml-stylesheet タグ書き込み判定を追加. 
// 20040413 - 0.04 alpha    関数 WHLX_ConvertString,   文字削り関数を substr から mb_strimwidth へ変更. 
// 20040413 - 0.05 alpha    関数 WHLX_DateTimeString,  日本語曜日表示対応のため, 仕様変更. WHLX_DATETIME_FORMAT は廃止されます. 
// 20040417 - 0.06 alpha    関数 WHLX_FileExtension,   新規作成. 
// 




define( 'WHLX_PASSWORD_SEED'   , 'pw'                          );    // パスワードはcrypt化して保存されます. 
define( 'WHLX_DATETIME_FORMAT' , "Y年 m月 d日 (l) H時 i分 s秒" );    // 例 : "2004年 01月 01日 (Thursday) 01時 02分 03秒"
define( 'WHLX_TIMEZONE_GMT'    , ( +  0 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_EUROPAW', ( +  0 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_EUROPAC', ( +  1 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_EUROPAE', ( +  2 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_JAPAN'  , ( +  9 ) * 60 * 60            );    // (GMT +0900) 日本時間です. 単位は second. 
define( 'WHLX_TIMEZONE_USAPST' , ( -  8 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_USAMST' , ( -  7 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_USACST' , ( -  6 ) * 60 * 60            );    // 
define( 'WHLX_TIMEZONE_USAEST' , ( -  5 ) * 60 * 60            );    // 
define( 'WHLX_GMT_DIFFERENCE'  , WHLX_TIMEZONE_JAPAN           );    // 




function  WHLX_PasswordChecker( $text, $pw )
{
	if( crypt( $text, WHLX_PASSWORD_SEED ) == $pw ) return true;     
	else                                            return false;    
}




function  WHLX_DateTimeString()
{
	define( 'WHLX_DATE_FORMAT', "Y年 m月 d日 " );
	define( 'WHLX_TIME_FORMAT', " H時 i分 s秒" );
	$week_array =  array( "(日)", "(月)", "(火)", "(水)", "(木)", "(金)", "(土)" );

	$datetime =  time() + WHLX_GMT_DIFFERENCE;
	$date     =  gmdate( WHLX_DATE_FORMAT, $datetime );
	$week     =  gmdate( 'w',              $datetime );
	$time     =  gmdate( WHLX_TIME_FORMAT, $datetime );
	return $date. $week_array[ $week ]. $time;

//	return gmdate( WHLX_DATETIME_FORMAT, time() + WHLX_GMT_DIFFERENCE );
}




function  WHLX_PostingResponse( $error, $message, $others, $xslt )
{
	if( $xslt != '' || $xslt != null ) $pi =  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $xslt.  '"?> '.  "\r\n";    
	else                               $pi =  '';    

	return 
		'<?xml version="1.0" encoding="UTF-8"?> '.            "\n".    
		$pi.                                                  "\n".    
		'<response> '.                                        "\n".    
		'	<error>'.      $error  .    '</error>   '.    "\n".    
		'	<message>'.    $message.    '</message> '.    "\n".    
		'	<others>'.     $others .    '</others>  '.    "\n".    
		'</response> '.                                       "\n".    
		"\n";    
}




function  WHLX_Form_HTML( $title, $action, $array )
{
	$text =  '';
	foreach( $array as $data )
	{
		$text .= "\t\t\t\t".  '<label> '.  $data[ 'label' ].  ' <input type="'.  $data[ 'type' ].  '" name="'.  $data[ 'name' ].  '" value="'.  $data[ 'value' ].  '" /> </label> <br /> '.  "\r\n";  
	}

	return 
		'<?xml version="1.0" encoding="UTF-8"?> '.                                                                                     "\r\n".  
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> '.              "\r\n".  
		'<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja"> '.                                                        "\r\n".  
		'	<head> '.                                                                                                              "\r\n".  
		'		<title> '.  $title.  ' </title> '.                                                                             "\r\n".  
		'		<meta http-equiv="Content-Type"     content="text/html; charset=UTF-8" /> '.                                   "\r\n".  
		'		<meta http-equiv="Content-Language" content="ja"                       /> '.                                   "\r\n".  
		'	</head> '.                                                                                                             "\r\n".  
		'	<body> '.                                                                                                              "\r\n".  
		'		<div> '.                                                                                                       "\r\n".  
		'			<form lang="ja" accept-charset="UTF-8" action="'.  $action.  '" method="post" accept="text/plain"> '.  "\r\n".  
		'				<h1> '.  $title.  ' </h1> '.                                                                   "\r\n".  
		$text.  
		'			</form> '.                                                                                             "\r\n".  
		'		</div> '.                                                                                                      "\r\n".  
		'	</body> '.                                                                                                             "\r\n".  
		'</html> '.                                                                                                                    "\r\n";  
}




function  WHLX_ResponseHeader_XML ()
{
	header( "Cache-Control:    no-cache                       \r\n" );    
	header( "Pragma:           no-cache                       \r\n" );    
	header( "Content-Type:     application/xml; charset=UTF-8 \r\n" );    
	header( "Content-Language: ja                             \r\n" );    
	return true;
}




function  WHLX_ResponseHeader_HTML()
{
	header( "Cache-Control:    no-cache                       \r\n" );    
	header( "Pragma:           no-cache                       \r\n" );    
	header( "Content-Type:     text/html;       charset=UTF-8 \r\n" );    
	header( "Content-Language: ja                             \r\n" );    
	return true;
}




function  WHLX_FileOutput( $data, $name, $mode )
{
	if( $name == '' || $name == null || $mode == null ) return false;

	$handle =  fopen( $name, 'w+' );
	if( !$handle ) return false;

	if( flock( $handle, LOCK_EX ) )
	{
		fwrite( $handle, $data );
		flock ( $handle, LOCK_UN );
	}
	fclose( $handle );
	chmod( $name, $mode );

	return true;
}




function  WHLX_ConvertString( $input, $flags, $length )
{
	$output =  $input;

	$output =  mb_convert_encoding  ( $output, 'UTF-8', 'auto' ); 

	// 制限長から 3文字削って '...' を加えます. 
	// 制限長 0 は無制限の意味です. 
	if( $length != 0 )
	{
		$output =  mb_strimwidth( $output, 0, $length, '...', 'UTF-8' );
	//	if( mb_strwidth( $output ) > $length ) $output =  mb_strcut( $output, 0, $length - 3 ). '...';
	//	if( mb_strlen  ( $output ) > $length ) $output =  mb_strcut( $output, 0, $length - 3 ). '...';
	//	if( strlen     ( $output ) > $length ) $output =  mb_strcut( $output, 0, $length - 3 ). '...';
	}


//	$output =  strip_tags  ( $output ); 
	$output =  stripslashes( $output ); 

	if( $flags &  0x0001 )  $output =  str_replace( '&'   , '&amp;'   , $output );      // &       -> &amp;  変換
	if( $flags &  0x0002 )  $output =  str_replace( '"'   , '&quot;'  , $output );      // "       -> &quot; 変換
	if( $flags &  0x0004 )  $output =  str_replace( '<'   , '&lt;'    , $output );      // <       -> &lt;   変換
	if( $flags &  0x0008 )  $output =  str_replace( '>'   , '&gt;'    , $output );      // >       -> &gt;   変換
	if( $flags &  0x0010 )  $output =  str_replace( "\0"  , ' '       , $output );      // 0       -> ' '    変換
	if( $flags &  0x0020 ){ $output =  str_replace( "\r\n", ' <br /> ', $output );      // 改行    -> <br /> 変換
		                $output =  str_replace( "\r"  , ' <br /> ', $output );      // 改行    -> <br /> 変換
		                $output =  str_replace( "\n"  , ' <br /> ', $output ); }    // 改行    -> <br /> 変換
	else                  { $output =  str_replace( "\r"  , ' '       , $output );      // 改行    -> ' '    変換
		                $output =  str_replace( "\n"  , ' '       , $output ); }    // 改行    -> ' '    変換
	if( $flags &  0x0040 )  $output =  str_replace( '  '  , ' '       , $output );      // ' ' x 2 -> ' '    変換

	return $output;
}




function  WHLX_FileExtension( $filename )
{
	$buffer    =  $filename;
	while( $buffer )
	{
		$extension =  $buffer;
		$buffer    =  substr( strstr( $extension, '.' ), 1 );
	}
	return  '.'.  $extension;
}




?>
