<?php
// 
// WHLX CMS - new.php 
// 
// 20040403 - 0.00 alpha
// 20040411 - 0.04 alpha    外部ファイルの整理. ディレクトリ類は 'path.ini', へ移動. 設定類は 'whlx.ini' へ移動. 
// 20040413 - 0.05 alpha    文字列変換( '><' -> ">\r\n<" )の順番を修正. 
// 20040413 - 0.06 alpha    whlx.ini の仕様変更に伴う少々の変更. 
// 20040417 - 0.09 alpha    大幅な変更. 多くの関数を ライブラリ 'postingxml.php' へ移動. 
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_Main( $error, $message, $others, $whlx, $form );
// // 
function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'new_article' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attribute[ 'lang'    ] =  'ja';

	// フォームを使って送信された文字列の中の「HTMLタグ」「改行コード」を変換します. 
	// フォームを使って送信された文字列の文字数を制限します. 
	// 関数 WHLX_DateTimeString は './utility.php' の中で記述されている補助関数です. 
	// 関数 WHLX_ConvertString  は './utility.php' の中で記述されている補助関数です. 
	// この部分はスクリプトの種類によって変化します. 
	$form[ 'date'        ] =  WHLX_DateTimeString();                                       
	$form[ 'title'       ] =  WHLX_ConvertString( $form[ 'title'     ], 0x007F,   64 );    
	$form[ 'text'        ] =  WHLX_ConvertString( $form[ 'text'      ], 0x0070, 4096 );    
	$form[ 'creator'     ] =  WHLX_ConvertString( $form[ 'creator'   ], 0x007F,   64 );    
	$form[ 'title_short' ] =  WHLX_ConvertString( $form[ 'title'     ], 0x007F,   16 );    
	$form[ 'ping'        ] =  ' ';
	$form[ 'category'    ] =  '0001';
	$form[ 'pw_crypt'    ] =  $whlx[ 'owner' ][ 'password' ];
	$form[ 'xslt'        ] =  './_default.xsl';                                                                          // 


	$result =  true;    // 

	while( $result )
	{
		// フォームを使って送信された文字列が空でないかどうか, パスワードを間違えてないかどうか, etc. を調べます. 
		$result =  WHLX_PostingXML_DataChecker_Article  ( $error, $message, $form );    
		if( true != $result ) break;    // return false;


		// 新しい記事を投稿するので, 記事ファイル中のアイテムIDは必ず '0001' になります. 
		$form[ 'new_id'       ] =  '0001';
	//	$form[ 'new_id'       ] =  WHLX_PostingXML_NextID                 ( $new_filename, 'items'   , true  );    


		// リスト・ファイル変更関係の処理はここです. 
		// リスト・ファイルに於いて使われるハイパー・リンク先を文字列 'lst_resource' を得ます. 
		// 関数 WHLX_PostingXML_NextID                  を使って, リスト・ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_List    を使って, リスト・ファイルにリスト・アイテムを追加します. 
		$lst_filename           =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'articles' ]; 
		$form[ 'lst_id'       ] =  WHLX_PostingXML_NextID                 ( $lst_filename, 'articles', false );    
		$form[ 'series'       ] =  $form[ 'lst_id' ];
		$form[ 'lst_resource' ] =  './art_'.  $form[ 'series' ].  '.xml'.  '#'.  $form[ 'new_id' ];    
		$lst_filedata           =  WHLX_PostingXML_InsertItem_Into_List   ( $lst_filename, 'articles', false, $form );    


		// カテゴリ別リスト・ファイル変更関係の処理はここです. 
		// カテゴリ別リスト・ファイルに於いて使われるハイパー・リンク先を文字列 'lst_resource' を得ます. 
		// 関数 WHLX_PostingXML_NextID                  を使って, カテゴリ別リスト・ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_List    を使って, カテゴリ別リスト・ファイルにリスト・アイテムを追加します. 
		$cat_filename           =  $whlx[ 'directory' ][ 'data' ].  './cat_'.  $form[ 'category' ].  '.xml';    
		$form[ 'cat_id'       ] =  WHLX_PostingXML_NextID                 ( $cat_filename, 'category', false );    
		$form[ 'cat_resource' ] =  $form[ 'lst_resource' ];
		$cat_filedata           =  WHLX_PostingXML_InsertItem_Into_List   ( $cat_filename, 'category', false, $form );    


		$form[ 'url'          ] =  './art_'.  $form[ 'series' ].  '.xml'.  '#'.  $form[ 'new_id' ];    
		$form[ 'trackback'    ] =  $whlx[ 'directory_url' ][ 'script' ].  $whlx[ 'script' ][ 'trackback' ].  '?'.  'id='.  $form[ 'series' ];


		// 記事ファイル変更関係の処理はここです. 
		// 記事ID $form[ 'id' ] を元に記事ファイル名 art_????.xml を判断します. 
		// 関数 WHLX_PostingXML_NextID                  を使って, 記事ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_Article を使って, 記事ファイルに記事アイテムを追加します. 
		$new_filename           =  $whlx[ 'directory' ][ 'data' ].  './art_'.  $form[ 'series' ].  '.xml';    
		$new_filedata           =  WHLX_PostingXML_Create_NewArticle      ( $new_filename, 'items'   , true , $form );    


		$result                 =  WHLX_FileOutput( $lst_filedata, $lst_filename, WHLX_XML_FILEMODE );    // 
		if( true != $result ) break;    // return false;

		$result                 =  WHLX_FileOutput( $cat_filedata, $cat_filename, WHLX_XML_FILEMODE );    // 
		if( true != $result ) break;    // return false;

		$result                 =  WHLX_FileOutput( $new_filedata, $new_filename, WHLX_XML_FILEMODE );    // 
		if( true != $result ) break;    // return false;

		break;
	}


	$script_title =  'WHLX CMS - 新規投稿スクリプト';

	$others =  "\r\n";
	$others .= "\t\t".  '<title> '.  $script_title.  ' </title> '.  "\r\n";
	$others .= "\t\t".  '<link> ' .  $new_filename.  ' </link> ' .  "\r\n";
	$others .= "\t\t".  '<form password=""> '.  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes  ( $attribute );
	$others .= WHLX_PostingXML_FormDataEntered ( $form      );
	$others .= "\t\t".  '</form> '           .  "\r\n";    
	$others .= WHLX_PostingXML_ResultPreview   ( $form      );

	return  true;
}




?>
