<?php
// 
// WHLX CMS - tb.php 
// 
// 20040416 - 0.00 alpha    
// 20040417 - 0.09 alpha    大幅な変更. 多くの関数を ライブラリ 'postingxml.php' へ移動. 
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_Main( $error, $message, $others, $whlx, $form );
// // 
function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'trackback' ];
	$attribute[ 'action'  ] .= '?'.      'id='.       $form[ 'id'      ];
	$attribute[ 'action'  ] .= '&amp;'.  'comment='.  $form[ 'comment' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attribute[ 'lang'    ] =  'ja';

	// フォームを使って送信された文字列の中の「HTMLタグ」「改行コード」を変換します. 
	// フォームを使って送信された文字列の文字数を制限します. 
	// 関数 WHLX_DateTimeString は './utility.php' の中で記述されている補助関数です. 
	// 関数 WHLX_ConvertString  は './utility.php' の中で記述されている補助関数です. 
	// この部分はスクリプトの種類によって変化します. 
	$form[ 'date'        ] =  WHLX_DateTimeString();                                       
	$form[ 'title'       ] =  WHLX_ConvertString( $form[ 'title'     ], 0x007F,   64 );    
	$form[ 'excerpt'     ] =  WHLX_ConvertString( $form[ 'excerpt'   ], 0x007F, 4096 );    
	$form[ 'blog_name'   ] =  WHLX_ConvertString( $form[ 'blog_name' ], 0x007F,   64 );    
	$form[ 'title_short' ] =  WHLX_ConvertString( $form[ 'title'     ], 0x007F,   16 );    


	$result =  true;    // 

	while( $result )
	{
		// フォームを使って送信された文字列が空でないかどうか, パスワードを間違えてないかどうか, etc. を調べます. 
		if( 'true' != $form[ 'comment' ] ) $result =  WHLX_PostingXML_DataChecker_Trackback( $error, $message, $form );    
		else                               $result =  WHLX_PostingXML_DataChecker_Comment  ( $error, $message, $form );    
	//	$result =  WHLX_PostingXML_DataChecker_Article  ( $error, $message, $form );    
	//	$result =  WHLX_PostingXML_DataChecker_Comment  ( $error, $message, $form );    
	//	$result =  WHLX_PostingXML_DataChecker_Trackback( $error, $message, $form );    
		if( true != $result ) break;    // return false;


		// $form[ 'url' ] はコメントの時は元記事のURLを入れておきます. 
		if( 'true' == $form[ 'comment' ] ) $form[ 'url' ] =  './art_'.  $form[ 'id' ].  '.xml';


		// 記事ファイル変更関係の処理はここです. 
		// 記事ID $form[ 'id' ] を元に記事ファイル名 art_????.xml を判断します. 
		// 関数 WHLX_PostingXML_NextID                  を使って, 記事ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_Article を使って, 記事ファイルに記事アイテムを追加します. 
		$new_filename           =  $whlx[ 'directory' ][ 'data' ].  './art_'.  $form[ 'id' ].  '.xml';    
		$form[ 'new_id'       ] =  WHLX_PostingXML_NextID                 ( $new_filename, 'items',  true  );    
		$new_filedata           =  WHLX_PostingXML_InsertItem_Into_Article( $new_filename, 'items',  true , $form );    


		// リスト・ファイル変更関係の処理はここです. 
		// 追記する対象のリスト・ファイルが comment.xml なのか trackbacks.xml なのかを判断します. 
		// リスト・ファイルに於いて使われるハイパー・リンク先を文字列 'lst_resource' を得ます. 
		// 関数 WHLX_PostingXML_NextID                  を使って, リスト・ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_List    を使って, リスト・ファイルにリスト・アイテムを追加します. 
		if( 'true' != $form[ 'comment' ] ){ $listtag =  'trackbacks';    $lst_filename =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'trackbacks' ]; }    // Trackback
		else                              { $listtag =  'comments';      $lst_filename =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'comments'   ]; }    // Comment
		$form[ 'lst_resource' ] =  './art_'.  $form[ 'id' ].  '.xml'.  '#'.  $form[ 'new_id' ];    
		$form[ 'lst_id'       ] =  WHLX_PostingXML_NextID                 ( $lst_filename, $listtag, false );    
		$lst_filedata           =  WHLX_PostingXML_InsertItem_Into_List   ( $lst_filename, $listtag, false, $form );    


		$result                 =  WHLX_FileOutput( $new_filedata, $new_filename, WHLX_XML_FILEMODE );    // 
		if( true != $result ) break;    // return false;

		$result                 =  WHLX_FileOutput( $lst_filedata, $lst_filename, WHLX_XML_FILEMODE );    // 
		if( true != $result ) break;    // return false;

		break;
	}


	$script_title =  'WHLX CMS - Trackback 受信スクリプト';

	$others =  "\r\n";
	$others .= "\t\t".  '<title> '.  $script_title.  ' </title> '.  "\r\n";
	$others .= "\t\t".  '<link> ' .  $new_filename.  ' </link> ' .  "\r\n";
	$others .= "\t\t".  '<form> ' .  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes ( $attribute );
	$others .= WHLX_PostingXML_FormDataEntered( $form      );
	$others .= "\t\t".  '</form> '.  "\r\n";    
	$others .= WHLX_PostingXML_ResultPreview  ( $form      );

	return  true;
}




?>
