<?php
// 
// WHLX CMS - domxml_node.php
// 
// 20040505 - 0.00 alpha    
// 20040509 - 0.01 alpha    WHLX_DomXML_Node    メンバー変数 $parent はエラーが出易いので, 廃止. 
// 20040509 - 0.02 alpha    WHLX_DomXML_Comment 出力方法を整理. Dump1() Dump2() に分割. 
// 20040510 - 0.03 alpha    WHLX_DomXML_Node    登録系 メンバ関数 を追加・整理. 
// 20040510 - 0.04 alpha    WHLX_DomXML_Node    取得系 メンバ関数 を追加・整理. 
// 20040510 - 0.05 alpha    WHLX_DomXML_Node    出力系 メンバ関数 を追加・整理. 
// 




class  WHLX_DomXML_Node
{
	var $rank       =  0;          // 階層
	var $element    =  '';         // タグ : tagname
	var $attributes =  array();    // 属性 : attribute="" attribute="" ...
	var $content    =  '';         // 内容 : <tagname>????</tagname> 

	var $children   =  array();    // $children は WHLX_DomXML_Node の配列

	function  WHLX_DomXML_Node    ( $element, $attributes, $content )
	{
		$this->element    =  $element;
		$this->attributes =  $attributes;
		$this->content    =  $content;
	}

	// メンバ関数 登録系
	function  Attribute  ( $att, $value ){ $this->attributes[ $att ] =  $value; }
	function  Register   ( &$node )      { $node->rank =  $this->rank + 1;    array_push( $this->children, &$node );                                                                                                  reset( $this->children ); }
	function  Unregister ( &$node )      { $node->rank =  0;                  for( $i =  0; $i <  count( $this->children ); $i++ ){ if( $this->children[ $i ] == $node ) array_splice( $this->children, $i, 1 ); }    reset( $this->children ); }

	// メンバ関数 登録系(挿入)
	function  Insert     ( $id, &$node )  
	{
		$node->rank =  $this->rank + 1;
		reset( $this->children );

		if     ( $id == 0 )
		{
			array_unshift( $this->children, &$node );
		}
		else if( $id < $this->Child_Count() )
		{
			$array_prev      =  array_slice( $this->children, 0,  $id );
			$array_next      =  array_slice( $this->children, $id );
			$this->$children =  array_merge( $array_prev, &$node, $array_next );
		}
		else
		{
			array_push( $this->children, &$node );
		}

		reset( $this->children );
	}

	// メンバ関数 取得系
	function  Child      ( $i ){ if( !is_array( $this->children ) ) return null;    return $this->children[ $i ];    }
	function  Child_Count()    { if( !is_array( $this->children ) ) return null;    return count( $this->children ); }
	function  Child_First()    { if( !is_array( $this->children ) ) return null;    return $this->children[ 0                            ]; }
	function  Child_Last ()    { if( !is_array( $this->children ) ) return null;    return $this->children[ count( $this->children ) - 1 ]; }

	function  Dump       ()
	{
		$output     =  '';
		$indent     =  '';        for( $i =  0; $i + 1 < $this->rank; $i++ ) $indent .= "\t";
		$crlf       =  "\r\n";

		$element    =  $this->Dump_Element   ();
		$attributes =  $this->Dump_Attributes();
		$content    =  $this->Dump_Content   ();
		$children   =  $this->Dump_Children  ();

		/* 要素 内容 子供 */    //  // 要素の有無,        // 内容の有無,        // 子ノードの有無
		/*  ×   ×   ×  */    if( ( $element == '' ) && ( $content == '' ) && ( $children == '' ) ){                                                                                                                                                                     }
		/*  ×   ×   ●  */    if( ( $element == '' ) && ( $content == '' ) && ( $children != '' ) ){ $output =                                                                                                  $children;                                               }
		/*  ×   ●   ×  */    if( ( $element == '' ) && ( $content != '' ) && ( $children == '' ) ){ $output =                                                                               $content;                                                                   }
		/*  ×   ●   ●  */    if( ( $element == '' ) && ( $content != '' ) && ( $children != '' ) ){ $output =                                                              $indent.  "\t".  $content.  $crlf.  $children;                                               }
		/*  ●   ×   ×  */    if( ( $element != '' ) && ( $content == '' ) && ( $children == '' ) ){ $output =  $indent.  '<'.  $element.  $attributes.  ' /> '.  $crlf;                                                                                                 }
		/*  ●   ×   ●  */    if( ( $element != '' ) && ( $content == '' ) && ( $children != '' ) ){ $output =  $indent.  '<'.  $element.  $attributes.  '> '  .                                        $crlf.  $children.     $indent.  '</'.  $element.  '> '.  $crlf; }
		/*  ●   ●   ×  */    if( ( $element != '' ) && ( $content != '' ) && ( $children == '' ) ){ $output =  $indent.  '<'.  $element.  $attributes.  '> '  .                             $content.                                   '</'.  $element.  '> '.  $crlf; }
		/*  ●   ●   ●  */    if( ( $element != '' ) && ( $content != '' ) && ( $children != '' ) ){ $output =  $indent.  '<'.  $element.  $attributes.  '> '  .            $indent.  "\t".  $content.  $crlf.  $children.     $indent.  '</'.  $element.  '> '.  $crlf; }

		return $output;
	}

	function  Dump_Element   ()
	{
		if( !is_string( $this->element    )  ) return '';
		if( strlen( $this->element    ) == 0 ) return '';
		$output =  $this->element;
		return $output;
	}

	function  Dump_Attributes()
	{
		if( !is_array ( $this->attributes )  ) return '';
		if( count ( $this->attributes ) == 0 ) return '';
		$output =  '';
		reset( $this->attributes );
		while( list( $key, $val ) =  each( $this->attributes ) ) $output .= ' '.  $key.  '="'.  $val.  '"';
		return $output;
	}

	function  Dump_Content   ()
	{
		if( !is_string( $this->content    )  ) return '';
		if( strlen( $this->content    ) == 0 ) return '';
		$output =  $this->content;
		return $output;
	}

	function  Dump_Children  ()
	{
		if( !is_array ( $this->children   )  ) return '';
		if( count ( $this->children   ) == 0 ) return '';
		$output   =  '';
		foreach( $this->children as $child ){ $output .= $child->Dump(); }
		return $output;
	}

}




class  WHLX_DomXML_PI       extends WHLX_DomXML_Node
{
	function  WHLX_DomXML_PI      ( $pi, $att ){ $this->element =  $pi;      $this->attributes =  $att; $this->content =  ''; }
	function  Dump                ()           { return '<?'. $this->Dump_Element(). $this->Dump_Attributes(). '?> '. "\r\n"; }
}




class  WHLX_DomXML_Comment  extends WHLX_DomXML_Node
{
	function  WHLX_DomXML_Comment ( $comment ) { $this->element =  $comment; $this->attributes =  null; $this->content =  ''; }
	function  Dump1               ()           { return '<!--'. $this->Dump_Element(). '--> ';         }
	function  Dump2               ()           { return '<!--'. $this->Dump_Element(). '--> '. "\r\n"; }
	function  Dump                ()
	{
		if( $this->rank <= 1 ) return $this->Dump2();
		else                   return $this->Dump1();
	}
}




class  WHLX_DomXML_Text     extends WHLX_DomXML_Node
{
	function  WHLX_DomXML_Text    ( $text )    { $this->element =  $text;    $this->attributes =  null; $this->content =  ''; }
	function  Dump                ()
	{
		$indent     =  '';        for( $i =  0; $i < $this->rank - 1; $i++ ) $indent .= "\t";
		$crlf       =  "\r\n";

		return  $indent. $this->Dump_Element(). $crlf;
	}
}




?>
