<?php
// 
// WHLX CMS - edit.php
// 
// 20040422 - 0.00 alpha    
// 20040511 - 0.01 alpha    文字列の整形ルーチンを追加. 
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_node.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_document.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

define( 'WHLX_SCRIPT_TITLE', 'WHLX CMS - 直接編集スクリプト' );    // 

// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


// ファイルを選択しているかどうかでスクリプトの動作が完全に異なります. 
// (本当はこういう書き方を避けたいのですが, 今の所これ以外に方法はありません)
$new_filename   =  $whlx[ 'directory' ][ 'data' ].  $data[ 'fileselect' ];
if( is_file( $new_filename ) ) WHLX_Edit  ( $error, $message, $others, $whlx, $data );
else                           WHLX_Select( $error, $message, $others, $whlx, $data );


exit;








function  WHLX_Edit  ( &$error, &$message, &$others, $whlx, $form )
{
	$file         =  $form[ 'fileselect' ];
	$script       =  $whlx[ 'script' ][ 'edit' ];
	$text         =  stripslashes( $form[ 'text' ] );

	$error        =  0;
	$message      =  '';


	$new_filename =  $whlx[ 'directory' ][ 'data' ].  $form[ 'fileselect' ];

	// ファイルの読み込み. 
	if( ( $text == '' ) && ( is_file( $new_filename ) ) )
	{
		$array =  file( $new_filename );
		foreach( $array as $data ) $text .= $data;
	}
	else
	{
	//	$error   |= 1;
	//	$message .= "\t\t\t".  'ERROR     : ファイル名 が不正です.  <br /> '.  "\r\n";
	}

	// ファイルの書き込み. 
	if( WHLX_PasswordChecker( $form[ 'password' ], $whlx[ 'owner' ][ 'password' ] ) )
	{
		WHLX_FileOutput( $text, $new_filename, WHLX_XML_FILEMODE );
	}
	else
	{
		$error   |= 1;
		$message .= "\t\t\t".  'ERROR     : パスワード が不正です.  <br /> '.  "\r\n";
	}

	// エラー情報
	if( $error != 0 ) $message =  
		"\t\t\t".  '<h2> Failed    </h2> '.  "\r\n".  
		$message.  
		"\t\t\t".  '<br />'.  
		"\t\t\t".  'FAILED    : 書き込みに失敗しました. <br /> '.  "\r\n";
	else              $message =  
		"\t\t\t".  '<h2> Succeeded </h2> '.  "\r\n".  
		$message.  
		"\t\t\t".  '<br />'.  
		"\t\t\t".  'SUCCEEDED : 書き込みに成功しました. <br /> '.  "\r\n";

	// ファイル・データをHTML出力する前に, データの変換を行います. 
	// (新しくファイルを書き込む時のデータは, 変換前の元のデータを使います). 
	$text   =  str_replace( '&', '&amp;' , $text );
	$text   =  str_replace( '"', '&quot;', $text );
	$text   =  str_replace( '<', '&lt;'  , $text );
	$text   =  str_replace( '>', '&gt;'  , $text );

	$output =  
		'<?xml version="1.0" encoding="UTF-8"?> '.                                                                                                                                                       "\r\n".  
		'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> '.                                                                                "\r\n".  
		'<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja"> '.                                                                                                                          "\r\n".  
		'	<head> '.                                                                                                                                                                                "\r\n".  
		'		<title> '.  WHLX_SCRIPT_TITLE.  ' </title> '.                                                                                                                                    "\r\n".  
		'		<meta http-equiv="Content-Type"        content="text/html; charset=UTF-8" /> '.                                                                                                  "\r\n".  
		'		<meta http-equiv="Content-Language"    content="ja"                       /> '.                                                                                                  "\r\n".  
		'		<link rel="stylesheet" type="text/css" href="./_script.css" /> '.                                                                                                                "\r\n".  
		'		<style type="text/css"> <!-- '.                                                                                                                                                  "\r\n".  
		'		.edit_base   { margin: 4px; padding: 4px; text-align:right;                                                                                               }'.                    "\r\n".  
		'		.edit_label  { margin: 0px; padding: 0px; text-align:right; font-size:16px; font-weight:600; font:family:sans-serif; width:100%;                          }'.                    "\r\n".  
		'		.edit_input  { margin: 0px; padding: 2px; text-align:left;  font-size:12px; font-weight:100; font:family:sans-serif; width: 90%; border: 1px solid  #000; }'.                    "\r\n".  
		'		--> </style> '.                                                                                                                                                                  "\r\n".  
		'	</head> '.                                                                                                                                                                               "\r\n".  
		'	<body class="whlx_base"> '.                                                                                                                                                              "\r\n".  
		'		<div class="whlx_head"> '.                                                                                                                                                       "\r\n".  
		'			<h1> '.  WHLX_SCRIPT_TITLE.  ' </h1> '.                                                                                                                                  "\r\n".  
		'		</div> '.                                                                                                                                                                        "\r\n".  
		'		<div class="note_head"> '.                                                                                                                                                       "\r\n".  
		'			<a href="../index.xml" class="note_back"> Index    </a> '.                                                                                                               "\r\n".  
		'			<a href="'.  $script      .  '" class="note_fwrd"> Script   </a> '.                                                                                                      "\r\n".  
		'			<a href="'.  $new_filename.  '" class="note_back"> New File </a> '.                                                                                                      "\r\n".  
		'		</div> '.                                                                                                                                                                        "\r\n".  
		'		<div class="note_body"> '.                                                                                                                                                       "\r\n".  
		'			<form class="edit_base" lang="ja" accept-charset="UTF-8" action="edit.php" method="post" accept="text/plain"> '.                                                         "\r\n".  
		'				<label class="edit_label"> File     <input    class="edit_input" type="text"          name="fileselect" value="'.  $file.  '" readonly="" /> </label> <br /> '.  "\r\n".  
		'				<label class="edit_label"> Data     <textarea class="edit_input" rows="30" wrap="off" name="text">'.  $text.  '</textarea>                   </label> <br /> '.  "\r\n".  
		'				<label class="edit_label"> Password <input    class="edit_input" type="password"      name="password"   value=""       />                    </label> <br /> '.  "\r\n".  
		'				<label class="edit_label"> Submit   <input    class="edit_input" type="submit"                          value="Submit" />                    </label> <br /> '.  "\r\n".  
		'			</form> '.                                                                                                                                                               "\r\n".  
		'		</div> '.                                                                                                                                                                        "\r\n".  
		'		<div class="whlx_foot"> '.                                                                                                                                                       "\r\n".  
		$message.  
		'		</div> '.                                                                                                                                                                        "\r\n".  
		'	</body> '.                                                                                                                                                                               "\r\n".  
		'</html> '.                                                                                                                                                                                      "\r\n";  

	$result =  WHLX_ResponseHeader_HTML();
	echo  $output;
}




function  WHLX_Select( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attrbutes[ 'action'  ] =  $whlx[ 'script' ][ 'edit' ];
	$attrbutes[ 'method'  ] =  'post';
	$attrbutes[ 'accept'  ] =  'text/plain';
	$attrbutes[ 'charset' ] =  'UTF-8';
	$attrbutes[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attrbutes[ 'lang'    ] =  'ja';

	// フォームを使って送信された文字列の中の「HTMLタグ」「改行コード」を変換します. 
	// フォームを使って送信された文字列の文字数を制限します. 
	// 関数 WHLX_DateTimeString は './utility.php' の中で記述されている補助関数です. 
	// 関数 WHLX_ConvertString  は './utility.php' の中で記述されている補助関数です. 
	// この部分はスクリプトの種類によって変化します. 
	$form[ 'pw_crypt' ] =  $whlx[ 'owner' ][ 'password' ];
	$form[ 'xslt'     ] =  './_default.xsl';                                                                          // 


	// ファイル名をリスト化する部分です
	// 
	// まず最初にデータ・ファイルが収められているディレクトリを開きます
	$i               =  0;
	$file_directory  =  opendir( $whlx[ 'directory' ][ 'data' ] );
	$file_array      =  array();
	$file_array[ 0 ] =  '';
	$file_xhtml      =  '';
	// 
	// 存在しているファイル名を配列に格納し, それを文字列で昇順にソートします. 
	while( true )
	{
		$file_name =  readdir( $file_directory );
		if( $file_name == false                                   ) break;
		if( is_dir( $whlx[ 'directory' ][ 'data' ].  $file_name ) ) continue;
		$file_array[] =  $file_name;
	}
	sort ( $file_array );
	reset( $file_array );
	// 
	// XMLタグの文字列を生成します. このXMLタグは XSLTを使ってXHTMLに変換されます. 
	foreach( $file_array as $data )
	{
		if( $form[ 'fileselect' ] == $data ) $selected =  'true';
		else                                 $selected =  'false';
		$file_xhtml   .= "\t\t\t\t".  sprintf( '<file id="%04d" fileselect="%s" selected="%s" /> ', $i, $data, $selected ).  "\r\n";
		$i++;
	}


	$error   =  1;
	$message =  'Select the File. ';
	$xslt    =  './_script.xsl';

	$others =  "\r\n";
	$others .= "\t\t".  '<title> '.  WHLX_SCRIPT_TITLE.  ' </title> '.  "\r\n";
	$others .= "\t\t".  '<link>'.  $new_filename.  '</link> '.          "\r\n";
	$others .= "\t\t".  '<form> '.  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes  ( $attrbutes );
	$others .= WHLX_PostingXML_FormDataEntered ( $form      );
	$others .= "\t\t".  "\t".  '<fileselect> ' .  "\r\n";
	$others .= $file_xhtml;
	$others .= "\t\t".  "\t".  '</fileselect> '.  "\r\n";
	$others .= "\t\t".  '</form> '.  "\r\n";    
	$others .= WHLX_PostingXML_ResultPreview   ( $form      );


	$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
	$result =  WHLX_ResponseHeader_XML ();
	echo  $output;
}




?>
