<?php
// 
// WHLX CMS - init.php
// 
// 20040330 - 0.00 alpha
// 20040402 - 0.02 alpha    名称変更:whlx_init.php -> init.php etc. 
// 20040402 - 0.03 alpha    アイテム挿入位置を示す mark は不要と考え, コメント・アウト. 
// 20040410 - 0.04 alpha    外部ファイルの整理. ディレクトリ類は 'path.ini', へ移動. 設定類は 'whlx.ini' へ移動. 
// 20040410 - 0.05 alpha    XML/XSLT 形式の出力に変更. それに伴い, '_script.xsl' を作成し, XSLTファイルとして之を指定する. 
// 20040413 - 0.06 alpha    whlx.ini の仕様変更に伴う少々の変更. 
// 20040422 - 0.10 alpha    変数 $script_title -> 定数 WHLX_SCRIPT_TITLE
// 20040502 - 0.11 alpha    ライブラリ domxml.php の変更に伴い, 大幅に変更. domxml.phpは独自クラス化されています. 
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_node.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_document.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

define( 'WHLX_SCRIPT_TITLE', 'WHLX CMS - 初期化スクリプト' );    // 

// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	$error   =  1;
	$message =  'FAILED    : 初期化に失敗しました. ';
	$others  =  '';

	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'initialize' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
	$attribute[ 'lang'    ] =  'ja';

	$others =  "\r\n".    
		'		<title> '.  WHLX_SCRIPT_TITLE.  ' </title> '.                          "\r\n".    
		'		<form password="yes"> '.                                               "\r\n".    
		'			<attribute> '.                                                 "\r\n".    
		'				<action >'.  $attribute[ 'action'  ].  '</action > '.  "\r\n".    
		'				<method >'.  $attribute[ 'method'  ].  '</method > '.  "\r\n".    
		'				<accept >'.  $attribute[ 'accept'  ].  '</accept > '.  "\r\n".    
		'				<charset>'.  $attribute[ 'charset' ].  '</charset> '.  "\r\n".    
		'				<enctype>'.  $attribute[ 'enctype' ].  '</enctype> '.  "\r\n".    
		'				<lang   >'.  $attribute[ 'lang'    ].  '</lang   > '.  "\r\n".    
		'			</attribute> '.                                                "\r\n".    
		'		</form> '.                                                             "\r\n";    

	// function WHLX_PasswordChecker は './utilities.php' の中で記述されている補助関数です. 
	if( !WHLX_PasswordChecker( $form[ 'password' ], $whlx[ 'owner' ][ 'password' ] ) ) return false;

	WHLX_Initializer_ListCategories  ( $whlx );
	WHLX_Initializer_ListArticles    ( $whlx );
	WHLX_Initializer_ListComments    ( $whlx );
	WHLX_Initializer_ListTrackbacks  ( $whlx );
	WHLX_Initializer_InitialCategory ( $whlx );
	WHLX_Initializer_InitialArticle  ( $whlx );
	WHLX_Initializer_ListContents    ( $whlx );
	WHLX_Initializer_ListInformations( $whlx );
	WHLX_Initializer_ListOthers      ( $whlx );

	$error   =  0;
	$message =  'SUCCEEDED : 初期化に成功しました. ';


	return true;
}




function  WHLX_Initializer_ListCategories  ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'categories'   ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'categories'  , null, '' );
	$item =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'title' ][ 'categories' ]             );
	$item->Attribute( 'id'      , '0001'                                      );
	$item->Attribute( 'resource', $ini[ 'initial_category' ][ 'url'         ] );
	$item->Attribute( 'title'   , $ini[ 'initial_category' ][ 'title_short' ] );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'categories'   ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListArticles    ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'articles'     ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'articles'    , null, '' );
	$item =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'title' ][ 'articles'   ]             );
	$item->Attribute( 'id'      , '0001'                                      );
	$item->Attribute( 'resource', $ini[ 'initial_article'  ][ 'url'         ] );
	$item->Attribute( 'title'   , $ini[ 'initial_article'  ][ 'title_short' ] );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'articles'     ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListComments    ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'comments'     ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'comments'    , null, '' );
	$item =  WHLX_DomXML_New_Comment( ' insert item here. ' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'title' ][ 'comments'   ]             );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'comments'     ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListTrackbacks  ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'trackbacks'   ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'trackbacks'  , null, '' );
	$item =  WHLX_DomXML_New_Comment( ' insert item here. ' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'title' ][ 'trackbacks' ]             );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'trackbacks'   ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_InitialCategory ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'cat_0001'     ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'category'    , null, '' );
	$item =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'initial_category' ][ 'title_short' ] );
	$item->Attribute( 'id'      , '0001'                                      );
	$item->Attribute( 'resource', $ini[ 'initial_article'  ][ 'url'         ] );
	$item->Attribute( 'title'   , $ini[ 'initial_article'  ][ 'title_short' ] );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'cat_0001'     ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_InitialArticle  ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'art_0001'     ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'items'       , null, '' );
	$item =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$it   =  WHLX_DomXML_New_Node   ( 'title    '   , null, $ini[ 'initial_article'  ][ 'title'       ] );
	$iu   =  WHLX_DomXML_New_Node   ( 'url      '   , null, $ini[ 'initial_article'  ][ 'url'         ] );
	$ix   =  WHLX_DomXML_New_Node   ( 'text     '   , null, $ini[ 'initial_article'  ][ 'text'        ] );
	$ic   =  WHLX_DomXML_New_Node   ( 'creator  '   , null, $ini[ 'initial_article'  ][ 'creator'     ] );
	$id   =  WHLX_DomXML_New_Node   ( 'date     '   , null, WHLX_DateTimeString()                       );
	$ip   =  WHLX_DomXML_New_Node   ( 'trackback'   , null, $ini[ 'initial_article'  ][ 'trackback'   ] );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );
	$whlx->Register( $list );
	$list->Register( $item );
	$item->Register( $it   );
	$item->Register( $iu   );
	$item->Register( $ix   );
	$item->Register( $ic   );
	$item->Register( $id   );
	$item->Register( $ip   );

	$whlx->Attribute( 'series'  , '0001'                                      );
	$whlx->Attribute( 'category', '0001'                                      );
	$whlx->Attribute( 'title'   , $ini[ 'initial_article'  ][ 'title_short' ] );
	$item->Attribute( 'id'      , '0001'                                      );

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'art_0001'     ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListContents    ( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'contents'     ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'contents'    , null, '' );
	$i_01 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_02 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_03 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_04 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_05 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_06 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_07 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_08 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_09 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_10 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_11 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_12 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_13 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_14 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_15 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_16 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );    $whlx->Attribute( 'series', '0001'                   );    $whlx->Attribute( 'title'   , 'Contents'                );    
	$whlx->Register( $list );    
	$list->Register( $i_01 );    $i_01->Attribute( 'title' , "Index"                  );    $i_01->Attribute( 'resource', "./index.xml"             );    
	$list->Register( $i_02 );    $i_02->Attribute( 'title' , "Recents"                );    $i_02->Attribute( 'resource', "./recents.xml"           );    
	$list->Register( $i_03 );    $i_03->Attribute( 'title' , "Excerpts"               );    $i_03->Attribute( 'resource', "./excerpts.xml"          );    
	$list->Register( $i_04 );    $i_04->Attribute( 'title' , "Contents"               );    $i_04->Attribute( 'resource', "./contents.xml"          );    
	$list->Register( $i_05 );    $i_05->Attribute( 'title' , "Informations"           );    $i_05->Attribute( 'resource', "./informations.xml"      );    
	$list->Register( $i_06 );    $i_06->Attribute( 'title' , "Categories"             );    $i_06->Attribute( 'resource', "./categories.xml"        );    
	$list->Register( $i_07 );    $i_07->Attribute( 'title' , "Articles"               );    $i_07->Attribute( 'resource', "./articles.xml"          );    
	$list->Register( $i_08 );    $i_08->Attribute( 'title' , "Comments"               );    $i_08->Attribute( 'resource', "./comments.xml"          );    
	$list->Register( $i_09 );    $i_09->Attribute( 'title' , "Trackbacks"             );    $i_09->Attribute( 'resource', "./trackbacks.xml"        );    
	$list->Register( $i_10 );    $i_10->Attribute( 'title' , "初期化"                 );    $i_10->Attribute( 'resource', "./script/init.php"       );    
	$list->Register( $i_11 );    $i_11->Attribute( 'title' , "新規投稿"               );    $i_11->Attribute( 'resource', "./script/new.php"        );    
	$list->Register( $i_12 );    $i_12->Attribute( 'title' , "新規投稿 with ファイル" );    $i_12->Attribute( 'resource', "./script/new_upload.php" );    
	$list->Register( $i_13 );    $i_13->Attribute( 'title' , "新規投稿 with 画像"     );    $i_13->Attribute( 'resource', "./script/new_image.php"  );    
	$list->Register( $i_14 );    $i_14->Attribute( 'title' , "返事, コメント"         );    $i_14->Attribute( 'resource', "./script/tb.php"         );    
	$list->Register( $i_15 );    $i_15->Attribute( 'title' , "直接編集"               );    $i_15->Attribute( 'resource', "./script/edit.php"       );    
	$list->Register( $i_16 );    $i_16->Attribute( 'title' , "パスワード生成"         );    $i_16->Attribute( 'resource', "./script/crypt.php"      );    


	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'contents' ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListInformations( $ini )
{
	$root =  WHLX_DomXML_New_Root   ();
	$xml  =  WHLX_DomXML_New_XML    (                                               '1.0', 'UTF-8' );
	$xslt =  WHLX_DomXML_New_XSLT   ( $ini[ 'xslt' ][ 'informations' ], 'text/xsl', '1.0', 'UTF-8' );
	$nb   =  WHLX_DomXML_New_Comment( 'nobanner' );
	$whlx =  WHLX_DomXML_New_Node   ( 'whlx'        , null, '' );
	$list =  WHLX_DomXML_New_Node   ( 'informations', null, '' );
	$i_01 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_02 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_03 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_04 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_05 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_06 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_07 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_08 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_09 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );
	$i_10 =  WHLX_DomXML_New_Node   ( 'item'        , null, '' );

	$root->Register( $xml  );
	$root->Register( $xslt );
	$root->Register( $nb   );
	$root->Register( $whlx );    $whlx->Attribute( 'series', '0001'                   );    $whlx->Attribute( 'title'   , 'Informations' );    
	$whlx->Register( $list );    
	$list->Register( $i_01 );    $i_01->Attribute( 'title' , 'title'                  );    $i_01->Attribute( 'value'   , $ini[ 'informations'  ][ 'title'       ]  );    
	$list->Register( $i_02 );    $i_02->Attribute( 'title' , 'link'                   );    $i_02->Attribute( 'value'   , $ini[ 'informations'  ][ 'link'        ]  );    
	$list->Register( $i_03 );    $i_03->Attribute( 'title' , 'description'            );    $i_03->Attribute( 'value'   , $ini[ 'informations'  ][ 'description' ]  );    
	$list->Register( $i_04 );    $i_04->Attribute( 'title' , 'date'                   );    $i_04->Attribute( 'value'   , WHLX_DateTimeString()                     );    
	$list->Register( $i_05 );    $i_05->Attribute( 'title' , 'creator'                );    $i_05->Attribute( 'value'   , $ini[ 'informations'  ][ 'creator'     ]  );    
	$list->Register( $i_06 );    $i_06->Attribute( 'title' , 'publisher'              );    $i_06->Attribute( 'value'   , $ini[ 'informations'  ][ 'publisher'   ]  );    
	$list->Register( $i_07 );    $i_07->Attribute( 'title' , 'rights'                 );    $i_07->Attribute( 'value'   , $ini[ 'informations'  ][ 'rights'      ]  );    
	$list->Register( $i_08 );    $i_08->Attribute( 'title' , 'language'               );    $i_08->Attribute( 'value'   , $ini[ 'informations'  ][ 'language'    ]  );    

	$output =  $root->Dump();

	WHLX_FileOutput( $output, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'informations' ], WHLX_XML_FILEMODE );    // 
	return $output;
}




function  WHLX_Initializer_ListOthers      ( $ini )
{
	$filedata_index    =  '<?xml            version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'index'    ].  '" ?> '.  "\r\n".  '<whlx title="Index">          '.  "\r\n".  "\t".  '<index />    '.  "\r\n".  '</whlx> '.  "\r\n";
	$filedata_recents  =  '<?xml            version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'recents'  ].  '" ?> '.  "\r\n".  '<whlx title="Recent Entries"> '.  "\r\n".  "\t".  '<recents />  '.  "\r\n".  '</whlx> '.  "\r\n";
	$filedata_excerpts =  '<?xml            version="1.0" encoding="UTF-8" ?> '.  "\r\n".  '<?xml-stylesheet version="1.0" encoding="UTF-8" type="text/xsl" href="'.  $ini[ 'xslt' ][ 'excerpts' ].  '" ?> '.  "\r\n".  '<whlx title="Excerptions">    '.  "\r\n".  "\t".  '<excerpts /> '.  "\r\n".  '</whlx> '.  "\r\n";
	WHLX_FileOutput( $filedata_index   , $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'index'    ], WHLX_XML_FILEMODE );
	WHLX_FileOutput( $filedata_recents , $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'recents'  ], WHLX_XML_FILEMODE );
	WHLX_FileOutput( $filedata_excerpts, $ini[ 'directory' ][ 'data' ].  $ini[ 'filename' ][ 'excerpts' ], WHLX_XML_FILEMODE );
}




?>
