<?php
// 
// WHLX CMS - tb.php 
// 
// 20040416 - 0.00 alpha    
// 20040417 - 0.09 alpha    大幅な変更. 多くの関数を ライブラリ 'postingxml.php' へ移動. 
// 20040422 - 0.10 alpha    変数 $script_title -> 定数 WHLX_SCRIPT_TITLE
// 20040428 - 0.11 alpha    大幅な変更. 多くの関数を ライブラリ 'datacheck.php' へ移動. 
// 20040511 - 0.12 alpha    独自クラスによる domxml の使用開始に伴い, postingxml 系関数への対応を変更. 
// 20040511 - 0.13 alpha    書き込みデータ追加: <resource/> 
// 20040512 - 0.15 alpha    postingxml 関数使用に関連するバグを修正. 
// 




// DOMXML 関連の warning が XML Transform の邪魔をするので, E_WARNING を外します. 
error_reporting( E_ERROR | E_PARSE );

// 'path.ini' を読み込み, 設定ファイルやライブラリ・ファイルの相対パスを取得します. 
// 'path.ini' はスクリプトと同じディレクトリに置く必要があります. 
// 'whlx.ini' には WHLX CMS 全般の設定情報が格納されています. 
// 'whlx.ini' の置場は './path.ini' で指定された隠しディレクトリであり, Web からは見えません. 
$whlx =  parse_ini_file( './path.ini', true );    
$whlx =  array_merge( $whlx, parse_ini_file( $whlx[ 'directory' ][ 'hidden' ].  './whlx.ini', true ) );    

include_once  $whlx[ 'directory' ][ 'library' ].  './utilities.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './formdata.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './datacheck.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_node.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './domxml_document.php';
include_once  $whlx[ 'directory' ][ 'library' ].  './postingxml.php';

define( 'WHLX_XML_FILEMODE', 0744  );    // 
define( 'WHLX_XML_VERSION' , '1.0' );    // 

define( 'WHLX_SCRIPT_TITLE', 'WHLX CMS - Ping受信スクリプト' );    // 

// class WHLX_Formdata は './utilities.php' の中で記述されている補助クラスです. 
// Formdata::form()   でスクリプトに送信された フォーム・データ を取得できます. 返値は配列になります. 
// Formdata::header() でスクリプトに送信された HTTPリクエスト   を取得できます. 返値は配列になります. 
$form =  new WHLX_Formdata();                              // 
$data =  array_merge( $form->header(), $form->form() );    // 
$xslt =  './_script.xsl';                                  // 


$result =  WHLX_Main               ( $error, $message, $others, $whlx, $data );
$output =  WHLX_PostingResponse    ( $error, $message, $others, $xslt );
$result =  WHLX_ResponseHeader_XML ();
echo  $output;


exit;








// WHLX_Main( $error, $message, $others, $whlx, $form );
// // 
function  WHLX_Main( &$error, &$message, &$others, $whlx, $form )
{
	// 関数 WHLX_PostingXML_FormAttributes 関数に於いて, Formタグ生成用の XMLデータに変換されます. 
	// この部分はスクリプトの種類によって変化します. 
	$attribute[ 'action'  ] =  $whlx[ 'script' ][ 'trackback' ].  '?id='.  $form[ 'id' ].  '&amp;comment='.  $form[ 'comment' ];
	$attribute[ 'method'  ] =  'post';
	$attribute[ 'accept'  ] =  'text/plain';
	$attribute[ 'charset' ] =  'UTF-8';
	$attribute[ 'enctype' ] =  'application/x-www-form-urlencoded';
//	$attribute[ 'enctype' ] =  'multipart/form-data';
	$attribute[ 'lang'    ] =  'ja';


	// これらの変数は, 諸々のスクリプトに共通するデータ類です. 
	// new.php 系スクリプトだけでなく, tb.php や ping.php でも使われます. 
	// 各スクリプトに合わせて変数を書き換えて下さい. 
	$form[ 'xslt'         ] =  './_default.xsl';                                                      // 
	$form[ 'new_file'     ] =  $whlx[ 'directory' ][ 'form' ].  './art_XXXX.xml';                     // 
	$form[ 'new_id'       ] =  'XXXX';                                                                // 
	$form[ 'new_resource' ] =  '';                                                                    // 
	$form[ 'new_data'     ] =  '';                                                                    // 
	$form[ 'lst_file'     ] =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'articles' ];    // 
	$form[ 'lst_id'       ] =  'XXXX';                                                                // 
	$form[ 'lst_resource' ] =  './art_XXXX.xml#XXXX';                                                 // 
	$form[ 'lst_data'     ] =  '';                                                                    // 
	$form[ 'cat_file'     ] =  $whlx[ 'directory' ][ 'data' ].  './cat_XXXX.xml';                     // 
	$form[ 'cat_id'       ] =  'XXXX';                                                                // 
	$form[ 'cat_resource' ] =  './art_XXXX.xml#XXXX';                                                 // 
	$form[ 'cat_data'     ] =  '';                                                                    // 


	$error          =  0;
	$message        =  '';


	while( true )
	{
		// ユーザー情報を得ます. 
		$profile   =  WHLX_PostingXML_Profile( $whlx[ 'directory' ][ 'hidden' ], $form[ 'profile' ] );
		if( !is_array( $profile ) ){ $error |= 1;    break; }


		// プロファイル・ファイルを使って, 空文字列入力を雛形に置換します. 
		// この部分はスクリプトの種類によって変化します. 
	//	$result    =  WHLX_PostingXML_ProfileReflector_Article  ( $form, $profile );    
		$result    =  WHLX_PostingXML_ProfileReflector_CT       ( $form, $profile );    
	//	$result    =  WHLX_PostingXML_ProfileReflector_File     ( $form, $profile );    
		if( true != $result    ){ $error |= 1;    break; }


		// フォーム入力されたデータとプロファイルから得たデータをクラスに纏めます. 
		// class WHLX_DataCheck は './datacheck.php' の中で記述されている補助クラスです. 
		$dataclass =  new WHLX_DataCheck( $form, $profile );    // 
		if( null == $dataclass ){ $error |= 1;    break; }


		// フォームを使って送信された文字列の中の「HTMLタグ」「改行コード」を変換します. 
		// フォームを使って送信された文字列の文字数を制限します. 
		// この部分はスクリプトの種類によって変化します. 
	//	$result    =  WHLX_PostingXML_DataConvertor_Article  ( $form, $dataclass );    
		$result    =  WHLX_PostingXML_DataConvertor_CT       ( $form, $dataclass );    
	//	$result    =  WHLX_PostingXML_DataConvertor_File     ( $form, $dataclass );    
		if( true != $result    ){ $error |= 1;    break; }


		// 送信された文字列が空でないかどうか, パスワードを間違えてないかどうか, etc. を調べます. 
		// この部分はスクリプトの種類によって変化します. 
	//	$result    =  WHLX_PostingXML_DataChecker_Article  ( $error, $message, $form, $dataclass );    
		$result    =  WHLX_PostingXML_DataChecker_CT       ( $error, $message, $form, $dataclass );    
	//	$result    =  WHLX_PostingXML_DataChecker_File     ( $error, $message, $form, $dataclass );    
	//	$result    =  WHLX_PostingXML_DataChecker_Ping     ( $error, $message, $form, $dataclass );    
		if( 0    != $error     ){ $error |= 1;    break; }


		// 記事ファイル変更関係の処理はここです. 
		// 記事ID $form[ 'id' ] を元に記事ファイル名 art_????.xml を判断します. 
		// 関数 WHLX_PostingXML_NextID                  を使って, 記事ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_Article を使って, 記事ファイルに記事アイテムを追加します. 
		$form[ 'new_file'     ] =  $whlx[ 'directory' ][ 'data' ].  './art_'.  $form[ 'id' ].  '.xml';    
		$form[ 'new_id'       ] =  WHLX_PostingXML_NextID                 ( $form[ 'new_file' ], 'items',  true  );    
		$form[ 'new_resource' ] =  './art_'.  $form[ 'id' ].  '.xml'.  '#'.  $form[ 'new_id' ];
		$form[ 'new_data'     ] =  WHLX_PostingXML_InsertItem_Into_Article( $form[ 'new_file' ], 'items'  , true , $form );    


		// リスト・ファイル変更関係の処理はここです. 
		// 追記する対象のリスト・ファイルが comment.xml なのか trackbacks.xml なのかを判断します. 
		// リスト・ファイルに於いて使われるハイパー・リンク先を文字列 'lst_resource' を得ます. 
		// 関数 WHLX_PostingXML_NextID                  を使って, リスト・ファイルに追加されるアイテムのアイテムID を得ます. 
		// 関数 WHLX_PostingXML_InsertItem_Into_List    を使って, リスト・ファイルにリスト・アイテムを追加します. 
		if( 'true' != $form[ 'comment' ] ){ $listtag =  'trackbacks';    $form[ 'lst_file' ] =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'trackbacks' ]; }    // Trackback
		else                              { $listtag =  'comments';      $form[ 'lst_file' ] =  $whlx[ 'directory' ][ 'data' ].  $whlx[ 'filename' ][ 'comments'   ]; }    // Comment
		$form[ 'lst_resource' ] =  './art_'.  $form[ 'id' ].  '.xml'.  '#'.  $form[ 'new_id' ];    
		$form[ 'lst_id'       ] =  WHLX_PostingXML_NextID                 ( $form[ 'lst_file' ], $listtag, false );    
		$form[ 'lst_data'     ] =  WHLX_PostingXML_InsertItem_Into_List   ( $form[ 'lst_file' ], $listtag, false, $form );    


		$result                 =  WHLX_FileOutput( $form[ 'lst_data' ], $form[ 'lst_file' ], WHLX_XML_FILEMODE );    // 
		if( true != $result    ){ $error |= 1;    break; }

	//	$result                 =  WHLX_FileOutput( $form[ 'cat_data' ], $form[ 'cat_file' ], WHLX_XML_FILEMODE );    // 
	//	if( true != $result    ){ $error |= 1;    break; }

		$result                 =  WHLX_FileOutput( $form[ 'new_data' ], $form[ 'new_file' ], WHLX_XML_FILEMODE );    // 
		if( true != $result    ){ $error |= 1;    break; }

		break;
	}


	if( $error == 0 ) $message .= "\t\t".  'SUCCEEDED : 書き込みに成功しました.  <br /> '.  "\r\n";    
	else              $message .= "\t\t".  'FAILED    : 書き込みに失敗しました.  <br /> '.  "\r\n";    

	$others .= "\r\n";
	$others .= "\t\t".  '<title> '.  WHLX_SCRIPT_TITLE.    ' </title> '.  "\r\n";
	$others .= "\t\t".  '<link> ' .  $form[ 'new_file' ].  ' </link> ' .  "\r\n";
	$others .= "\t\t".  '<form> ' .  "\r\n";    
	$others .= WHLX_PostingXML_FormAttributes  ( $attribute );
	$others .= WHLX_PostingXML_FormDataEntered ( $form      );
	$others .= "\t\t".  '</form> '.  "\r\n";    
	$others .= WHLX_PostingXML_ResultPreview   ( $form      );

	return  true;
}




?>
