#!/usr/bin/perl
###
require "package/ReadConfig.pl";
require "package/ApInfo.pl";
require "package/ReadForm.pl";
require "package/PrintRedirect.pl";
require "package/PrintHtml.pl";
require "package/Base64.pl";
require "package/ReadTheme.pl";
require "package/ReadLang.pl";
require "package/InsertString.pl";
require "package/WikiEngine.pl";
require "package/UrlUnescape.pl";
require "package/ReadPlugin.pl";

require "package/PageInfo.pl";

require "package/CheckPermission.pl";
require "package/HtmlDelete.pl";
###
die('error') if($PAGEINFO{'fileid'}=~/\// || $PAGEINFO{'fileid'}=~/^\./);
&ReadTheme::read($PAGEINFO{'theme'});
&FileParameter if($PAGEINFO{'fileid'}=~/\./);
$NoUpdate=1;
$PAGEINFO{'baseurl'}="html/$PAGEINFO{'theme'}/";
###
&WriteBlog;
###
sub FileParameter{
	my(@str);
	($PAGEINFO{'fileid'},@str)=split(/\./,$PAGEINFO{'fileid'});
	foreach(@str){
		if(/^(\d+)$/){
			$PAGEINFO{'fileid'}.=".$1";
		}
	}
}
###
sub WriteBlog{
	my($c,$log,$category,$subject,$content,$excerpt,$file,$num,$data,$trackback);
	if(!&CheckPermission::write){
		$PostError=&InsertString::insert($ReadTheme::Theme{"e1"});
		&PrintHtml::ExitScript(&WikiEngine::html);
	}
	$log=$FORM{'LOG'};
	if(!-f("blog/$log.dat")){
		$PostError=&InsertString::insert($ReadTheme::Theme{"e5"});
		&PrintHtml::ExitScript(&WikiEngine::html);
	}
	$subject=&UrlUnescape::unescape($FORM{'SUBJECT'});
	$content=&UrlUnescape::unescape($FORM{'CONTENT'});
	if($content eq '' || $subject eq ''){
		$PostError=&InsertString::insert($ReadTheme::Theme{"e7"});
		&PrintHtml::ExitScript(&WikiEngine::html);
	}
	$excerpt=$content;
	$trackback=&UrlUnescape::unescape($FORM{'trackback'});
	$category=&Base64::decode($log);
	$category=~s/\\/&#92;/g;
	$category=~s/,/\\,/g;
	$category=~s/\)/\\\)/g;
	$c=1;
	while($content=~/\){$c}/){
		$c++;
	}
	$content="("x$c."\n$content\n".")"x$c;
	$file=&Base64::encode($subject);
	if(-e("data/$file.dat")){
		$num=1;
		while(-e("data/$file.$num.dat")){
			$num++;
		}
		$file.=".$num";
	}
	$data=&InsertString::insert($ReadTheme::Theme{"blog-page"},$category,$file,$content);
	open(FILE,"+>data/$file.dat");
	print FILE $data;
	close(FILE);
	&HtmlDelete::delete;
	if($trackback ne ''){
		if(!fork){
			require "package/HttpSend.pl";
			close(STDOUT);
			close(STDERR);
			&SendTrackback($trackback,$subject,$excerpt,$file) if($trackback ne '');
			exit;
		}
	}
	&PrintRedirect::ExitScript("html/$PAGEINFO{'theme'}/$file.html");
}
###
sub SendTrackback{
	my($i,$post,@trackback,$title,$excerpt,$file,$url,$blog_name);
	@trackback=split(/\r?\n/,shift(@_));
	($title,$excerpt,$file)=@_;
	$url="http://$ENV{'SERVER_NAME'}$ENV{'REQUEST_URI'}";
	$url=~s/[^\/]+$//;
	$url.="html/$PAGEINFO{'theme'}/$file.html";
	$blog_name=$PAGEINFO{'toptext'};
	$title=&UrlUnescape::encode($title);
	$blog_name=&UrlUnescape::encode($blog_name);
	if(length($excerpt)>255){
		$excerpt=substr($excerpt,0,252);
		$excerpt.="...";
	}
	$excerpt=&UrlUnescape::encode($excerpt);
	$post="title=$title&url=$url&excerpt=$excerpt&blog_name=$blog_name";
	foreach $i(@trackback){
		$i=~s/\s+//g;
		next if($i eq '');
		&HttpSend::HttpPost($i,$post);
	}
}
###



