//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDMWINDEV_H
#define WSDMWINDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDmwindowDev :public WSDdev{

  protected: 
    WSCushort _w;
    WSCushort _h;

  public: 
    WSDmwindowDev();
    virtual WSCbool getReady();
    virtual long beginDraw(short,short,WSCushort,WSCushort,WSCbool absolute = True,WSCbool scaling = True);
    virtual long endDraw();
    void getGeometry(WSCushort* w,WSCushort* h);

    virtual long createPixmap(WSCushort w,WSCushort h) = 0;
    virtual long destroyPixmap() = 0;

    virtual long copyToWindow(WSDdev*,short x,short y,WSCushort w,WSCushort h,
                              short dx,short dy) = 0;
    virtual long copyFromWindow(WSDdev*,short x,short y,WSCushort w,WSCushort h,
                              short dx,short dy) = 0;
    virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDimage*) = 0;
    virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDmwindowDev*) = 0;

    virtual long initBuffer() = 0;
    virtual long setBufferRGB(WSCushort x,WSCushort y,
                              WSCuchar r,WSCuchar g,WSCuchar b) = 0;
    virtual long getBufferRGB(WSCushort x,WSCushort y,
                              WSCuchar* r,WSCuchar* g,WSCuchar* b) = 0;
    virtual long putBufferToPixmap() = 0;
    WSCuchar* getBuffer();
    long setBuffer(WSCuchar*);
    virtual long loadFile(char*);
    virtual long saveFile(char*,long);

static WSDmwindowDev* getNewInstance();
    WSMFclassDef(WSDmwindowDev,WSDdev);
};
#endif //WSDMWINDEV_H
