//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVARIANT_H
#define WSCVARIANT_H
#include <WScom.h>

class WSCvariant{

  protected:
    void* _data;
    char* _data2;
    char* _type_name;
    signed char _type;

  public:
    WSCvariant();
    WSCvariant(char);
    WSCvariant(WSCuchar);
    WSCvariant(short);
    WSCvariant(WSCushort);
    WSCvariant(int);
    WSCvariant(WSCuint);
    WSCvariant(long);
    WSCvariant(WSCulong);
    WSCvariant(float);
    WSCvariant(double);
    WSCvariant(void*);
    WSCvariant(void*,char* tname=NULL);
    WSCvariant(const WSCvariant&);
    WSCvariant(char*);
    WSCvariant(WSCbase*);
//    WSCvariant(WSCstring);

    virtual ~WSCvariant();

    char getChar();
    WSCuchar getUnsignedChar();
    short getShort();
    WSCushort getUnsignedShort();
    long getLong();
    WSCulong getUnsignedLong();
    int getInt();
    WSCuint getUnsignedInt();
    float getFloat();
    double getDouble();
    void* getVoidPtr();
    char* getCharPtr();
    WSCbase* getInstancePtr();

    void setValue(char);
    void setValue(WSCuchar);
    void setValue(short);
    void setValue(WSCushort);
    void setValue(long);
    void setValue(WSCulong);
    void setValue(int);
    void setValue(WSCuint);
    void setValue(char*);
    void setValue(void*,char* cname=NULL);
    void setValue(float);
    void setValue(double);
    void setValue(WSCbase*);

    long getType();
    char* getTypeName();
    void clear();

    WSCvariant& operator= (const WSCvariant&);
    WSCvariant& operator= (char);
    WSCvariant& operator= (WSCuchar);
    WSCvariant& operator= (short);
    WSCvariant& operator= (WSCushort);
    WSCvariant& operator= (long);
    WSCvariant& operator= (WSCulong);
    WSCvariant& operator= (int);
    WSCvariant& operator= (WSCuint);
    WSCvariant& operator= (void*);
    WSCvariant& operator= (char*);
    WSCvariant& operator= (float);
    WSCvariant& operator= (double);
    WSCvariant& operator= (WSCbase*);
//    WSCvariant& operator= (WSCstring);

    operator char();
    operator WSCuchar();
    operator short();
    operator WSCushort();
    operator long();
    operator WSCulong();
    operator int();
    operator WSCuint();
    operator void*();
    operator char*();
    operator float();
    operator double();
    operator WSCbase*();
//    operator WSCstring();
};
#endif
